/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.security;

import java.security.Permission;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.facilities.EventRegistryPermission;
import javacardx.facilities.ServiceRegistryPermission;
import javacardx.framework.ContextPermission;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.io.ConnectorPermission;
import javacardx.security.URIPermission;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class PermissionSet {
    private Vector<Permission> pSet = new Vector();

    public PermissionSet() {
    }

    public PermissionSet(PermissionSet s) {
        Enumeration<Permission> e = s.elements();
        while (e.hasMoreElements()) {
            Permission p = e.nextElement();
            this.pSet.addElement(p);
        }
    }

    public void add(Permission permission) {
        this.pSet.addElement(permission);
    }

    public void add(PermissionSet s) {
        Enumeration<Permission> e = s.elements();
        while (e.hasMoreElements()) {
            this.add(e.nextElement());
        }
    }

    public boolean implies(Permission q) {
        if (q.getActions() == null || q.getActions().equals("")) {
            Enumeration<Permission> e = this.elements();
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                if (!p.implies(q)) continue;
                return true;
            }
            return false;
        }
        String actions = q.getActions();
        Vector<String> v = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(actions, ",");
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            v.addElement(s);
        }
        block2: for (String s : v) {
            Permission qq = this.createPermission(q, s);
            Enumeration<Permission> e = this.elements();
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                if (!p.implies(qq)) continue;
                continue block2;
            }
            return false;
        }
        return true;
    }

    private Permission createPermission(Permission p, String action) {
        if (p instanceof ConnectorPermission) {
            return new ConnectorPermission(p.getName(), action);
        }
        if (p instanceof ContextPermission) {
            return new ContextPermission(p.getName(), action);
        }
        if (p instanceof EventRegistryPermission) {
            return new EventRegistryPermission(p.getName(), action);
        }
        if (p instanceof ServiceRegistryPermission) {
            return new ServiceRegistryPermission(p.getName(), action);
        }
        if (p instanceof URIPermission) {
            return new URIPermission(p.getName(), action);
        }
        return null;
    }

    public boolean remove(Permission permission) {
        return this.pSet.removeElement(permission);
    }

    public boolean isEmpty() {
        return this.pSet.isEmpty();
    }

    public Enumeration<Permission> elements() {
        return this.pSet.elements();
    }
}

