/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.security;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jcre.JCRuntime;
import com.sun.midp.pki.X509Certificate;
import javacard.security.Key;
import javacard.security.PrivateKey;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.security.CredentialManager;
import javax.microedition.pki.Certificate;
import javax.microedition.pki.CertificateException;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class X509CredentialManager
extends CredentialManager {
    private PrivateKey privateKey;
    private X509Certificate[] certificateChain;
    private X509Certificate[] trustedCertificates;
    private X509Certificate[] acceptedIssuers;

    public X509CredentialManager(PrivateKey privateKey, X509Certificate[] certificateChain, X509Certificate[] trustedCertificates, X509Certificate[] acceptedIssuers) {
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
        this.trustedCertificates = trustedCertificates;
        this.acceptedIssuers = acceptedIssuers;
    }

    public void preemptOwnership() {
        NativeMethods.transferOwnershipUsingSecondObject(this.privateKey, this);
        NativeMethods.transferOwnershipUsingSecondObject(this.certificateChain, this);
        for (X509Certificate c : this.certificateChain) {
            NativeMethods.transferOwnershipUsingSecondObject(c, this);
        }
        NativeMethods.transferOwnershipUsingSecondObject(this.trustedCertificates, this);
        for (X509Certificate c : this.trustedCertificates) {
            NativeMethods.transferOwnershipUsingSecondObject(c, this);
        }
    }

    @Override
    public void checkTrusted(Certificate[] certificateChain, String authType, String endpointURI, byte mode) throws CertificateException {
        for (int i = 0; i < certificateChain.length; ++i) {
            Certificate certificate = certificateChain[i];
            for (X509Certificate trustedCertificate : mode == 2 ? this.trustedCertificates : this.acceptedIssuers) {
                if (!((Object)trustedCertificate).equals(certificate) && !certificate.getIssuer().equals(trustedCertificate.getSubject())) continue;
                return;
            }
        }
        throw new CertificateException(certificateChain[certificateChain.length - 1], 8);
    }

    @Override
    public Certificate[] getAcceptedCertificateIssuers(String endpointURI, byte mode) {
        return this.acceptedIssuers;
    }

    @Override
    public Certificate[] chooseCertificateChain(String[] types, String[] issuers, String endpointURI, byte mode) {
        return this.certificateChain;
    }

    @Override
    public byte[] choosePreSharedKey(String pskIdentity, String endpointURI, byte mode) {
        return new byte[]{0};
    }

    @Override
    public String getPSKIdentityHint(String endpointURI, byte mode) {
        return JCRuntime.getConfigProperty("PSKIdentityHint", null);
    }

    @Override
    public String getPSKIdentity(String hint, String endpointURI, byte mode) {
        if (this.certificateChain.length > 0) {
            return this.certificateChain[0].getSubject();
        }
        return null;
    }

    @Override
    public PrivateKey getMatchingPrivateKey(Certificate certificate, String endpointURI, byte mode) {
        if (this.certificateChain.length > 0 && certificate.equals(this.certificateChain[0])) {
            return this.privateKey;
        }
        return null;
    }

    @Override
    public Object[] getTrustedCredentials(String[] aliases, String endpointURI, byte mode) {
        if (mode == 5) {
            return this.certificateChain;
        }
        if (mode == 2) {
            return this.trustedCertificates;
        }
        return null;
    }

    @Override
    public Key[] getCredentials(String[] types, String endpointURI, byte mode) {
        if (mode == 4) {
            return new Key[]{this.privateKey};
        }
        return null;
    }
}

