/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import com.sun.javacard.impl.NativeMethods;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class PathLookupTable<T> {
    Hashtable<String, Vector<Entry>> table = new Hashtable();
    public static final String SERVICE_STANDARD_URI = "sio:///standard/";

    public void insert(String registerer, String uri, T resource, String sourceURI) {
        Entry entry;
        Vector<Entry> v = this.table.get(uri);
        if (v == null) {
            v = new Vector();
            this.table.put(uri, v);
        }
        if (!v.contains(entry = new Entry(registerer, resource, sourceURI))) {
            v.addElement(entry);
        }
    }

    public void clear(String uri) {
        if (this.table.containsKey(uri)) {
            Vector<Entry> v = this.table.get(uri);
            v.removeAllElements();
        }
    }

    public void remove(String uri) {
        this.table.remove(uri);
    }

    public void remove(String registerer, String sourceURI, String uri) {
        Vector<Entry> v = this.table.get(uri);
        byte previousContext = NativeMethods.getPreviousContext();
        for (int i = v.size() - 1; i >= 0; --i) {
            String s = v.elementAt(i).getSourceURI();
            String res = v.elementAt(i).getRegisterer();
            Object r = v.elementAt(i).getResource();
            int objectContext = NativeMethods.objectContext(r);
            if (previousContext != objectContext || (sourceURI != null || s != null) && (sourceURI == null || !sourceURI.equals(s) || !registerer.equals(res))) continue;
            v.removeElementAt(i);
        }
    }

    public void deleteEntries(String appURI) {
        Enumeration<String> uris = this.table.keys();
        while (uris.hasMoreElements()) {
            String uri = uris.nextElement();
            Vector<Entry> v = this.table.get(uri);
            for (int i = v.size() - 1; i >= 0; --i) {
                String r = v.elementAt(i).getRegisterer();
                if (r == null || !r.equals(appURI)) continue;
                v.removeElementAt(i);
            }
            if (v.size() != 0) continue;
            this.table.remove(uri);
        }
    }

    public boolean containsDependency(short[] appList) {
        Enumeration<String> uris = this.table.keys();
        while (uris.hasMoreElements()) {
            String uri = uris.nextElement();
            Vector<Entry> v = this.table.get(uri);
            for (int i = v.size() - 1; i >= 0; --i) {
                Object resource = v.elementAt(i).getResource();
                if (!this.contains(appList, NativeMethods.objectOwner(resource))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(short[] appList, int appId) {
        if (appList != null) {
            for (int i = 0; i < appList.length; ++i) {
                if (appList[i] != appId) continue;
                return true;
            }
        }
        return false;
    }

    public void remove(String registerer, String uri, T resource, String sourceURI) {
        if (this.table.containsKey(uri)) {
            this.table.get(uri).removeElement(new Entry(registerer, resource, sourceURI));
        }
    }

    public Enumeration<Entry> lookup(String uri) {
        Vector<Entry> v = new Vector<Entry>();
        Enumeration<String> enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String s = enumeration.nextElement();
            if (!this.implies(s, uri)) continue;
            Vector<Entry> w = this.table.get(s);
            for (Entry e : w) {
                v.addElement(e);
            }
        }
        return v.elements();
    }

    public Enumeration<T> elements() {
        Vector v = new Vector();
        Enumeration<Vector<Entry>> enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            Vector<Entry> w = enumeration.nextElement();
            for (Entry e : w) {
                v.addElement(e.resource);
            }
        }
        return v.elements();
    }

    private boolean implies(String p, String q) {
        if (p.endsWith("*")) {
            String baseName = p.substring(0, p.length() - 1);
            return q.length() > baseName.length() && q.startsWith(baseName);
        }
        return p.equals(q);
    }

    public boolean containsStandardURI(String appURI) {
        Enumeration<String> uris = this.table.keys();
        while (uris.hasMoreElements()) {
            String uri = uris.nextElement();
            if (!uri.startsWith(SERVICE_STANDARD_URI)) continue;
            Vector<Entry> v = this.table.get(uri);
            for (int i = v.size() - 1; i >= 0; --i) {
                String r = v.elementAt(i).getRegisterer();
                if (r == null || !r.equals(appURI)) continue;
                return true;
            }
        }
        return false;
    }

    public Vector<String> getStandardURI(String appURI) {
        Vector<String> list = new Vector<String>();
        Enumeration<String> uris = this.table.keys();
        while (uris.hasMoreElements()) {
            String uri = uris.nextElement();
            if (!uri.startsWith(SERVICE_STANDARD_URI)) continue;
            Vector<Entry> v = this.table.get(uri);
            for (int i = v.size() - 1; i >= 0; --i) {
                String r = v.elementAt(i).getRegisterer();
                if (r == null || !r.equals(appURI)) continue;
                list.addElement(uri);
            }
        }
        return list;
    }

    public class Entry {
        String registerer;
        T resource;
        String sourceURI;

        Entry(String registerer, T resource, String sourceURI) {
            this.registerer = registerer;
            this.resource = resource;
            this.sourceURI = sourceURI;
        }

        public String getRegisterer() {
            return this.registerer;
        }

        public T getResource() {
            return this.resource;
        }

        public String getSourceURI() {
            return this.sourceURI;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.registerer == null ? other.registerer != null : !this.registerer.equals(other.registerer)) {
                return false;
            }
            if (!(this.resource == other.resource || this.resource != null && this.resource.equals(other.resource))) {
                return false;
            }
            return !(this.sourceURI == null ? other.sourceURI != null : !this.sourceURI.equals(other.sourceURI));
        }

        public int hashCode() {
            return this.registerer.hashCode() + this.resource.hashCode() + this.sourceURI.hashCode();
        }
    }
}

