/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import com.sun.cldc.io.Waiter;
import com.sun.midp.io.ConnectionBaseAdapter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class BaseOutputStream
extends OutputStream {
    ConnectionBaseAdapter parent;
    byte[] buf = new byte[1];

    BaseOutputStream(ConnectionBaseAdapter p) {
        this.parent = p;
    }

    private void ensureOpen() throws InterruptedIOException {
        if (this.parent == null) {
            throw new InterruptedIOException("Stream closed");
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.buf[0] = (byte)b;
        this.write(this.buf, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (len == 0) {
            return;
        }
        int bytesWritten = 0;
        while (true) {
            try {
                bytesWritten += this.parent.writeBytes(b, off + bytesWritten, len - bytesWritten);
            }
            finally {
                if (this.parent == null) {
                    throw new InterruptedIOException("Stream closed");
                }
            }
            if (bytesWritten == len) break;
            Waiter.waitForIO();
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.parent.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.parent != null) {
            this.parent.closeOutputStream();
            this.parent = null;
        }
    }
}

