/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HttpUrl {
    public String scheme;
    public String authority;
    public String path;
    public String query;
    public String fragment;
    public String host;
    public int port = -1;
    public String machine;
    public String domain;

    public HttpUrl(String url) {
        int afterScheme = 0;
        if (url == null) {
            return;
        }
        int length = url.length();
        if (length == 0) {
            return;
        }
        int endOfScheme = url.indexOf(58);
        if (endOfScheme != -1) {
            if (endOfScheme == length - 1) {
                this.scheme = url.substring(0, endOfScheme);
                return;
            }
            if (endOfScheme < length - 2 && url.charAt(endOfScheme + 1) == '/' && url.charAt(endOfScheme + 2) == '/') {
                this.scheme = url.substring(0, endOfScheme);
                afterScheme = endOfScheme + 1;
            }
        }
        this.parseAfterScheme(url, afterScheme, length);
    }

    public HttpUrl(String theScheme, String partialUrl) {
        this.scheme = theScheme;
        if (partialUrl == null) {
            return;
        }
        int length = partialUrl.length();
        if (length == 0) {
            return;
        }
        this.parseAfterScheme(partialUrl, 0, length);
    }

    private void parseAfterScheme(String url, int afterScheme, int length) {
        int endOfHost;
        int endOfUrl;
        if (url.indexOf(32) != -1) {
            throw new IllegalArgumentException("Space character in URL");
        }
        int endOfAuthority = endOfUrl = length;
        int endOfPath = endOfUrl;
        int endOfQuery = endOfUrl;
        int startOfAuthority = url.startsWith("//", afterScheme) ? afterScheme + 2 : afterScheme;
        int start = url.indexOf(35, startOfAuthority);
        if (start != -1) {
            endOfAuthority = start;
            endOfPath = start;
            endOfQuery = start++;
            if (start < endOfUrl) {
                this.fragment = url.substring(start, endOfUrl);
            }
        }
        if ((start = url.indexOf(63, startOfAuthority)) != -1 && start < endOfQuery) {
            endOfAuthority = start;
            endOfPath = start++;
            if (start < endOfQuery) {
                this.query = url.substring(start, endOfQuery);
            }
        }
        if ((start = startOfAuthority == afterScheme ? afterScheme : url.indexOf(47, startOfAuthority)) != -1 && start < endOfPath) {
            endOfAuthority = start;
            this.path = url.substring(start, endOfPath);
        }
        if (startOfAuthority >= endOfAuthority) {
            return;
        }
        this.authority = url.substring(startOfAuthority, endOfAuthority);
        int endOfPort = this.authority.length();
        start = this.authority.indexOf(93);
        int startOfPort = start == -1 ? this.authority.indexOf(58) : this.authority.indexOf(58, start);
        if (startOfPort != -1) {
            endOfHost = startOfPort++;
            if (startOfPort < endOfPort) {
                try {
                    this.port = Integer.parseInt(this.authority.substring(startOfPort, endOfPort));
                    if (this.port <= 0) {
                        throw new IllegalArgumentException("invalid port format");
                    }
                    if (this.port == 0 || this.port > 65535) {
                        throw new IllegalArgumentException("port out of legal range");
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("invalid port format");
                }
            }
        } else {
            endOfHost = endOfPort;
        }
        if (endOfHost < 1) {
            return;
        }
        this.host = this.authority.substring(0, endOfHost);
        if (Character.isDigit(this.host.charAt(0)) || this.host.charAt(0) == '[') {
            return;
        }
        int startOfDomain = this.host.indexOf(46);
        if (startOfDomain != -1) {
            this.domain = this.host.substring(startOfDomain + 1, this.host.length());
            this.machine = this.host.substring(0, startOfDomain);
        } else {
            this.machine = this.host;
        }
    }

    public void addBaseUrl(String baseUrl) {
        this.addBaseUrl(new HttpUrl(baseUrl));
    }

    public void addBaseUrl(HttpUrl baseUrl) {
        if (this.authority != null) {
            return;
        }
        this.scheme = baseUrl.scheme;
        this.authority = baseUrl.authority;
        if (this.path == null) {
            this.path = baseUrl.path;
            return;
        }
        if (this.path.charAt(0) == '/' || baseUrl.path == null || baseUrl.path.charAt(0) != '/') {
            return;
        }
        String basePath = baseUrl.path.substring(0, baseUrl.path.lastIndexOf(47));
        this.path = basePath + '/' + this.path;
    }

    public String normalize(int defaultPort, boolean supportsPath) {
        StringBuffer url = new StringBuffer();
        if (this.scheme != null) {
            url.append(this.scheme);
            url.append(':');
        }
        if (this.authority != null) {
            url.append('/');
            url.append('/');
            if (this.host != null) {
                url.append(this.host);
            }
            if (this.port != -1 && this.port != defaultPort) {
                url.append(':');
                url.append(this.port);
            }
        }
        if (supportsPath) {
            if (this.path != null) {
                url.append(this.path);
                if (this.query != null) {
                    url.append('?');
                    url.append(this.query);
                }
                if (this.fragment != null) {
                    url.append('#');
                    url.append(this.fragment);
                }
            } else {
                url.append("/");
            }
        }
        return url.toString();
    }

    public String toString() {
        StringBuffer url = new StringBuffer();
        if (this.scheme != null) {
            url.append(this.scheme);
            url.append(':');
        }
        if (this.authority != null) {
            url.append('/');
            url.append('/');
            url.append(this.authority);
        }
        if (this.path != null) {
            url.append(this.path);
        }
        if (this.query != null) {
            url.append('?');
            url.append(this.query);
        }
        if (this.fragment != null) {
            url.append('#');
            url.append(this.fragment);
        }
        return url.toString();
    }
}

