/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Properties {
    private static int INITIAL_SIZE = 10;
    private Vector<String> keys = new Vector(INITIAL_SIZE);
    private Vector<String> vals = new Vector(INITIAL_SIZE);

    public synchronized void addProperty(String key, String value) {
        this.keys.addElement(key);
        this.vals.addElement(value);
    }

    public synchronized String setProperty(String key, String value) {
        int idx = this.keys.indexOf(key);
        String rv = null;
        if (idx == -1) {
            this.keys.addElement(key);
            this.vals.addElement(value);
        } else {
            rv = this.vals.elementAt(idx);
            this.vals.setElementAt(value, idx);
        }
        return rv;
    }

    public synchronized String setPropertyAt(int index, String value) {
        String rv = this.vals.elementAt(index);
        this.vals.setElementAt(value, index);
        return rv;
    }

    public String getProperty(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        int idx = this.keys.indexOf(key);
        String rv = null;
        if (idx > -1) {
            rv = this.vals.elementAt(idx);
        }
        return rv;
    }

    public String getValueAt(int index) {
        return this.vals.elementAt(index);
    }

    public String getKeyAt(int index) {
        return this.keys.elementAt(index);
    }

    public int size() {
        return this.keys.size();
    }

    public synchronized String removeProperty(String key) {
        int idx = this.keys.indexOf(key);
        String rv = null;
        if (idx > -1) {
            rv = this.vals.elementAt(idx);
            this.keys.removeElementAt(idx);
            this.vals.removeElementAt(idx);
        }
        return rv;
    }

    public void loadFromInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        int colonIndex = 0;
        String name = null;
        String value = null;
        try {
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                colonIndex = line.indexOf(61);
                if (colonIndex == -1) {
                    colonIndex = line.indexOf(58);
                }
                if (colonIndex == -1) continue;
                name = line.substring(0, colonIndex);
                value = line.substring(colonIndex + 1);
                this.setProperty(name, value);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Enumeration<String> keys() {
        return this.keys.elements();
    }
}

