/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.https;

import com.sun.midp.io.Properties;
import com.sun.midp.io.j2me.http.StreamConnectionElement;
import com.sun.midp.main.Configuration;
import com.sun.midp.pki.X509Certificate;
import com.sun.midp.ssl.SSLStreamConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javacardx.framework.JCSystem;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.HttpsConnection;
import javax.microedition.io.SecurityInfo;
import javax.microedition.io.StreamConnection;
import javax.microedition.pki.CertificateException;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public final class Protocol
extends com.sun.midp.io.j2me.http.Protocol
implements HttpsConnection {
    private static final String COMMON_NAME_LABEL = "CN=";
    private static final int COMMON_NAME_LABEL_LENGTH = "CN=".length();
    private Properties proxyHeaders = new Properties();
    private SSLStreamConnection sslConnection;

    private static String getCommonName(String name) {
        if (name == null) {
            return null;
        }
        int start = name.indexOf(COMMON_NAME_LABEL);
        if (start < 0) {
            return null;
        }
        int end = name.indexOf(59, start += COMMON_NAME_LABEL_LENGTH);
        if (end < 0) {
            end = name.length();
        }
        return name.substring(start, end);
    }

    private static boolean checkSiteName(String siteName, String certName) {
        if (certName == null) {
            return false;
        }
        if (siteName.length() == certName.length() && siteName.regionMatches(true, 0, certName, 0, certName.length())) {
            return true;
        }
        if (!certName.startsWith("*.")) {
            return false;
        }
        int startOfDomain = siteName.indexOf(46);
        if (startOfDomain == -1) {
            return false;
        }
        int domainLength = siteName.length() - ++startOfDomain;
        if (certName.length() - 2 != domainLength) {
            return false;
        }
        return siteName.regionMatches(true, startOfDomain, certName, 2, domainLength);
    }

    public Protocol() {
        this.protocol = "https";
        this.default_port = 443;
    }

    @Override
    public String getRequestProperty(String key) {
        if (key.startsWith("Proxy-")) {
            return this.proxyHeaders.getProperty(key);
        }
        return super.getRequestProperty(key);
    }

    @Override
    protected void setRequestField(String key, String value) {
        if (key.startsWith("Proxy-")) {
            this.proxyHeaders.setProperty(key, value);
            return;
        }
        super.setRequestField(key, value);
    }

    @Override
    protected StreamConnection connect() throws IOException {
        InputStream tcpInputStream;
        OutputStream tcpOutputStream;
        com.sun.midp.io.j2me.socket.Protocol tcpConnection = new com.sun.midp.io.j2me.socket.Protocol(this.protocol, this.default_port, true);
        String httpsTunnel = Configuration.getProperty("com.sun.javacard.io.http.proxy");
        if (httpsTunnel != null) {
            tcpConnection.openPrim("//" + httpsTunnel);
            tcpConnection.setSocketOption((byte)0, 0);
            tcpOutputStream = tcpConnection.openOutputStream();
            tcpInputStream = tcpConnection.openInputStream();
            try {
                this.doTunnelHandshake(tcpOutputStream, tcpInputStream);
            }
            catch (IOException ioe) {
                String temp = ioe.getMessage();
                tcpConnection.close();
                tcpOutputStream.close();
                tcpInputStream.close();
                if (temp.indexOf(" 500 ") > -1) {
                    throw new ConnectionNotFoundException(temp);
                }
                throw ioe;
            }
        } else {
            tcpConnection.openPrim("//" + this.hostAndPort);
            tcpConnection.setSocketOption((byte)0, 0);
            tcpOutputStream = tcpConnection.openOutputStream();
            tcpInputStream = tcpConnection.openInputStream();
        }
        tcpConnection.close();
        try {
            String endpointURI = this.url.normalize(this.default_port, true);
            this.sslConnection = new SSLStreamConnection(endpointURI, this.url.host, this.url.port, tcpInputStream, tcpOutputStream, 2, JCSystem.getURI());
        }
        catch (Exception e) {
            try {
                tcpInputStream.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                tcpOutputStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
        try {
            X509Certificate serverCert = this.sslConnection.getServerCertificate();
            if (serverCert.getSubjectAltNameType() == 2) {
                if (!Protocol.checkSiteName(this.url.host, (String)serverCert.getSubjectAltName())) {
                    throw new CertificateException("Subject alternative name did not match site name", serverCert, 7);
                }
            } else {
                String cname = Protocol.getCommonName(serverCert.getSubject());
                if (cname == null) {
                    throw new CertificateException("Common name missing from subject name", serverCert, 7);
                }
                if (!Protocol.checkSiteName(this.url.host, cname)) {
                    throw new CertificateException(serverCert, 7);
                }
            }
            return this.sslConnection;
        }
        catch (Exception e) {
            try {
                this.sslConnection.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.sslConnection != null) {
            this.sslConnection.close();
        }
        this.sslConnection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disconnect(StreamConnection connection, InputStream inputStream, OutputStream outputStream) {
        try {
            try {
                inputStream.close();
            }
            finally {
                try {
                    outputStream.close();
                }
                finally {
                    connection.close();
                }
            }
        }
        catch (IOException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @Override
    public SecurityInfo getSecurityInfo() throws IOException {
        this.ensureOpen();
        this.sendRequest();
        if (this.sslConnection == null) {
            StreamConnection sc = ((StreamConnectionElement)this.getStreamConnection()).getBaseConnection();
            return ((SSLStreamConnection)sc).getSecurityInfo();
        }
        return this.sslConnection.getSecurityInfo();
    }
}

