/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public final class StringBuilder {
    char[] value;
    int count;
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    public StringBuilder() {
        this(16);
    }

    public StringBuilder(int capacity) {
        this.value = new char[capacity];
    }

    public StringBuilder(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            char[] newValue = new char[this.count];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.value.length) {
            this.expandCapacity(newLength);
        }
        if (this.count < newLength) {
            while (this.count < newLength) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = newLength;
        }
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public StringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public StringBuilder append(String str) {
        int len;
        if (str == null) {
            str = "null";
        }
        if ((len = str.length()) == 0) {
            return this;
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        String.getChars(str, 0, len, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public StringBuilder append(StringBuffer sb) {
        if (sb == null) {
            return this.append("null");
        }
        int len = sb.length();
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public StringBuilder append(char[] str) {
        int newCount = this.count + str.length;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(str, 0, this.value, this.count, str.length);
        this.count = newCount;
        return this;
    }

    public StringBuilder append(char[] str, int offset, int len) {
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newCount;
        return this;
    }

    public StringBuilder append(boolean b) {
        if (b) {
            int newCount = this.count + 4;
            if (newCount > this.value.length) {
                this.expandCapacity(newCount);
            }
            this.value[this.count++] = 116;
            this.value[this.count++] = 114;
            this.value[this.count++] = 117;
            this.value[this.count++] = 101;
        } else {
            int newCount = this.count + 5;
            if (newCount > this.value.length) {
                this.expandCapacity(newCount);
            }
            this.value[this.count++] = 102;
            this.value[this.count++] = 97;
            this.value[this.count++] = 108;
            this.value[this.count++] = 115;
            this.value[this.count++] = 101;
        }
        return this;
    }

    public StringBuilder append(char c) {
        int newCount = this.count + 1;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        this.value[this.count++] = c;
        return this;
    }

    public StringBuilder append(int i) {
        if (i == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        this.append(Integer.toString(i));
        return this;
    }

    static int stringSizeOfInt(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public StringBuilder append(long l) {
        if (l == Long.MIN_VALUE) {
            this.append("-9223372036854775808");
            return this;
        }
        this.append(Long.toString(l));
        return this;
    }

    static int stringSizeOfLong(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public StringBuilder delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public StringBuilder deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public StringBuilder replace(int start, int end, String str) {
        int len;
        int newCount;
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (end > this.count) {
            end = this.count;
        }
        if (end > this.count) {
            end = this.count;
        }
        if ((newCount = this.count + (len = str.length()) - (end - start)) > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        str.getChars(0, str.length(), this.value, start);
        this.count = newCount;
        return this;
    }

    public StringBuilder insert(int index, char[] str, int offset, int len) {
        if (index < 0 || index > this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (offset < 0 || len < 0 || offset > str.length - len) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ", len " + len + ", str.length " + str.length);
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(str, offset, this.value, index, len);
        this.count = newCount;
        return this;
    }

    public StringBuilder insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public StringBuilder insert(int offset, String str) {
        int len;
        int newCount;
        if (offset < 0 || offset > this.length()) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (str == null) {
            str = "null";
        }
        if ((newCount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, str.length(), this.value, offset);
        this.count = newCount;
        return this;
    }

    public StringBuilder insert(int offset, char[] str) {
        if (offset < 0 || offset > this.length()) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        int len = str.length;
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count = newCount;
        return this;
    }

    public StringBuilder insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public StringBuilder insert(int offset, char c) {
        int newCount = this.count + 1;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newCount;
        return this;
    }

    public StringBuilder insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public StringBuilder insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public StringBuilder reverse() {
        int n = this.count - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }
}

