/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.sun.javacard.appletcontainer.AppletServer;
import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PrivAccess;
import com.sun.javacard.util.JCSystemAccessor;
import javacard.framework.AID;
import javacard.framework.Shareable;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public final class JCSystem {
    private static final short API_VERSION = 768;
    public static final byte MEMORY_TYPE_PERSISTENT = 0;
    public static final byte MEMORY_TYPE_TRANSIENT_RESET = 1;
    public static final byte MEMORY_TYPE_TRANSIENT_DESELECT = 2;
    public static final byte ARRAY_TYPE_BOOLEAN = 1;
    public static final byte ARRAY_TYPE_BYTE = 2;
    public static final byte ARRAY_TYPE_SHORT = 3;
    public static final byte ARRAY_TYPE_INT = 4;
    public static final byte ARRAY_TYPE_OBJECT = 5;
    static PrivAccess thePrivAccess = PrivAccess.getPrivAccess();
    static JCSystemAccessor jcAccessor = JCSystemAccessor.getJCSystemAccessor();
    private static final boolean GC_SUPPORTED = true;
    public static final byte NOT_A_TRANSIENT_OBJECT = 0;
    public static final byte CLEAR_ON_RESET = 1;
    public static final byte CLEAR_ON_DESELECT = 2;

    JCSystem() {
    }

    public static native byte isTransient(Object var0);

    private static void checkTransientArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        if (length < 0) {
            throw new NegativeArraySizeException("Invalid array size: " + length);
        }
        switch (event) {
            case 2: {
                if (!JCSystem.isJCRECurrentContext() && JCSystem.isCallFromWebApp()) {
                    throw new SystemException(3);
                }
                if (JCSystem.isJCRECurrentContext()) break;
                jcAccessor.checkCODArrayCreation(NativeMethods.getCurrentAppId());
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new SystemException(1);
            }
        }
    }

    public static boolean[] makeTransientBooleanArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        JCSystem.checkTransientArray(length, event);
        boolean[] ret = JCSystem.makeTransientBooleanArray0(length, event);
        if (ret == null) {
            throw new SystemException(2);
        }
        return ret;
    }

    public static byte[] makeTransientByteArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        JCSystem.checkTransientArray(length, event);
        byte[] ret = JCSystem.makeTransientByteArray0(length, event);
        if (ret == null) {
            throw new SystemException(2);
        }
        return ret;
    }

    public static short[] makeTransientShortArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        JCSystem.checkTransientArray(length, event);
        short[] ret = JCSystem.makeTransientShortArray0(length, event);
        if (ret == null) {
            throw new SystemException(2);
        }
        return ret;
    }

    public static Object[] makeTransientObjectArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        JCSystem.checkTransientArray(length, event);
        Object[] ret = JCSystem.makeTransientObjectArray0(length, event);
        if (ret == null) {
            throw new SystemException(2);
        }
        return ret;
    }

    public static Object makeGlobalArray(byte type, short length) throws NegativeArraySizeException, SystemException {
        JCSystem.checkTransientArray(length, (byte)1);
        if (type != 1 && type != 2 && type != 3 && type != 4 && type != 5) {
            throw new SystemException(1);
        }
        return JCSystem.createGlobalTransientArray0(type, length);
    }

    public static short getVersion() {
        return 768;
    }

    public static AID getAID() {
        if (JCSystem.isCallFromWebApp()) {
            return null;
        }
        return thePrivAccess.getAID(PrivAccess.getCurrentAppID());
    }

    public static AID lookupAID(byte[] buffer, short offset, byte length) {
        byte test = buffer[0];
        return thePrivAccess.getAID(buffer, offset, length);
    }

    public static void beginTransaction() throws TransactionException {
        if (!JCSystem.isJCRECurrentContext() && !JCSystem.isCallFromClassicApp()) {
            TransactionException.throwIt((short)5);
        }
        if (!AppletMgr.installTransactionFlag) {
            NativeMethods.beginTransactionNative();
        }
    }

    public static void abortTransaction() throws TransactionException {
        if (!JCSystem.isJCRECurrentContext() && !JCSystem.isCallFromClassicApp()) {
            TransactionException.throwIt((short)5);
        }
        if (!AppletMgr.installTransactionFlag) {
            NativeMethods.abortTransactionNative();
        }
    }

    public static void commitTransaction() throws TransactionException {
        if (!JCSystem.isJCRECurrentContext() && !JCSystem.isCallFromClassicApp()) {
            TransactionException.throwIt((short)5);
        }
        if (!AppletMgr.installTransactionFlag) {
            NativeMethods.commitTransactionNative();
        }
    }

    public static byte getTransactionDepth() throws TransactionException {
        if (!JCSystem.isJCRECurrentContext() && !JCSystem.isCallFromClassicApp()) {
            TransactionException.throwIt((short)5);
        }
        return NativeMethods.getTransactionDepthNative();
    }

    public static short getUnusedCommitCapacity() throws TransactionException {
        if (!JCSystem.isJCRECurrentContext() && !JCSystem.isCallFromClassicApp()) {
            TransactionException.throwIt((short)5);
        }
        return JCSystem.getUnusedCommitCapacity0();
    }

    private static native short getUnusedCommitCapacity0();

    public static short getMaxCommitCapacity() throws TransactionException {
        if (!JCSystem.isJCRECurrentContext() && !JCSystem.isCallFromClassicApp()) {
            TransactionException.throwIt((short)5);
        }
        return JCSystem.getMaxCommitCapacity0();
    }

    private static native short getMaxCommitCapacity0();

    public static AID getPreviousContextAID() {
        byte prevCtx = NativeMethods.getPreviousContext();
        if (prevCtx == 0) {
            return null;
        }
        String prevAppURI = javacardx.framework.JCSystem.getPreviousURI();
        if (jcAccessor.isAppWebApp(prevAppURI)) {
            return null;
        }
        return thePrivAccess.getAID(NativeMethods.getPreviousAppId());
    }

    public static short getAvailableMemory(byte memoryType) throws SystemException {
        switch (memoryType) {
            case 0: {
                return NativeMethods.E2P_Available();
            }
            case 1: {
                return NativeMethods.rtr_Available();
            }
            case 2: {
                return NativeMethods.dtr_Available();
            }
        }
        SystemException.throwIt((short)1);
        return 0;
    }

    public static void getAvailableMemory(short[] buffer, short offset, byte memoryType) throws SystemException {
        switch (memoryType) {
            case 0: {
                NativeMethods.availableEEPROM(buffer, offset);
                return;
            }
            case 1: {
                buffer[offset] = 0;
                buffer[(short)(offset + 1)] = NativeMethods.rtr_Available();
                return;
            }
            case 2: {
                buffer[offset] = 0;
                buffer[(short)(offset + 1)] = NativeMethods.dtr_Available();
                return;
            }
        }
        SystemException.throwIt((short)1);
    }

    public static Shareable getAppletShareableInterfaceObject(AID serverAID, byte parameter) {
        if (serverAID == null) {
            return null;
        }
        Shareable sio = null;
        boolean serverIsClassicApp = jcAccessor.isAppClassic(serverAID);
        boolean jcreCurrentContext = JCSystem.isJCRECurrentContext();
        boolean clientIsClassicApp = JCSystem.isCallFromClassicApp();
        if (!jcreCurrentContext && JCSystem.isCallFromWebApp()) {
            return null;
        }
        sio = thePrivAccess.getSharedObject(serverAID, parameter, serverIsClassicApp);
        if (sio == null) {
            return null;
        }
        Shareable mayBeClassicProxy = jcAccessor.processShareable(sio, clientIsClassicApp);
        if (mayBeClassicProxy != null) {
            return mayBeClassicProxy;
        }
        if (jcreCurrentContext || !clientIsClassicApp && serverIsClassicApp) {
            try {
                sio = (Shareable)((Object)jcAccessor.proxyLookup(sio, true, serverAID));
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if (clientIsClassicApp && !serverIsClassicApp) {
            try {
                AID clientAID = JCSystem.getAID();
                sio = (Shareable)((Object)jcAccessor.proxyLookup(sio, true, clientAID));
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return sio;
    }

    public static boolean isObjectDeletionSupported() {
        return true;
    }

    public static void requestObjectDeletion() throws SystemException {
        if (!JCSystem.isCallFromClassicApp()) {
            SystemException.throwIt((short)6);
        }
        System.gc();
    }

    public static byte getAssignedChannel() {
        if (JCSystem.isCallFromWebApp()) {
            return 0;
        }
        return jcAccessor.getAssignedChannelImpl();
    }

    public static boolean isAppletActive(AID theApplet) {
        theApplet.equals(null);
        return AppletServer.getAppletServer().isAppletActive(theApplet);
    }

    private static boolean isJCRECurrentContext() {
        return NativeMethods.getCurrentContext() == 0;
    }

    private static boolean isCallFromClassicApp() {
        String appURI = javacardx.framework.JCSystem.getURI();
        if (appURI == null) {
            return false;
        }
        return jcAccessor.isAppClassic(appURI);
    }

    private static boolean isCallFromWebApp() {
        String appURI = javacardx.framework.JCSystem.getURI();
        if (appURI == null) {
            return false;
        }
        return jcAccessor.isAppWebApp(appURI);
    }

    private static native byte[] makeTransientByteArray0(short var0, byte var1);

    private static native short[] makeTransientShortArray0(short var0, byte var1);

    private static native boolean[] makeTransientBooleanArray0(short var0, byte var1);

    private static native Object[] makeTransientObjectArray0(short var0, byte var1);

    private static native Object createGlobalTransientArray0(byte var0, short var1);
}

