/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.sun.javacard.crypto.ECKeyPair;
import com.sun.javacard.crypto.KeyPairInterfaceInternal;
import com.sun.javacard.crypto.RSAKeyPair;
import com.sun.javacard.impl.JCCryptoAccessor;
import javacard.security.CryptoException;
import javacard.security.PrivateKey;
import javacard.security.PublicKey;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public final class KeyPair {
    public static final String SERVICE_NAME = "keyPair";
    public static final byte ALG_RSA = 1;
    public static final byte ALG_RSA_CRT = 2;
    public static final byte ALG_DSA = 3;
    public static final byte ALG_EC_F2M = 4;
    public static final byte ALG_EC_FP = 5;
    private static String[] map = new String[]{"", "RSA", "RSA_CRT", "DSA", "EC_F2M", "EC_FP"};
    private KeyPairInterfaceInternal kp;
    private static JCCryptoAccessor cryptoAccessorInstance = JCCryptoAccessor.getInstance();

    public final void genKeyPair() throws CryptoException {
        this.kp.genKeyPair();
    }

    public KeyPair(byte algorithm, short keyLength) throws CryptoException {
        if (algorithm <= 0 || algorithm >= map.length) {
            CryptoException.throwIt((short)3);
        }
        this.initKeyPair(map[algorithm], keyLength);
    }

    public KeyPair(String algorithm, short keyLength) throws CryptoException {
        this.initKeyPair(algorithm, keyLength);
    }

    private void initKeyPair(String algorithm, short keyLength) {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        sb.append(".");
        sb.append(keyLength);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString());
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        this.kp = (KeyPairInterfaceInternal)o;
    }

    public KeyPair(String algorithm, String provider, short keyLength) throws CryptoException {
        if (algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        sb.append(".");
        sb.append(keyLength);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), provider);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        this.kp = (KeyPairInterfaceInternal)o;
    }

    public KeyPair(PublicKey publicKey, PrivateKey privateKey) throws CryptoException {
        if (publicKey == null || privateKey == null) {
            CryptoException.throwIt((short)1);
        }
        switch (publicKey.getType()) {
            case 4: {
                this.kp = new RSAKeyPair(publicKey, privateKey);
                break;
            }
            case 11: {
                this.kp = new ECKeyPair(publicKey, privateKey);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
    }

    public PublicKey getPublic() {
        return this.kp.getPublic();
    }

    public PrivateKey getPrivate() {
        return this.kp.getPrivate();
    }
}

