/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.sun.javacard.impl.JCCryptoAccessor;
import javacard.security.CryptoException;
import javacard.security.InitializedMessageDigest;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class MessageDigest {
    public static final String SERVICE_NAME = "messageDigest";
    public static final byte ALG_NULL = 0;
    public static final byte ALG_SHA = 1;
    public static final byte ALG_MD5 = 2;
    public static final byte ALG_RIPEMD160 = 3;
    public static final byte ALG_SHA_256 = 4;
    public static final byte ALG_SHA_384 = 5;
    public static final byte ALG_SHA_512 = 6;
    public static final byte ALG_SHA_224 = 7;
    public static final byte LENGTH_MD5 = 16;
    public static final byte LENGTH_RIPEMD160 = 20;
    public static final byte LENGTH_SHA = 20;
    public static final byte LENGTH_SHA_224 = 28;
    public static final byte LENGTH_SHA_256 = 32;
    public static final byte LENGTH_SHA_384 = 48;
    public static final byte LENGTH_SHA_512 = 64;
    private static JCCryptoAccessor cryptoAccessorInstance = JCCryptoAccessor.getInstance();

    protected MessageDigest() {
    }

    public static final MessageDigest getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        if (externalAccess) {
            CryptoException.throwIt((short)3);
        }
        MessageDigest instance = null;
        switch (algorithm) {
            case 1: {
                instance = MessageDigest.getInstance("SHA", externalAccess);
                break;
            }
            case 2: {
                instance = MessageDigest.getInstance("MD5", externalAccess);
                break;
            }
            case 3: {
                instance = MessageDigest.getInstance("RIPEMD160", externalAccess);
                break;
            }
            case 4: {
                instance = MessageDigest.getInstance("SHA_256", externalAccess);
                break;
            }
            case 5: {
                instance = MessageDigest.getInstance("SHA_384", externalAccess);
                break;
            }
            case 6: {
                instance = MessageDigest.getInstance("SHA_512", externalAccess);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public static final MessageDigest getInstance(String algorithm, boolean externalAccess) throws CryptoException {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (MessageDigest)o;
    }

    public static final MessageDigest getInstance(String algorithm, String provider, boolean externalAccess) throws CryptoException {
        if (algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), provider, externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (MessageDigest)o;
    }

    public static final InitializedMessageDigest getInitializedMessageDigestInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        if (externalAccess) {
            CryptoException.throwIt((short)3);
        }
        MessageDigest instance = null;
        switch (algorithm) {
            case 1: {
                instance = MessageDigest.getInstance("SHA", externalAccess);
                break;
            }
            case 2: {
                instance = MessageDigest.getInstance("MD5", externalAccess);
                break;
            }
            case 3: {
                instance = MessageDigest.getInstance("RIPEMD160", externalAccess);
                break;
            }
            case 4: {
                instance = MessageDigest.getInstance("SHA_256", externalAccess);
                break;
            }
            case 5: {
                instance = MessageDigest.getInstance("SHA_384", externalAccess);
                break;
            }
            case 6: {
                instance = MessageDigest.getInstance("SHA_512", externalAccess);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return (InitializedMessageDigest)instance;
    }

    public static final InitializedMessageDigest getInitializedMessageDigestInstance(String algorithm, boolean externalAccess) throws CryptoException {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (InitializedMessageDigest)o;
    }

    public static final InitializedMessageDigest getInitializedMessageDigestInstance(String algorithm, String provider, boolean externalAccess) throws CryptoException {
        if (algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), provider, externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (InitializedMessageDigest)o;
    }

    public abstract byte getAlgorithm();

    public abstract String getAlgorithmName();

    public abstract byte getLength();

    public abstract short doFinal(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;

    public abstract void update(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract void reset();

    static String convertAlgorithmByteToString(byte messageDigestAlgorithm, boolean withPrefix) {
        StringBuffer alg = new StringBuffer("");
        if (withPrefix) {
            alg.insert(0, "_");
        }
        switch (messageDigestAlgorithm) {
            case 0: {
                return "";
            }
            case 1: {
                alg.append("SHA");
                break;
            }
            case 2: {
                alg.append("MD5");
                break;
            }
            case 3: {
                alg.append("RIPEMD160");
                break;
            }
            case 4: {
                alg.append("SHA_256");
                break;
            }
            case 5: {
                alg.append("SHA_384");
                break;
            }
            case 6: {
                alg.append("SHA_512");
                break;
            }
            case 7: {
                alg.append("SHA_224");
                break;
            }
            default: {
                return null;
            }
        }
        return alg.toString();
    }
}

