/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.sun.javacard.impl.JCCryptoAccessor;
import javacard.security.CryptoException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class RandomData {
    public static final String SERVICE_NAME = "randomData";
    public static final byte ALG_PSEUDO_RANDOM = 1;
    public static final byte ALG_SECURE_RANDOM = 2;
    private static JCCryptoAccessor cryptoAccessorInstance = JCCryptoAccessor.getInstance();

    protected RandomData() {
    }

    public static final RandomData getInstance(byte algorithm) throws CryptoException {
        RandomData instance = null;
        switch (algorithm) {
            case 1: {
                instance = RandomData.getInstance("PSEUDO_RANDOM");
                break;
            }
            case 2: {
                instance = RandomData.getInstance("SECURE_RANDOM");
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public static final RandomData getInstance(String algorithm) throws CryptoException {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString());
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (RandomData)o;
    }

    public static final RandomData getInstance(String algorithm, String provider) throws CryptoException {
        if (algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), provider);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (RandomData)o;
    }

    public abstract void generateData(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract void setSeed(byte[] var1, short var2, short var3);
}

