/*
 * Decompiled with CFR 0.152.
 */
package javacardx.crypto;

import com.sun.javacard.impl.JCCryptoAccessor;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class Cipher {
    public static final String SERVICE_NAME = "cipher";
    public static final byte ALG_DES_CBC_NOPAD = 1;
    public static final byte ALG_DES_CBC_ISO9797_M1 = 2;
    public static final byte ALG_DES_CBC_ISO9797_M2 = 3;
    public static final byte ALG_DES_CBC_PKCS5 = 4;
    public static final byte ALG_DES_ECB_NOPAD = 5;
    public static final byte ALG_DES_ECB_ISO9797_M1 = 6;
    public static final byte ALG_DES_ECB_ISO9797_M2 = 7;
    public static final byte ALG_DES_ECB_PKCS5 = 8;
    public static final byte ALG_RSA_ISO14888 = 9;
    public static final byte ALG_RSA_PKCS1 = 10;
    public static final byte ALG_RSA_ISO9796 = 11;
    public static final byte ALG_RSA_NOPAD = 12;
    public static final byte ALG_AES_BLOCK_128_CBC_NOPAD = 13;
    public static final byte ALG_AES_BLOCK_128_ECB_NOPAD = 14;
    public static final byte ALG_RSA_PKCS1_OAEP = 15;
    public static final byte ALG_KOREAN_SEED_ECB_NOPAD = 16;
    public static final byte ALG_KOREAN_SEED_CBC_NOPAD = 17;
    public static final byte ALG_AES_BLOCK_192_CBC_NOPAD = 18;
    public static final byte ALG_AES_BLOCK_192_ECB_NOPAD = 19;
    public static final byte ALG_AES_BLOCK_256_CBC_NOPAD = 20;
    public static final byte ALG_AES_BLOCK_256_ECB_NOPAD = 21;
    public static final byte ALG_AES_CBC_ISO9797_M1 = 22;
    public static final byte ALG_AES_CBC_ISO9797_M2 = 23;
    public static final byte ALG_AES_CBC_PKCS5 = 24;
    public static final byte ALG_AES_ECB_ISO9797_M1 = 25;
    public static final byte ALG_AES_ECB_ISO9797_M2 = 26;
    public static final byte ALG_AES_ECB_PKCS5 = 27;
    public static final byte CIPHER_AES_CBC = 1;
    public static final byte CIPHER_AES_ECB = 2;
    public static final byte CIPHER_DES_CBC = 3;
    public static final byte CIPHER_DES_ECB = 4;
    public static final byte CIPHER_KOREAN_SEED_CBC = 5;
    public static final byte CIPHER_KOREAN_SEED_ECB = 6;
    public static final byte CIPHER_RSA = 7;
    public static final byte PAD_NULL = 0;
    public static final byte PAD_NOPAD = 1;
    public static final byte PAD_ISO9797_M1 = 2;
    public static final byte PAD_ISO9797_M2 = 3;
    public static final byte PAD_ISO9797_1_M1_ALG3 = 4;
    public static final byte PAD_ISO9797_1_M2_ALG3 = 5;
    public static final byte PAD_PKCS5 = 6;
    public static final byte PAD_PKCS1 = 7;
    public static final byte PAD_PKCS1_PSS = 8;
    public static final byte PAD_PKCS1_OAEP = 9;
    public static final byte PAD_ISO9796 = 10;
    public static final byte PAD_ISO9796_MR = 11;
    public static final byte PAD_RFC2409 = 12;
    public static final byte MODE_DECRYPT = 1;
    public static final byte MODE_ENCRYPT = 2;
    private static JCCryptoAccessor cryptoAccessorInstance = JCCryptoAccessor.getInstance();

    protected Cipher() {
    }

    public static final Cipher getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        Cipher instance = null;
        switch (algorithm) {
            case 1: {
                instance = Cipher.getInstance("DES_CBC_NOPAD", externalAccess);
                break;
            }
            case 2: {
                instance = Cipher.getInstance("DES_CBC_ISO9797_M1", externalAccess);
                break;
            }
            case 3: {
                instance = Cipher.getInstance("DES_CBC_ISO9797_M2", externalAccess);
                break;
            }
            case 4: {
                instance = Cipher.getInstance("DES_CBC_PKCS5", externalAccess);
                break;
            }
            case 5: {
                instance = Cipher.getInstance("DES_ECB_NOPAD", externalAccess);
                break;
            }
            case 6: {
                instance = Cipher.getInstance("DES_ECB_ISO9797_M1", externalAccess);
                break;
            }
            case 7: {
                instance = Cipher.getInstance("DES_ECB_ISO9797_M2", externalAccess);
                break;
            }
            case 8: {
                instance = Cipher.getInstance("DES_ECB_PKCS5", externalAccess);
                break;
            }
            case 9: {
                instance = Cipher.getInstance("RSA_ISO14888", externalAccess);
                break;
            }
            case 10: {
                instance = Cipher.getInstance("RSA_PKCS1", externalAccess);
                break;
            }
            case 12: {
                instance = Cipher.getInstance("RSA_NOPAD", externalAccess);
                break;
            }
            case 13: {
                instance = Cipher.getInstance("AES_BLOCK_128_CBC_NOPAD", externalAccess);
                break;
            }
            case 14: {
                instance = Cipher.getInstance("AES_BLOCK_128_ECB_NOPAD", externalAccess);
                break;
            }
            case 15: {
                instance = Cipher.getInstance("RSA_PKCS1_OAEP", externalAccess);
                break;
            }
            case 16: {
                instance = Cipher.getInstance("KOREAN_SEED_ECB_NOPAD", externalAccess);
                break;
            }
            case 17: {
                instance = Cipher.getInstance("KOREAN_SEED_CBC_NOPAD", externalAccess);
                break;
            }
            case 18: {
                instance = Cipher.getInstance("AES_BLOCK_192_CBC_NOPAD", externalAccess);
                break;
            }
            case 19: {
                instance = Cipher.getInstance("AES_BLOCK_192_ECB_NOPAD", externalAccess);
                break;
            }
            case 20: {
                instance = Cipher.getInstance("AES_BLOCK_256_CBC_NOPAD", externalAccess);
                break;
            }
            case 21: {
                instance = Cipher.getInstance("AES_BLOCK_256_ECB_NOPAD", externalAccess);
                break;
            }
            case 22: {
                instance = Cipher.getInstance("AES_CBC_ISO9797_M1", externalAccess);
                break;
            }
            case 23: {
                instance = Cipher.getInstance("AES_CBC_ISO9797_M2", externalAccess);
                break;
            }
            case 24: {
                instance = Cipher.getInstance("AES_CBC_PKCS5", externalAccess);
                break;
            }
            case 25: {
                instance = Cipher.getInstance("AES_ECB_ISO9797_M1", externalAccess);
                break;
            }
            case 26: {
                instance = Cipher.getInstance("AES_ECB_ISO9797_M2", externalAccess);
                break;
            }
            case 27: {
                instance = Cipher.getInstance("AES_ECB_PKCS5", externalAccess);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public static final Cipher getInstance(byte cipherAlgorithm, byte paddingAlgorithm, boolean externalAccess) throws CryptoException {
        String algName = null;
        String cipherName = Cipher.convertCipherByteToString(cipherAlgorithm);
        if (paddingAlgorithm == 1) {
            if (cipherName.equals("AES_CBC")) {
                algName = "AES_BLOCK_128_CBC_NOPAD";
            } else if (cipherName.equals("AES_ECB")) {
                algName = "AES_BLOCK_128_ECB_NOPAD";
            }
        }
        if (algName == null) {
            algName = cipherName + com.sun.javacard.crypto.Cipher.convertPaddingByteToStringSuffix((byte)paddingAlgorithm);
        }
        return Cipher.getInstance(algName, externalAccess);
    }

    public static final Cipher getInstance(String algorithm, boolean externalAccess) throws CryptoException {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (Cipher)o;
    }

    public static final Cipher getInstance(String algorithm, String provider, boolean externalAccess) throws CryptoException {
        if (algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), provider, externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (Cipher)o;
    }

    public abstract void init(Key var1, byte var2) throws CryptoException;

    public abstract void init(Key var1, byte var2, byte[] var3, short var4, short var5) throws CryptoException;

    public abstract byte getAlgorithm();

    public abstract String getAlgorithmName();

    public abstract short doFinal(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;

    public abstract short update(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;

    static String convertCipherByteToString(byte cipherAlgorithm) {
        switch (cipherAlgorithm) {
            case 1: {
                return "AES_CBC";
            }
            case 2: {
                return "AES_ECB";
            }
            case 3: {
                return "DES_CBC";
            }
            case 4: {
                return "DES_ECB";
            }
            case 5: {
                return "KOREAN_SEED_CBC";
            }
            case 6: {
                return "KOREAN_SEED_ECB";
            }
            case 7: {
                return "RSA";
            }
        }
        return null;
    }
}

