/*
 * Decompiled with CFR 0.152.
 */
package javacardx.framework.string;

import javacard.framework.Util;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.string.StringException;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public final class StringUtil {
    public static final byte UTF_8 = 1;
    public static final byte UTF_16 = 2;
    public static final byte UTF_16_LE = 3;
    public static final byte UTF_16_BE = 4;
    public static final byte UCS_2 = 5;
    public static final byte GSM_7 = 6;
    public static final byte ISO_8859_1 = 7;
    public static final byte PROP_ENCODING_EXT = 64;

    public static short codePointCount(byte[] aString, short offset, short length) {
        short count = 0;
        for (short i = offset; i < (short)(offset + length); i = (short)(i + 1)) {
            int j;
            if ((aString[i] & 0xE0) == 192) {
                count = (short)(count + 1);
                if ((short)(i + 1) >= (short)(offset + length) || (aString[(short)(i + 1)] & 0xC0) != 128) continue;
                i = (short)(i + 1);
                continue;
            }
            if ((aString[i] & 0xF0) == 224) {
                count = (short)(count + 1);
                for (j = 0; j < 2 && (short)(i + 1) < (short)(offset + length) && (aString[(short)(i + 1)] & 0xC0) == 128; j = (int)((short)(j + 1))) {
                    i = (short)(i + 1);
                }
                continue;
            }
            if ((aString[i] & 0xF8) == 240) {
                count = (short)(count + 1);
                for (j = 0; j < 3 && (short)(i + 1) < (short)(offset + length) && (aString[(short)(i + 1)] & 0xC0) == 128; j = (int)((short)(j + 1))) {
                    i = (short)(i + 1);
                }
                continue;
            }
            count = (short)(count + 1);
        }
        return count;
    }

    public static short codePointAt(byte[] aString, short offset, short length, short index, byte[] dstBuffer, short dstOffset) {
        short count = 1;
        short totOff = (short)(offset + index);
        if (index < 0 || index >= length) {
            aString[-1] = 1;
        }
        if ((aString[totOff] & 0xE0) == 192) {
            if ((short)(totOff + 1) < (short)(offset + length) && (aString[(short)(totOff + 1)] & 0xC0) == 128) {
                count = (short)(count + 1);
            }
            Util.arrayCopy(aString, totOff, dstBuffer, dstOffset, count);
        } else if ((aString[totOff] & 0xF0) == 224) {
            for (int j = 0; j < 2 && (short)(totOff + j + 1) < (short)(offset + length) && (aString[(short)(totOff + j + 1)] & 0xC0) == 128; j = (int)((short)(j + 1))) {
                count = (short)(count + 1);
            }
            Util.arrayCopy(aString, totOff, dstBuffer, dstOffset, count);
        } else if ((aString[totOff] & 0xF8) == 240) {
            for (int j = 0; j < 3 && (short)(totOff + j + 1) < (short)(offset + length) && (aString[(short)(totOff + j + 1)] & 0xC0) == 128; j = (int)((short)(j + 1))) {
                count = (short)(count + 1);
            }
            Util.arrayCopy(aString, totOff, dstBuffer, dstOffset, count);
        } else {
            dstBuffer[dstOffset] = aString[totOff];
        }
        return count;
    }

    public static short codePointBefore(byte[] aString, short offset, short length, short index, byte[] dstBuffer, short dstOffset) {
        short count = 0;
        int i = 1;
        short totOff = (short)(offset + index);
        if (index < 1 || index > length) {
            aString[-1] = 1;
        }
        while (i < 5 && (short)(totOff - i - 1) >= offset && (aString[(short)(totOff - i)] & 0xC0) == 128) {
            i = (short)(i + 1);
        }
        if ((aString[(short)(totOff - i)] & 0xF8) == 240 && i < 5) {
            count = (short)(count + i);
            Util.arrayCopy(aString, (short)(totOff - i), dstBuffer, dstOffset, count);
        } else if ((aString[(short)(totOff - i)] & 0xF0) == 224 && i < 4) {
            count = (short)(count + i);
            Util.arrayCopy(aString, (short)(totOff - i), dstBuffer, dstOffset, count);
        } else if ((aString[(short)(totOff - i)] & 0xE0) == 192 && i < 3) {
            count = (short)(count + i);
            Util.arrayCopy(aString, (short)(totOff - i), dstBuffer, dstOffset, count);
        } else {
            count = (short)(count + 1);
            dstBuffer[dstOffset] = aString[(short)(totOff - 1)];
        }
        return count;
    }

    public static short offsetByCodePoints(byte[] aString, short offset, short length, short index, short codePointOffset) {
        short i = 0;
        if (index < 0 || index > length) {
            aString[-1] = 1;
        }
        if (codePointOffset >= 0) {
            while (codePointOffset > 0) {
                int j;
                if ((aString[(short)(i + index + offset)] & 0xE0) == 192) {
                    if ((short)(i + index + 1) < length && (short)(i + index + 1) >= 0 && (aString[(short)(i + index + offset + 1)] & 0xC0) == 128) {
                        i = (short)(i + 1);
                    }
                } else if ((aString[(short)(i + index + offset)] & 0xF0) == 224) {
                    for (j = 1; j < 3 && (short)(i + index + 1) < length && (short)(i + index + 1) >= 0 && (aString[(short)(i + index + offset + 1)] & 0xC0) == 128; j = (int)((short)(j + 1))) {
                        i = (short)(i + 1);
                    }
                } else if ((aString[(short)(i + index + offset)] & 0xF8) == 240) {
                    for (j = 1; j < 4 && (short)(i + index + 1) < length && (short)(i + index + 1) >= 0 && (aString[(short)(i + index + offset + 1)] & 0xC0) == 128; j = (int)((short)(j + 1))) {
                        i = (short)(i + 1);
                    }
                }
                codePointOffset = (short)(codePointOffset - 1);
                if ((short)((i = (short)(i + 1)) + index) <= length) continue;
                aString[-1] = 1;
            }
        } else {
            while (codePointOffset < 0) {
                int count;
                for (count = 0; count < 4 && (short)(index - count - 2 + i) >= 0 && (aString[(short)(index - count - 1 + i + offset)] & 0xC0) == 128; count = (int)((short)(count + 1))) {
                }
                if ((aString[(short)(index - count - 1 + i + offset)] & 0xF8) == 240 && count < 4) {
                    i = (short)(i - count);
                } else if ((aString[(short)(index - count - 1 + i + offset)] & 0xF0) == 224 && count < 3) {
                    i = (short)(i - count);
                } else if ((aString[(short)(index - count - 1 + i + offset)] & 0xE0) == 192 && count < 2) {
                    i = (short)(i - count);
                }
                i = (short)(i - 1);
                codePointOffset = (short)(codePointOffset + 1);
                if ((short)(i + index) >= 0) continue;
                aString[-1] = 1;
            }
        }
        return (short)(i + index);
    }

    public static short compare(boolean ignoreCase, byte[] aString, short offset, short length, byte[] anotherString, short ooffset, short olength) {
        short min = length <= olength ? length : olength;
        for (short i = 0; i < min; i = (short)(i + 1)) {
            byte b1 = aString[(short)(offset + i)];
            byte b2 = anotherString[(short)(ooffset + i)];
            if (b1 != b2 && ignoreCase) {
                if ((b1 & 0x80) == 0 && (b1 >= 65 && b1 <= 90 || b1 >= 192 && b1 <= 214 || b1 >= 216 && b1 <= 222)) {
                    b1 = (byte)(b1 + 32);
                }
                if ((b2 & 0x80) == 0 && (b2 >= 65 && b2 <= 90 || b2 >= 192 && b2 <= 214 || b2 >= 216 && b2 <= 222)) {
                    b2 = (byte)(b2 + 32);
                }
            }
            if (b1 == b2) continue;
            return (short)(b1 - b2);
        }
        return (short)(length - olength);
    }

    public static short indexOf(byte[] aString, short offset, short length, byte[] subString, short soffset, short slength) {
        if (slength == 0) {
            return 0;
        }
        short max = (short)(offset + length - slength);
        for (short i = offset; i <= max; i = (short)(i + 1)) {
            if (Util.arrayCompare(aString, i, subString, soffset, slength) != 0) continue;
            return (short)(i - offset);
        }
        return -1;
    }

    public static short replace(byte[] srcString, short srcOffset, short srcLength, byte[] oldSubstring, short oOffset, short oLength, byte[] newSubstring, short nOffset, short nLength, byte[] dstString, short dstOffset) {
        if (oLength == nLength && Util.arrayCompare(oldSubstring, oOffset, newSubstring, nOffset, oLength) == 0) {
            Util.arrayCopy(srcString, srcOffset, dstString, dstOffset, srcLength);
            return srcLength;
        }
        short i = -1;
        while ((i = (short)((short)(i + 1))) <= (short)(srcLength - oLength) && Util.arrayCompare(srcString, (short)(i + srcOffset), oldSubstring, oOffset, oLength) != 0) {
        }
        if (i <= (short)(srcLength - oLength)) {
            Util.arrayCopy(srcString, srcOffset, dstString, dstOffset, i);
            short count = i;
            while (i <= (short)(srcLength - oLength)) {
                if (Util.arrayCompare(srcString, (short)(i + srcOffset), oldSubstring, oOffset, oLength) == 0) {
                    Util.arrayCopy(newSubstring, nOffset, dstString, (short)(dstOffset + count), nLength);
                    i = (short)(i + oLength);
                    count = (short)(count + nLength);
                    continue;
                }
                dstString[(short)(dstOffset + count)] = srcString[(short)(i + srcOffset)];
                i = (short)(i + 1);
                count = (short)(count + 1);
            }
            Util.arrayCopy(srcString, i, dstString, (short)(dstOffset + count), (short)(srcLength - i));
            count = (short)(count + (srcLength - i));
            return count;
        }
        Util.arrayCopy(srcString, srcOffset, dstString, dstOffset, srcLength);
        return srcLength;
    }

    public static short toLowerCase(byte[] srcString, short srcOffset, short srcLength, byte[] dstString, short dstOffset) {
        for (short i = 0; i < srcLength; i = (short)(i + 1)) {
            byte c = srcString[(short)(i + srcOffset)];
            if ((c & 0x80) == 0 && (c >= 65 && c <= 90 || c >= 192 && c <= 214 || c >= 216 && c <= 222)) {
                c = (byte)(c + 32);
            }
            dstString[(short)(dstOffset + i)] = c;
        }
        return srcLength;
    }

    public static short toUpperCase(byte[] srcString, short srcOffset, short srcLength, byte[] dstString, short dstOffset) {
        for (short i = 0; i < srcLength; i = (short)(i + 1)) {
            byte c = srcString[(short)(i + srcOffset)];
            if ((c & 0x80) == 0 && (c >= 97 && c <= 122 || c >= 223 && c <= 246 || c >= 248 && c <= 255)) {
                c = (byte)(c - 32);
            }
            dstString[(short)(dstOffset + i)] = c;
        }
        return srcLength;
    }

    public static short trim(byte[] srcString, short srcOffset, short srcLength, byte[] dstString, short dstOffset) {
        short st;
        short en = srcLength;
        for (st = 0; st < en && srcString[(short)(srcOffset + st)] <= 32 && srcString[(short)(srcOffset + st)] >= 0; st = (short)(st + 1)) {
        }
        while (st < en && srcString[(short)(en + srcOffset - 1)] <= 32 && srcString[(short)(srcOffset + st)] >= 0) {
            en = (short)(en - 1);
        }
        Util.arrayCopy(srcString, (short)(st + srcOffset), dstString, dstOffset, (short)(en - st));
        return (short)(en - st);
    }

    public static short valueOf(boolean b, byte[] dstString, short dstOffset) {
        if (b) {
            dstString[dstOffset] = 116;
            dstString[(short)(dstOffset + 1)] = 114;
            dstString[(short)(dstOffset + 2)] = 117;
            dstString[(short)(dstOffset + 3)] = 101;
            return 4;
        }
        dstString[dstOffset] = 102;
        dstString[(short)(dstOffset + 1)] = 97;
        dstString[(short)(dstOffset + 2)] = 108;
        dstString[(short)(dstOffset + 3)] = 115;
        dstString[(short)(dstOffset + 4)] = 101;
        return 5;
    }

    public static boolean parseBoolean(byte[] aString, short offset, short length) {
        return !(aString[offset] != 116 && aString[offset] != 84 || length != 4 || aString[(short)(offset + 1)] != 114 && aString[(short)(offset + 1)] != 82 || aString[(short)(offset + 2)] != 117 && aString[(short)(offset + 2)] != 85 || aString[(short)(offset + 3)] != 101 && aString[(short)(offset + 3)] != 69);
    }

    public static short valueOf(short i, byte[] dstString, short dstOffset) {
        short k;
        int radix = 10;
        int charPos = 5;
        boolean negative = i < 0;
        byte[] buf = new byte[6];
        int neg = 45;
        byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        if (!negative) {
            i = -i;
        }
        while (i <= (short)(-radix)) {
            int n = charPos;
            charPos = (short)(charPos - 1);
            buf[n] = digits[(short)(-(i % radix))];
            i = (short)(i / radix);
        }
        buf[charPos] = digits[(short)(-i)];
        if (negative) {
            charPos = (short)(charPos - 1);
            buf[charPos] = neg;
        }
        for (k = 0; k < 6 && buf[k] == 0; k = (short)((short)(k + 1))) {
        }
        Util.arrayCopy(buf, k, dstString, dstOffset, (short)(6 - k));
        return (short)(6 - k);
    }

    public static short parseShortInteger(byte[] aString, short offset, short length) {
        byte b;
        int limit;
        short s = 0;
        short radix = 0;
        boolean negative = false;
        short digit = 0;
        if (aString[offset] == 45) {
            negative = true;
            limit = Short.MIN_VALUE;
            offset = (short)(offset + 1);
            length = (short)(length - 1);
        } else {
            limit = -32767;
        }
        if (aString[offset] == 48 && length > 1) {
            if (aString[(short)(offset + 1)] == 120 || aString[(short)(offset + 1)] == 88) {
                offset = (short)(offset + 2);
                length = (short)(length - 2);
                radix = 16;
            } else {
                StringException.throwIt((short)2);
            }
        } else if (aString[offset] == 35) {
            offset = (short)(offset + 1);
            length = (short)(length - 1);
            radix = 16;
        } else {
            radix = 10;
        }
        short multmin = (short)(limit / radix);
        if (length > 0) {
            b = aString[offset];
            if (b >= 48 && b <= 57) {
                digit = (short)(b - 48);
            } else if (b >= 65 && b <= 70 || b >= 97 && b <= 102) {
                digit = (short)((b & 0x1F) + 9);
            } else {
                StringException.throwIt((short)2);
            }
            if (digit >= radix) {
                StringException.throwIt((short)2);
            }
            s = -digit;
            length = (short)(length - 1);
            offset = (short)(offset + 1);
        } else {
            StringException.throwIt((short)2);
        }
        while (length > 0) {
            b = aString[offset];
            if (b >= 48 && b <= 57) {
                digit = (short)(b - 48);
            } else if (b >= 65 && b <= 70 || b >= 97 && b <= 102) {
                digit = (short)((b & 0x1F) + 9);
            } else {
                StringException.throwIt((short)2);
            }
            if (digit >= radix || s < multmin) {
                StringException.throwIt((short)2);
            }
            if ((s = (short)(s * radix)) < (short)(limit + digit)) {
                StringException.throwIt((short)2);
            }
            s = (short)(s - digit);
            length = (short)(length - 1);
            offset = (short)(offset + 1);
        }
        if (negative) {
            return s;
        }
        return -s;
    }

    public static short valueOf(short[] l, byte[] dstString, short dstOffset) {
        short k;
        short i;
        boolean negative = l[0] < 0;
        short radix = 10;
        short len = (short)l.length;
        short[] lCopy = new short[(short)l.length];
        for (i = 0; i < len; i = (short)(i + 1)) {
            lCopy[(short)(len - 1 - i)] = negative ? (short)(~l[i]) : l[i];
        }
        if (negative) {
            boolean carry = false;
            if (lCopy[0] == -1) {
                carry = true;
                i = 1;
            }
            lCopy[0] = (short)(lCopy[0] + 1);
            while (carry) {
                carry = lCopy[i] == -1;
                short s = i;
                lCopy[s] = (short)(lCopy[s] + 1);
                i = (short)(i + 1);
            }
        }
        if (len > 1 && lCopy[(short)(len - 1)] == 0) {
            while (len > 1 && lCopy[(short)(len - 1)] == 0) {
                len = (short)(len - 1);
            }
        }
        short rlen = (short)(2 * len);
        short[] remainder = new short[rlen];
        short[] divisor = new short[rlen];
        short[] quotient = new short[len];
        int charPos = 20;
        byte[] buf = new byte[21];
        int neg = 45;
        byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        boolean gt = true;
        for (i = 0; i < len; i = (short)(i + 1)) {
            remainder[i] = lCopy[i];
        }
        divisor[len] = radix;
        if (len == 1 && remainder[0] < radix && remainder[0] >= 0) {
            gt = false;
        }
        while (gt) {
            for (i = 0; i < (short)(len * 16 + 1); i = (short)(i + 1)) {
                short templen;
                short j;
                int borrow = 0;
                short[] temp = new short[rlen];
                for (j = 0; j < rlen; j = (short)(j + 1)) {
                    temp[j] = (short)(remainder[j] - divisor[j] - borrow);
                    borrow = remainder[j] >= 0 && temp[j] < 0 || remainder[j] >= 0 && temp[j] > remainder[j] ? 1 : 0;
                }
                for (j = (short)(rlen - 1); temp[j] == 0 && j > 0; j = (short)(j - 1)) {
                }
                for (templen = (short)(rlen - 1); remainder[templen] == 0 && templen > 0; templen = (short)(templen - 1)) {
                }
                if (temp[j] >= 0 || temp[j] < 0 && remainder[j] < 0 && temp[j] <= remainder[j] || temp[j] < 0 && templen > j && remainder[templen] > 0) {
                    for (j = 0; j < rlen; j = (short)(j + 1)) {
                        remainder[j] = temp[j];
                    }
                    for (j = (short)(len - 1); j > 0; j = (short)(j - 1)) {
                        quotient[j] = (short)(quotient[j] << 1 | quotient[(short)(j - 1)] >> 15 & 1);
                    }
                    quotient[0] = (short)(quotient[0] << 1 | 1);
                } else {
                    for (j = (short)(len - 1); j > 0; j = (short)(j - 1)) {
                        quotient[j] = (short)(quotient[j] << 1 | quotient[(short)(j - 1)] >> 15 & 1);
                    }
                    quotient[0] = (short)(quotient[0] << 1 & 0xFFFFFFFE);
                }
                for (j = 0; j < (short)(rlen - 1); j = (short)(j + 1)) {
                    divisor[j] = (short)(divisor[j] >> 1 & Short.MAX_VALUE | divisor[(short)(j + 1)] << 15 & Short.MIN_VALUE);
                }
                divisor[(short)(rlen - 1)] = (short)(divisor[(short)(rlen - 1)] >> 1);
            }
            int n = charPos;
            charPos = (short)(charPos - 1);
            buf[n] = digits[remainder[0]];
            if (len > 1 && quotient[(short)(len - 1)] == 0) {
                while (len > 1 && quotient[(short)(len - 1)] == 0) {
                    len = (short)(len - 1);
                }
            }
            if (len == 1 && quotient[0] < radix && quotient[0] >= 0) {
                gt = false;
            }
            for (i = 0; i < len; i = (short)(i + 1)) {
                remainder[(short)(i + len)] = 0;
                remainder[i] = quotient[i];
                quotient[i] = 0;
                divisor[i] = 0;
                divisor[(short)(i + len)] = 0;
            }
            divisor[len] = radix;
        }
        buf[charPos] = digits[remainder[0]];
        if (negative) {
            charPos = (short)(charPos - 1);
            buf[charPos] = neg;
        }
        for (k = 0; k < 21 && buf[k] == 0; k = (short)((short)(k + 1))) {
        }
        Util.arrayCopy(buf, k, dstString, dstOffset, (short)(21 - k));
        return (short)(21 - k);
    }

    public static short parseLongInteger(byte[] aString, short offset, short length, short[] integer, short ioffset) {
        byte b;
        short i;
        int radix = 0;
        boolean negative = false;
        short digit = 0;
        short[] buf = new short[5];
        short len = 1;
        if (aString[offset] == 45) {
            negative = true;
            offset = (short)(offset + 1);
            length = (short)(length - 1);
        }
        if (aString[offset] == 48 && length > 1) {
            if (aString[(short)(offset + 1)] == 120 || aString[(short)(offset + 1)] == 88) {
                offset = (short)(offset + 2);
                length = (short)(length - 2);
                radix = 16;
            } else {
                StringException.throwIt((short)2);
            }
        } else if (aString[offset] == 35) {
            offset = (short)(offset + 1);
            length = (short)(length - 1);
            radix = 16;
        } else {
            radix = 10;
        }
        if (length <= 0) {
            StringException.throwIt((short)2);
        }
        if (radix == 16) {
            while (length > 1 && aString[offset] == 48) {
                offset = (short)(offset + 1);
                length = (short)(length - 1);
            }
            short s = len = (short)(length / 4 * 4) < length ? (short)(length / 4 + 1) : (short)(length / 4);
            if (len > 4 || negative) {
                len = (short)4;
            }
            for (i = 0; i < len; i = (short)(i + 1)) {
                buf[(short)(ioffset + i)] = 0;
            }
            for (i = 0; i < length; i = (short)(i + 1)) {
                b = aString[(short)(offset + i)];
                if (b >= 48 && b <= 57) {
                    digit = (short)(b - 48);
                } else if (b >= 65 && b <= 70 || b >= 97 && b <= 102) {
                    digit = (short)((b & 0x1F) + 9);
                } else {
                    StringException.throwIt((short)2);
                }
                short off = (short)((short)(length - i - 1) % 4);
                short shortCount = (short)((short)(length - i - 1) / 4);
                buf[(short)(ioffset + shortCount)] = (short)(buf[(short)(ioffset + shortCount)] | digit << off * 4);
            }
        } else {
            b = aString[offset];
            if (b >= 48 && b <= 57) {
                digit = (short)(b - 48);
            } else {
                StringException.throwIt((short)2);
            }
            buf[ioffset] = digit;
            length = (short)(length - 1);
            offset = (short)(offset + 1);
            len = 1;
            while (length > 0) {
                short j;
                b = aString[offset];
                if (b >= 48 && b <= 57) {
                    digit = (short)(b - 48);
                } else {
                    StringException.throwIt((short)2);
                }
                short tmp = 0;
                short val = 0;
                short carry = 0;
                for (j = 0; j < len; j = (short)(j + 1)) {
                    tmp = carry;
                    carry = 0;
                    val = buf[(short)(ioffset + j)];
                    for (int i2 = 0; i2 < radix; i2 = (int)((short)(i2 + 1))) {
                        tmp = (short)(tmp + val);
                        if (buf[(short)(ioffset + j)] < 0 && tmp > 0 || (buf[(short)(ioffset + j)] < 0 && tmp < 0 || buf[(short)(ioffset + j)] > 0 && tmp > 0) && tmp < buf[(short)(ioffset + j)]) {
                            if (j == (short)(len - 1)) {
                                len = (short)(len + 1);
                                buf[(short)(ioffset + j + 1)] = 0;
                            }
                            carry = (short)(carry + 1);
                        }
                        buf[(short)(ioffset + j)] = tmp;
                    }
                }
                tmp = (short)(buf[ioffset] + digit);
                j = 0;
                carry = buf[ioffset] < 0 && tmp >= 0 || buf[ioffset] < 0 && tmp < 0 && tmp < buf[ioffset] ? (short)1 : 0;
                buf[ioffset] = tmp;
                while (carry == 1) {
                    if (j == (short)(len - 1)) {
                        len = (short)(len + 1);
                        buf[(short)(ioffset + j + 1)] = 0;
                        carry = 1;
                        continue;
                    }
                    j = (short)(j + 1);
                    tmp = (short)(buf[(short)(ioffset + j)] + 1);
                    carry = buf[(short)(ioffset + j)] < 0 && tmp >= 0 || buf[(short)(ioffset + j)] < 0 && tmp < 0 && tmp < buf[(short)(ioffset + j)] ? (short)1 : 0;
                    buf[(short)(ioffset + j)] = tmp;
                }
                length = (short)(length - 1);
                offset = (short)(offset + 1);
            }
            if (negative) {
                for (i = len; i < 4; i = (short)(i + 1)) {
                    buf[(short)(ioffset + i)] = 0;
                }
                len = (short)4;
            }
        }
        if (!(len != 4 || (buf[3] & Short.MIN_VALUE) != Short.MIN_VALUE || negative && buf[3] == Short.MIN_VALUE && buf[2] == 0 && buf[1] == 0 && buf[0] == 0)) {
            StringException.throwIt((short)2);
        }
        if (negative) {
            short j;
            boolean carry = false;
            for (j = 0; j < len; j = (short)(j + 1)) {
                buf[(short)(j + ioffset)] = ~buf[(short)(j + ioffset)];
            }
            if (buf[ioffset] == -1) {
                carry = true;
                buf[ioffset] = 0;
                j = 1;
            } else {
                short s = ioffset;
                buf[s] = (short)(buf[s] + 1);
            }
            while (carry) {
                carry = buf[(short)(j + ioffset)] == -1;
                short s = (short)(j + ioffset);
                buf[s] = (short)(buf[s] + 1);
                j = (short)(j + 1);
            }
        }
        for (i = 0; i < len; i = (short)(i + 1)) {
            integer[(short)(len - 1 - i)] = buf[i];
        }
        return len;
    }

    public static short convertTo(byte[] srcString, short srcOffset, short srcLength, byte[] dstString, short dstOffset, byte encoding) {
        if (encoding == 1) {
            if (StringUtil.check(srcString, srcOffset, srcLength)) {
                Util.arrayCopy(srcString, srcOffset, dstString, dstOffset, srcLength);
            } else {
                StringException.throwIt((short)3);
            }
            return srcLength;
        }
        if (encoding == 5) {
            int count = 0;
            for (short i = srcOffset; i < (short)(srcOffset + srcLength); i = (short)(i + 1)) {
                if ((srcString[i] & 0xF0) == 224) {
                    if ((srcString[(short)(i + 1)] & 0xC0) != 128 || (srcString[(short)(i + 2)] & 0xC0) != 128) {
                        StringException.throwIt((short)3);
                    }
                    dstString[(short)(2 * count + dstOffset)] = (byte)(srcString[i] << 4 & 0xF0 | srcString[(short)(i + 1)] >> 2 & 0xF);
                    dstString[(short)(2 * count + dstOffset + 1)] = (byte)(srcString[(short)(i + 1)] << 6 & 0xC0 | srcString[(short)(i + 2)] & 0x3F);
                    count = (short)(count + 1);
                    i = (short)(i + 2);
                    continue;
                }
                if ((srcString[i] & 0xE0) == 192) {
                    if ((srcString[(short)(i + 1)] & 0xC0) != 128) {
                        StringException.throwIt((short)3);
                    }
                    dstString[(short)(2 * count + dstOffset)] = (byte)(srcString[i] >> 2 & 7);
                    dstString[(short)(2 * count + dstOffset + 1)] = (byte)(srcString[i] << 6 & 0xC0 | srcString[(short)(i + 1)] & 0x3F);
                    count = (short)(count + 1);
                    i = (short)(i + 1);
                    continue;
                }
                if ((srcString[i] & 0x80) == 0) {
                    dstString[(short)(2 * count + dstOffset)] = 0;
                    dstString[(short)(2 * count + dstOffset + 1)] = srcString[i];
                    count = (short)(count + 1);
                    continue;
                }
                StringException.throwIt((short)3);
            }
            return (short)(2 * count);
        }
        StringException.throwIt((short)1);
        return 0;
    }

    public static short convertFrom(byte[] srcString, short srcOffset, short srcLength, byte[] dstString, short dstOffset, byte encoding) {
        short count = dstOffset;
        if (encoding == 1) {
            if (StringUtil.check(srcString, srcOffset, srcLength)) {
                Util.arrayCopy(srcString, srcOffset, dstString, dstOffset, srcLength);
            } else {
                StringException.throwIt((short)3);
            }
            return srcLength;
        }
        if (encoding == 5) {
            if (srcLength % 2 != 0) {
                StringException.throwIt((short)3);
            }
            for (short i = srcOffset; i < (short)(srcLength + srcOffset); i = (short)(i + 2)) {
                short codePoint = srcString[(short)(i + 1)];
                if ((codePoint = (short)((codePoint & 0xFF) + (srcString[i] << 8))) < 128 && codePoint >= 0) {
                    dstString[count] = (byte)codePoint;
                    count = (short)(count + 1);
                    continue;
                }
                if (codePoint < 2048 && codePoint >= 0) {
                    dstString[count] = (byte)(codePoint >> 6 | 0xC0);
                    dstString[(short)(count + 1)] = (byte)(codePoint & 0x3F | 0x80);
                    count = (short)(count + 2);
                    continue;
                }
                dstString[count] = (byte)(codePoint >> 12 & 0xEF | 0xE0);
                dstString[(short)(count + 1)] = (byte)(codePoint >> 6 & 0x3F | 0x80);
                dstString[(short)(count + 2)] = (byte)(codePoint & 0x3F | 0x80);
                count = (short)(count + 3);
            }
            return (short)(count - dstOffset);
        }
        StringException.throwIt((short)1);
        return 0;
    }

    public static boolean check(byte[] aString, short offset, short length) {
        for (short i = 0; i < length; i = (short)(i + 1)) {
            int j;
            if ((aString[(short)(i + offset)] & 0x80) == 0) continue;
            if ((aString[(short)(i + offset)] & 0xE0) == 192) {
                if ((i = (short)(i + 1)) < length && (aString[(short)(i + offset)] & 0xC0) == 128) continue;
                return false;
            }
            if ((aString[(short)(i + offset)] & 0xF0) == 224) {
                for (j = 0; j < 2; j = (int)((short)(j + 1))) {
                    if ((i = (short)(i + 1)) < length && (aString[(short)(i + offset)] & 0xC0) == 128) continue;
                    return false;
                }
                continue;
            }
            if ((aString[(short)(i + offset)] & 0xF8) == 240) {
                for (j = 0; j < 3; j = (int)((short)(j + 1))) {
                    if ((i = (short)(i + 1)) < length && (aString[(short)(i + offset)] & 0xC0) == 128) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean startsWith(byte[] aString, short offset, short length, byte[] prefix, short poffset, short plength, short codePointCount) {
        short endOffset = codePointCount >= 0 ? StringUtil.offsetByCodePoints(prefix, poffset, plength, (short)0, codePointCount) : plength;
        return length >= endOffset && Util.arrayCompare(aString, offset, prefix, poffset, endOffset) == 0;
    }

    public static boolean endsWith(byte[] aString, short offset, short length, byte[] suffix, short soffset, short slength, short codePointCount) {
        short endOffset = codePointCount >= 0 ? StringUtil.offsetByCodePoints(suffix, soffset, slength, (short)0, codePointCount) : slength;
        return length >= endOffset && Util.arrayCompare(aString, (short)(offset + length - endOffset), suffix, soffset, endOffset) == 0;
    }

    public static short substring(byte[] srcString, short srcOffset, short srcLength, short codePointBeginIndex, short codePointEndIndex, byte[] dstString, short dstOffset) {
        short beginOffset = (short)(srcOffset + StringUtil.offsetByCodePoints(srcString, srcOffset, srcLength, (short)0, codePointBeginIndex));
        short endOffset = codePointEndIndex >= 0 ? (short)(srcOffset + StringUtil.offsetByCodePoints(srcString, srcOffset, srcLength, (short)0, codePointEndIndex)) : (short)(srcOffset + srcLength);
        short l = Util.arrayCopy(srcString, beginOffset, dstString, dstOffset, (short)(endOffset - beginOffset));
        return l;
    }

    private StringUtil() {
    }
}

