/*
 * Decompiled with CFR 0.152.
 */
package javacardx.security;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.JCSystemAccessor;
import java.security.AccessController;
import javacard.security.Key;
import javacard.security.PrivateKey;
import javacardx.framework.JCRuntimePermission;
import javacardx.framework.JCSystem;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.security.SensitiveType;
import javacardx.security.SensitivityValue;
import javax.microedition.pki.Certificate;
import javax.microedition.pki.CertificateException;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
@SensitiveType(sensitivity=SensitivityValue.INTEGRITY)
public abstract class CredentialManager {
    public static final byte MODE_DEFAULT = 0;
    public static final byte MODE_GCF_CLIENT = 2;
    public static final byte MODE_GCF_SERVER = 3;
    public static final byte MODE_SIO_CLIENT = 4;
    public static final byte MODE_SIO_SERVER = 5;
    public static final byte MODE_WEB_SERVER = 1;

    public static final CredentialManager getCredentialManager(byte mode) {
        if (mode < 0 || mode > 5) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        AccessController.checkPermission(new JCRuntimePermission("credentialManager.get"));
        String appURI = JCSystem.getURI();
        return JCSystemAccessor.getJCSystemAccessor().getCredentialManager(appURI, mode);
    }

    public static final void setCredentialManager(CredentialManager manager, byte mode) {
        if (mode < 0 || mode > 5) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        AccessController.checkPermission(new JCRuntimePermission("credentialManager.set"));
        String appURI = JCSystem.getURI();
        JCSystemAccessor.getJCSystemAccessor().setCredentialManager(appURI, manager, mode);
    }

    public static final SecurityRequirements getSecurityRequirements(byte mode) {
        if (mode < 0 || mode > 5) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        String appURI = JCSystem.getURI();
        return JCSystemAccessor.getJCSystemAccessor().getSecurityRequirements(appURI, mode);
    }

    public static final void setSecurityRequirements(SecurityRequirements requirements, byte mode) {
        if (mode < 0 || mode > 5) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        String appURI = JCSystem.getURI();
        JCSystemAccessor.getJCSystemAccessor().setSecurityRequirements(appURI, requirements, mode);
    }

    public abstract void checkTrusted(Certificate[] var1, String var2, String var3, byte var4) throws CertificateException;

    public abstract Certificate[] getAcceptedCertificateIssuers(String var1, byte var2);

    public abstract Certificate[] chooseCertificateChain(String[] var1, String[] var2, String var3, byte var4);

    public abstract byte[] choosePreSharedKey(String var1, String var2, byte var3);

    public abstract String getPSKIdentityHint(String var1, byte var2);

    public abstract String getPSKIdentity(String var1, String var2, byte var3);

    public abstract PrivateKey getMatchingPrivateKey(Certificate var1, String var2, byte var3);

    public abstract Object[] getTrustedCredentials(String[] var1, String var2, byte var3);

    public abstract Key[] getCredentials(String[] var1, String var2, byte var3);

    @SensitiveType(sensitivity=SensitivityValue.INTEGRITY)
    public static class SecurityRequirements {
        public boolean isClientAuthRequired(String endpointURI, byte mode) {
            if (mode == 1) {
                int firewallId = NativeMethods.objectContext(this);
                return JCSystemAccessor.getJCSystemAccessor().isClientAuthRequired(firewallId, endpointURI, mode);
            }
            return false;
        }

        public boolean isIntegrityRequired(String endpointURI, byte mode) {
            if (mode == 1) {
                int firewallId = NativeMethods.objectContext(this);
                return JCSystemAccessor.getJCSystemAccessor().isIntegrityRequired(firewallId, endpointURI, mode);
            }
            return false;
        }

        public boolean isConfidentialityRequired(String endpointURI, byte mode) {
            if (mode == 1) {
                int firewallId = NativeMethods.objectContext(this);
                return JCSystemAccessor.getJCSystemAccessor().isConfidentialityRequired(firewallId, endpointURI, mode);
            }
            return false;
        }

        public String[] chooseCipherSuites(String[] supportedCipherSuites, String endpointURI, byte mode) {
            return null;
        }
    }
}

