/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.component;

import com.sun.javacard.Logger;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.component.LifeCycle;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class AbstractLifeCycle
implements LifeCycle {
    private final int FAILED = -1;
    private final int STOPPED = 0;
    private final int STARTING = 1;
    private final int STARTED = 2;
    private final int STOPPING = 3;
    private transient int state = 0;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    @Override
    public final void start() throws Exception {
        try {
            if (this.state == 2) {
                return;
            }
            this.state = 1;
            this.doStart();
            Logger.debug(this.getClass(), "started {}");
            this.state = 2;
        }
        catch (Exception e) {
            Logger.debug(this.getClass() + "  org.mortbay.component.AbstractLifeCycle.start() -> Exception " + e + "  " + this.getClass().getName());
            Logger.debug(this.getClass(), "failed {}");
            this.state = -1;
            throw e;
        }
        catch (Error e) {
            Logger.debug(this.getClass(), "failed {}");
            this.state = -1;
            throw e;
        }
    }

    @Override
    public final void stop() throws Exception {
        try {
            if (this.state < 1) {
                return;
            }
            this.state = 3;
            this.doStop();
            Logger.debug("stopped {}");
            this.state = 0;
        }
        catch (Exception e) {
            Logger.debug("failed {}");
            this.state = -1;
            throw e;
        }
        catch (Error e) {
            Logger.debug("failed {}");
            this.state = -1;
            throw e;
        }
    }

    @Override
    public boolean isRunning() {
        return this.state == 2 || this.state == 1;
    }

    @Override
    public boolean isStarted() {
        return this.state == 2;
    }

    @Override
    public boolean isStarting() {
        return this.state == 1;
    }

    @Override
    public boolean isStopping() {
        return this.state == 3;
    }

    @Override
    public boolean isFailed() {
        return this.state == -1;
    }
}

