/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import com.sun.javacard.Logger;
import java.io.IOException;
import java.io.InputStream;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.WebServer;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.StringUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class DefaultHandler
extends AbstractHandler {
    long faviconModified = System.currentTimeMillis() / 1000L * 1000L;
    byte[] favicon;
    boolean serveIcon = true;

    public DefaultHandler() {
        try {
            Logger.debug("org.mortbay.jetty.handler.DefaultHandler.DefaultHandler() -> Getting favIcon");
            InputStream fav = this.getClass().getResourceAsStream("/org/mortbay/jetty/favicon.ico");
            if (fav != null) {
                this.favicon = IO.readBytes(fav);
            }
        }
        catch (Exception e) {
            Logger.debug("org.mortbay.jetty.handler.DefaultHandler.DefaultHandler() -> favicon is NULL");
            Logger.debug(e);
        }
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
        LazyList<Handler> handlers;
        Request base_request;
        Request request2 = base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        if (response.isCommitted() || base_request.isHandled()) {
            return;
        }
        base_request.setHandled(true);
        String method = request.getMethod();
        if (this.serveIcon && this.favicon != null && method.equals("GET") && request.getRequestURI().equals("/favicon.ico")) {
            if (request.getDateHeader("If-Modified-Since") == this.faviconModified) {
                response.setStatus(304);
            } else {
                response.setStatus(200);
                response.setContentType("image/x-icon");
                response.setContentLength(this.favicon.length);
                response.setDateHeader("Last-Modified", this.faviconModified);
                response.getOutputStream().write(this.favicon);
            }
            return;
        }
        if (!method.equals("GET") || !request.getRequestURI().equals("/")) {
            response.sendError(404);
            return;
        }
        response.setStatus(404);
        response.setContentType("text/html");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1024);
        String uri = request.getRequestURI();
        uri = StringUtil.replace(uri, "<", "&lt;");
        uri = StringUtil.replace(uri, ">", "&gt;");
        writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
        writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
        writer.write("No context on this server matched or handled this request.<BR>");
        writer.write("Contexts known to this server are: <ul>");
        WebServer server = WebServer.getWebServer();
        LazyList<Handler> lazyList = handlers = server == null ? null : server.getChildHandlersByClass(ContextHandler.class);
        if (handlers != null) {
            for (Handler h : handlers) {
                ContextHandler context = (ContextHandler)h;
                if (context.isRunning()) {
                    writer.write("<li><a href=\"");
                    writer.write(context.getContextPath());
                    writer.write("/\">");
                    writer.write(context.getContextPath());
                    writer.write("&nbsp;--->&nbsp;");
                    writer.write(context.toString());
                    writer.write("</a></li>\n");
                    continue;
                }
                writer.write("<li>");
                writer.write(context.getContextPath());
                writer.write("&nbsp;--->&nbsp;");
                writer.write(context.toString());
                writer.write(" [stopped]");
                writer.write("</li>\n");
            }
        }
        writer.write("</ul><small><I>The links above may not work if a virtual host is configured</I></small>");
        for (int i = 0; i < 10; ++i) {
            writer.write("\n<!-- Padding for IE                  -->");
        }
        writer.write("\n</BODY>\n</HTML>\n");
        writer.flush();
        response.setContentLength(writer.size());
        ServletOutputStream out = response.getOutputStream();
        writer.writeTo(out);
        out.close();
    }

    public boolean getServeIcon() {
        return this.serveIcon;
    }

    public void setServeIcon(boolean serveIcon) {
        this.serveIcon = serveIcon;
    }
}

