/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import com.sun.javacard.Logger;
import com.sun.javacard.net.MalformedURLException;
import java.io.IOException;
import java.io.OutputStream;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.io.WriterOutputStream;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.resource.Resource;
import org.mortbay.util.URIUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ResourceHandler
extends AbstractHandler {
    Resource baseResource;
    String[] welcomeFiles = new String[]{"index.html"};
    MimeTypes mimeTypes = new MimeTypes();

    public Resource getBaseResource() {
        if (this.baseResource == null) {
            return null;
        }
        return this.baseResource;
    }

    public String getResourceBase() {
        if (this.baseResource == null) {
            return null;
        }
        return this.baseResource.toString();
    }

    public void setBaseResource(Resource base) {
        this.baseResource = base;
    }

    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(Resource.newResource(resourceBase));
        }
        catch (Exception e) {
            Logger.debug(e);
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if (this.baseResource == null) {
            return null;
        }
        try {
            path = URIUtil.canonicalPath(path);
            Resource resource = this.baseResource.addPath(path);
            return resource;
        }
        catch (Exception e) {
            Logger.debug(e);
            return null;
        }
    }

    protected Resource getResource(HttpServletRequest request) throws MalformedURLException {
        String path_info = request.getPathInfo();
        if (path_info == null) {
            return null;
        }
        return this.getResource(path_info);
    }

    public String[] getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
    }

    protected Resource getWelcome(Resource directory) throws IOException {
        for (String element : this.welcomeFiles) {
            Resource welcome = directory.addPath(element);
            if (!welcome.exists() || welcome.isDirectory()) continue;
            return welcome;
        }
        return null;
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
        long length;
        Buffer mime;
        long last_modified;
        Request base_request;
        Resource resource = null;
        Request request2 = base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        if (base_request.isHandled() || !request.getMethod().equals("GET")) {
            return;
        }
        try {
            resource = this.getResource(request);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (resource == null || !resource.exists()) {
            return;
        }
        base_request.setHandled(true);
        if (resource.isDirectory()) {
            if (!request.getPathInfo().endsWith("/")) {
                response.sendRedirect(request.getRequestURI() + "/");
                return;
            }
            if ((resource = this.getWelcome(resource)) == null || !resource.exists() || resource.isDirectory()) {
                response.sendError(403);
                return;
            }
        }
        if ((last_modified = resource.lastModified()) > 0L) {
            long if_modified = request.getDateHeader("If-Modified-Since");
            if (if_modified > 0L && last_modified / 1000L <= if_modified / 1000L) {
                response.setStatus(304);
                return;
            }
            response.setDateHeader("Last-Modified", last_modified);
        }
        if ((mime = this.mimeTypes.getMimeByExtension(request.getPathInfo())) != null) {
            response.setContentType(mime.toString());
        }
        if ((length = resource.length()) > 0L) {
            response.setHeader("Content-Length", Long.toString(length));
        }
        OutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        if (out instanceof HttpConnection.Output) {
            ((HttpConnection.Output)out).sendContent(resource.getInputStream());
        } else {
            resource.writeTo(out, 0L, length);
        }
    }
}

