/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import com.sun.javacard.Logger;
import com.sun.javacard.security.Principal;
import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.util.StringUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class BasicAuthenticator
implements Authenticator {
    @Override
    public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) throws IOException {
        Principal user = null;
        String credentials = request.getHeader("Authorization");
        request.clearHeader("Authorization");
        if (credentials != null) {
            try {
                Logger.debug("Credentials: " + credentials);
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                credentials = B64Code.decode(credentials, StringUtil.ISO_8859_1);
                int i = credentials.indexOf(58);
                String username = credentials.substring(0, i);
                String password = credentials.substring(i + 1);
                user = realm.authenticate(username, password, request, "BASIC");
                if (user == null) {
                    Logger.debug("AUTH FAILURE: user {}" + username);
                } else {
                    if (user.getName().equals("forbidden")) {
                        response.sendError(403);
                        return null;
                    }
                    request.setAuthType("BASIC");
                    request.setUserPrincipal(user);
                }
            }
            catch (Exception e) {
                Logger.debug("AUTH FAILURE: " + e.toString());
                Logger.debug(e);
            }
        }
        if (user == null && response != null) {
            this.sendChallenge(realm, response);
        }
        return user;
    }

    @Override
    public String getAuthMethod() {
        return "BASIC";
    }

    public void sendChallenge(UserRealm realm, Response response) throws IOException {
        response.setHeader("WWW-Authenticate", "basic realm=\"" + realm.getName() + '\"');
        response.sendError(401);
    }
}

