/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.Enumeration;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.mortbay.jetty.servlet.Holder;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class FilterHolder
extends Holder {
    private transient Filter filter;
    private transient Config config;

    public static int dispatch(String type) {
        if ("request".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("forward".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("include".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(type)) {
            return 8;
        }
        throw new IllegalArgumentException(type);
    }

    public FilterHolder() {
    }

    public FilterHolder(Class<? extends Filter> filter) {
        super(filter);
    }

    public FilterHolder(Filter filter) {
        this.setFilter(filter);
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        Class<Filter> cls = Filter.class;
        if (!cls.isAssignableFrom(this.clazz)) {
            String msg = this.clazz + " is not a javax.servlet.Filter";
            super.stop();
            throw new IllegalStateException(msg);
        }
        if (this.filter == null) {
            this.filter = (Filter)this.newInstance();
        }
        this.config = new Config();
        this.filter.init(this.config);
    }

    @Override
    public void doStop() {
        if (!this.extInstance) {
            if (this.filter != null) {
                this.filter.destroy();
            }
            this.filter = null;
        }
        this.config = null;
        super.doStop();
    }

    public synchronized void setFilter(Filter filter) {
        this.filter = filter;
        this.extInstance = true;
        this.setHeldClass(filter.getClass());
        if (this.getName() == null) {
            this.setName(filter.getClass().getName());
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    class Config
    implements FilterConfig {
        Config() {
        }

        @Override
        public String getFilterName() {
            return FilterHolder.this.name;
        }

        @Override
        public ServletContext getServletContext() {
            return FilterHolder.this.servletHandler.getServletContext();
        }

        @Override
        public String getInitParameter(String param) {
            return FilterHolder.this.getInitParameter(param);
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return FilterHolder.this.getInitParameterNames();
        }
    }
}

