/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import com.sun.javacard.ContextManager;
import com.sun.javacard.Logger;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;
import org.mortbay.util.MultiMap;
import org.mortbay.util.URIUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ServletHandler
extends AbstractHandler {
    public static final String DEFAULT_SERVLET = "default";
    public static final String J_S_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    public static final String J_S_ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String J_S_ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String J_S_ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String J_S_ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    private ContextHandler contextHandler;
    private ContextHandler.Context servletContext;
    private LazyList<FilterHolder> filters;
    private LazyList<FilterMapping> filterMappings;
    private boolean filterChainsCached = true;
    private int maxFilterChainsCacheSize = 1000;
    private LazyList<ServletHolder> servletHolders;
    private LazyList<ServletMapping> servletMappings;
    private boolean initializeAtStart = true;
    private transient Hashtable<String, FilterHolder> filterNameMap;
    private transient Vector<FilterMapping> filterPathMappings;
    private transient MultiMap<FilterMapping> filterNameMappings;
    private transient Hashtable<String, ServletHolder> servletNameMap;
    private transient PathMap<ServletHolder> servletPathMap;
    protected transient Hashtable<String, FilterChain>[] chainCache;
    protected transient Hashtable<String, FilterChain>[] namedChainCache;

    @Override
    protected synchronized void doStart() throws Exception {
        this.servletContext = ContextManager.getCurrentContext();
        this.contextHandler = this.servletContext == null ? null : this.servletContext.getContextHandler();
        this.updateMappings();
        if (this.isInitializeAtStart()) {
            this.initialize();
        }
        if (this.filterChainsCached && this.filters != null && LazyList.size(this.filters) > 0) {
            this.chainCache = new Hashtable[]{null, new Hashtable(), new Hashtable(), null, new Hashtable(), null, null, null, new Hashtable()};
            this.namedChainCache = new Hashtable[]{null, null, new Hashtable(), null, new Hashtable(), null, null, null, new Hashtable()};
        }
        super.doStart();
    }

    @Override
    protected synchronized void doStop() throws Exception {
        super.doStop();
        if (this.filters != null) {
            for (FilterHolder f : this.filters) {
                try {
                    f.stop();
                }
                catch (Exception e) {
                    Logger.debug(e);
                }
            }
        }
        if (this.servletHolders != null) {
            for (ServletHolder sh : this.servletHolders) {
                try {
                    sh.stop();
                }
                catch (Exception e) {
                    Logger.debug(e);
                }
            }
        }
        this.filterNameMap = null;
        this.filterPathMappings = null;
        this.filterNameMappings = null;
        this.servletNameMap = null;
        this.servletPathMap = null;
        this.chainCache = null;
        this.namedChainCache = null;
    }

    public LazyList<FilterMapping> getFilterMappings() {
        return this.filterMappings;
    }

    public LazyList<FilterHolder> getFilters() {
        return this.filters;
    }

    public PathMap.Entry<ServletHolder> getHolderEntry(String pathInContext) {
        return this.servletPathMap.getMatch(pathInContext);
    }

    public RequestDispatcher getRequestDispatcher(String uriInContext) {
        if (uriInContext == null) {
            return null;
        }
        if (!uriInContext.startsWith("/")) {
            return null;
        }
        try {
            String query = null;
            int q = 0;
            q = uriInContext.indexOf(63);
            if (q > 0) {
                query = uriInContext.substring(q + 1);
                uriInContext = uriInContext.substring(0, q);
            }
            if ((q = uriInContext.indexOf(59)) > 0) {
                uriInContext = uriInContext.substring(0, q);
            }
            String pathInContext = URIUtil.canonicalPath(URIUtil.decodePath(uriInContext));
            String uri = URIUtil.addPaths(this.contextHandler.getContextPath(), uriInContext);
            return new Dispatcher(this.contextHandler, uri, pathInContext, query);
        }
        catch (Exception e) {
            Logger.debug(e);
            return null;
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public LazyList<ServletMapping> getServletMappings() {
        return this.servletMappings;
    }

    public LazyList<ServletHolder> getServlets() {
        return this.servletHolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int type) throws IOException, ServletException {
        if (!this.isStarted()) {
            return;
        }
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        String old_servlet_name = base_request.getServletName();
        String old_servlet_path = base_request.getServletPath();
        String old_path_info = base_request.getPathInfo();
        try {
            ServletHolder servlet_holder = null;
            FilterChain chain = null;
            if (target.startsWith("/")) {
                PathMap.Entry<ServletHolder> entry = this.getHolderEntry(target);
                if (entry != null) {
                    servlet_holder = entry.getValue();
                    base_request.setServletName(servlet_holder.getName());
                    String servlet_path_spec = entry.getKey();
                    String servlet_path = entry.getMapped() != null ? entry.getMapped() : PathMap.pathMatch(servlet_path_spec, target);
                    String path_info = PathMap.pathInfo(servlet_path_spec, target);
                    if (type == 4) {
                        base_request.setAttribute("javax.servlet.include.servlet_path", servlet_path);
                        base_request.setAttribute("javax.servlet.include.path_info", path_info);
                    } else {
                        base_request.setServletPath(servlet_path);
                        base_request.setPathInfo(path_info);
                    }
                    if (servlet_holder != null && this.filterMappings != null && LazyList.size(this.filterMappings) > 0) {
                        chain = this.getFilterChain(type, target, servlet_holder);
                    }
                }
            } else {
                servlet_holder = this.servletNameMap.get(target);
                if (servlet_holder != null && this.filterMappings != null && LazyList.size(this.filterMappings) > 0) {
                    base_request.setServletName(servlet_holder.getName());
                    chain = this.getFilterChain(type, null, servlet_holder);
                }
            }
            if (servlet_holder != null) {
                base_request.setHandled(true);
                if (chain != null) {
                    chain.doFilter(request, response);
                } else {
                    servlet_holder.handle(request, response);
                }
            } else {
                this.notFound(request, response);
            }
        }
        catch (RetryRequest e) {
            base_request.setHandled(false);
            throw e;
        }
        catch (EofException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            Throwable th = e;
            Logger.debug("### ServletHandler.handle(): Caught Exception, cause = " + th.getClass());
            if (type == 2 || type == 4) {
                if (th instanceof ServletException) {
                    throw (ServletException)th;
                }
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw new ServletException(th);
            }
            if (th instanceof ServletException) {
                Throwable cause = ((ServletException)th).getRootCause();
                Logger.debug("### ServletHandler.handle(): Instance of ServletException, root cause = " + cause);
                if (cause != th && cause != null) {
                    th = cause;
                }
            }
            if (th instanceof HttpException) {
                throw (HttpException)th;
            }
            if (!(th instanceof IOException)) {
                // empty if block
            }
            if (!response.isCommitted()) {
                request.setAttribute(J_S_ERROR_EXCEPTION, th);
                if (th instanceof UnavailableException) {
                    UnavailableException ue = (UnavailableException)th;
                    Logger.debug("### ServletHandler.handle(): UnavailableException, permanent = " + ue.isPermanent() + ",time = " + ue.getUnavailableSeconds());
                    if (ue.isPermanent()) {
                        response.sendError(404, th.getMessage());
                    } else {
                        if (ue.getUnavailableSeconds() >= 0) {
                            response.setIntHeader("Retry-After", ue.getUnavailableSeconds());
                        }
                        response.sendError(503, th.getMessage());
                    }
                } else {
                    response.sendError(500, th.getMessage());
                }
            }
        }
        catch (Error e) {
            if (!response.isCommitted()) {
                request.setAttribute(J_S_ERROR_EXCEPTION, e);
                response.sendError(500, e.getMessage());
            }
        }
        finally {
            base_request.setServletName(old_servlet_name);
            if (type != 4) {
                base_request.setServletPath(old_servlet_path);
                base_request.setPathInfo(old_path_info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterChain getFilterChain(int requestType, String pathInContext, ServletHolder servletHolder) {
        String key;
        String string = key = pathInContext == null ? servletHolder.getName() : pathInContext;
        if (this.filterChainsCached && this.chainCache != null) {
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (this.chainCache[requestType].containsKey(key)) {
                    return this.chainCache[requestType].get(key);
                }
            }
        }
        LazyList<FilterHolder> filters = null;
        if (pathInContext != null && this.filterPathMappings != null) {
            for (int i = 0; i < this.filterPathMappings.size(); ++i) {
                FilterMapping mapping = this.filterPathMappings.elementAt(i);
                if (!mapping.appliesTo(pathInContext, requestType)) continue;
                filters = LazyList.add(filters, mapping.getFilterHolder());
            }
        }
        if (servletHolder != null && this.filterNameMappings != null && this.filterNameMappings.size() > 0 && this.filterNameMappings.size() > 0) {
            FilterMapping mapping;
            int i;
            LazyList<FilterMapping> o = this.filterNameMappings.get(servletHolder.getName());
            for (i = 0; i < LazyList.size(o); ++i) {
                mapping = LazyList.get(o, i);
                if (!mapping.appliesTo(requestType)) continue;
                filters = LazyList.add(filters, mapping.getFilterHolder());
            }
            o = this.filterNameMappings.get("*");
            for (i = 0; i < LazyList.size(o); ++i) {
                mapping = LazyList.get(o, i);
                if (!mapping.appliesTo(requestType)) continue;
                filters = LazyList.add(filters, mapping.getFilterHolder());
            }
        }
        if (filters == null) {
            return null;
        }
        FilterChain chain = null;
        if (this.filterChainsCached) {
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (LazyList.size(filters) > 0) {
                    chain = new CachedChain(filters, servletHolder);
                }
                if (this.maxFilterChainsCacheSize > 0 && this.chainCache[requestType].size() > this.maxFilterChainsCacheSize) {
                    this.chainCache[requestType].clear();
                }
                this.chainCache[requestType].put(key, chain);
            }
        } else if (LazyList.size(filters) > 0) {
            chain = new Chain(filters, servletHolder);
        }
        return chain;
    }

    public boolean isInitializeAtStart() {
        return this.initializeAtStart;
    }

    public void setInitializeAtStart(boolean initializeAtStart) {
        this.initializeAtStart = initializeAtStart;
    }

    public void initialize() throws Exception {
        MultiException mx = new MultiException();
        if (this.filters != null) {
            for (FilterHolder filterHolder : this.filters) {
                filterHolder.start();
            }
        }
        if (this.servletHolders != null) {
            for (ServletHolder servletHolder : this.servletHolders) {
                try {
                    if (servletHolder.getClassName() == null && servletHolder.getForcedPath() != null) {
                        ServletHolder forced_holder = this.servletPathMap.match(servletHolder.getForcedPath());
                        if (forced_holder == null) {
                            mx.add(new IllegalStateException("No servlet for " + servletHolder.getForcedPath()));
                            continue;
                        }
                        servletHolder.setClassName(forced_holder.getClassName());
                    }
                    servletHolder.start();
                }
                catch (Exception e) {
                    Logger.debug(e);
                    mx.add(e);
                }
            }
            mx.ifExceptionThrow();
        }
    }

    private ServletHolder[] duplicate(ServletHolder[] holders) {
        ServletHolder[] copy = new ServletHolder[holders.length];
        for (int i = 0; i < holders.length; ++i) {
            copy[i] = holders[i];
        }
        return copy;
    }

    public boolean isFilterChainsCached() {
        return this.filterChainsCached;
    }

    protected final ServletHolder newServletHolder() {
        return null;
    }

    public ServletHolder newServletHolder(Class<? extends Servlet> servlet) {
        return new ServletHolder(servlet);
    }

    public ServletHolder addServletWithMapping(String className, String pathSpec) {
        ServletHolder holder = this.newServletHolder(null);
        holder.setName(className);
        holder.setClassName(className);
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public ServletHolder addServletWithMapping(Class<? extends Servlet> servlet, String pathSpec) {
        ServletHolder holder = this.newServletHolder(servlet);
        this.setServlets(LazyList.add(this.getServlets(), holder));
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public void addServletWithMapping(ServletHolder servlet, String pathSpec) {
        LazyList<ServletHolder> holders = this.getServlets();
        try {
            this.setServlets(LazyList.add(holders, servlet));
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(servlet.getName());
            mapping.setPathSpec(pathSpec);
            this.setServletMappings(LazyList.add(this.getServletMappings(), mapping));
        }
        catch (Exception e) {
            this.setServlets(holders);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this.addServletWithMapping(className, pathSpec);
    }

    public void addServlet(ServletHolder holder) {
        this.setServlets(LazyList.add(this.getServlets(), holder));
    }

    public void addServletMapping(ServletMapping mapping) {
        this.setServletMappings(LazyList.add(this.getServletMappings(), mapping));
    }

    public FilterHolder newFilterHolder(Class<? extends Filter> filter) {
        return new FilterHolder(filter);
    }

    public FilterHolder addFilterWithMapping(Class<? extends Filter> filter, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(filter);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public FilterHolder addFilterWithMapping(String className, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(null);
        holder.setName(className);
        holder.setClassName(className);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, int dispatches) {
        LazyList<FilterHolder> holders = this.getFilters();
        try {
            this.setFilters(LazyList.add(holders, holder));
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            mapping.setPathSpec(pathSpec);
            mapping.setDispatches(dispatches);
            this.setFilterMappings(LazyList.add(this.getFilterMappings(), mapping));
        }
        catch (RuntimeException e) {
            this.setFilters(holders);
            throw e;
        }
        catch (Error e) {
            this.setFilters(holders);
            throw e;
        }
    }

    private FilterHolder[] duplicate(FilterHolder[] holders) {
        FilterHolder[] copy = new FilterHolder[holders.length];
        for (int i = 0; i < holders.length; ++i) {
            copy[i] = holders[i];
        }
        return copy;
    }

    public FilterHolder addFilter(String className, String pathSpec, int dispatches) {
        return this.addFilterWithMapping(className, pathSpec, dispatches);
    }

    public void addFilter(FilterHolder filter, FilterMapping filterMapping) {
        if (filter != null) {
            this.setFilters(LazyList.add(this.getFilters(), filter));
        }
        if (filterMapping != null) {
            this.setFilterMappings(LazyList.add(this.getFilterMappings(), filterMapping));
        }
    }

    public void addFilter(FilterHolder filter) {
        if (filter != null) {
            this.setFilters(LazyList.add(this.getFilters(), filter));
        }
    }

    public void addFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            this.setFilterMappings(LazyList.add(this.getFilterMappings(), mapping));
        }
    }

    protected synchronized void updateMappings() {
        Hashtable<String, Holder> nm;
        if (this.servletHolders == null) {
            this.servletNameMap = null;
        } else {
            nm = new Hashtable<String, Holder>();
            for (ServletHolder servletHolder : this.servletHolders) {
                nm.put(servletHolder.getName(), servletHolder);
                servletHolder.setServletHandler(this);
            }
            this.servletNameMap = nm;
        }
        if (this.servletMappings == null || this.servletNameMap == null) {
            this.servletPathMap = null;
        } else {
            PathMap<ServletHolder> pm = new PathMap<ServletHolder>();
            for (ServletMapping servletMapping : this.servletMappings) {
                String[] pathSpecs;
                ServletHolder servlet_holder = this.servletNameMap.get(servletMapping.getServletName());
                if (servlet_holder == null) {
                    throw new IllegalStateException("No such servlet: " + servletMapping.getServletName());
                }
                if (servletMapping.getPathSpecs() == null) continue;
                for (String element0 : pathSpecs = servletMapping.getPathSpecs()) {
                    if (element0 == null) continue;
                    pm.put(element0, servlet_holder);
                }
            }
            this.servletPathMap = pm;
        }
        if (this.filters == null) {
            this.filterNameMap = null;
        } else {
            nm = new Hashtable();
            for (FilterHolder filterHolder : this.filters) {
                nm.put(filterHolder.getName(), filterHolder);
                filterHolder.setServletHandler(this);
            }
            this.filterNameMap = nm;
        }
        if (this.filterMappings == null) {
            this.filterPathMappings = null;
            this.filterNameMappings = null;
        } else {
            this.filterPathMappings = new Vector();
            this.filterNameMappings = new MultiMap();
            for (FilterMapping element : this.filterMappings) {
                String[] names;
                FilterHolder filterHolder = this.filterNameMap.get(element.getFilterName());
                if (filterHolder == null) {
                    throw new IllegalStateException("No filter named " + element.getFilterName());
                }
                element.setFilterHolder(filterHolder);
                if (element.getPathSpecs() != null) {
                    this.filterPathMappings.addElement(element);
                }
                if (element.getServletNames() == null) continue;
                for (String element0 : names = element.getServletNames()) {
                    if (element0 == null) continue;
                    this.filterNameMappings.add(element0, element);
                }
            }
        }
        Logger.debug("filterNameMap=" + this.filterNameMap);
        Logger.debug("pathFilters=" + this.filterPathMappings);
        Logger.debug("servletFilterMap=" + this.filterNameMappings);
        Logger.debug("servletPathMap=" + this.servletPathMap);
        Logger.debug("servletNameMap=" + this.servletNameMap);
        try {
            if (this.isStarted()) {
                this.initialize();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Logger.debug("Not Found " + request.getRequestURI());
        response.sendError(404);
    }

    public void setFilterChainsCached(boolean filterChainsCached) {
        this.filterChainsCached = filterChainsCached;
    }

    public void setFilterMappings(LazyList<FilterMapping> filterMappings) {
        this.filterMappings = filterMappings;
        if (this.isStarted()) {
            this.updateMappings();
        }
    }

    public synchronized void setFilters(LazyList<FilterHolder> holders) {
        this.filters = holders;
    }

    public void setServletMappings(LazyList<ServletMapping> servletMappings) {
        this.servletMappings = servletMappings;
        if (this.isStarted()) {
            this.updateMappings();
        }
    }

    public synchronized void setServlets(LazyList<ServletHolder> holders) {
        this.servletHolders = holders;
        this.updateMappings();
    }

    public int getMaxFilterChainsCacheSize() {
        return this.maxFilterChainsCacheSize;
    }

    public void setMaxFilterChainsCacheSize(int maxFilterChainsCacheSize) {
        this.maxFilterChainsCacheSize = maxFilterChainsCacheSize;
    }

    private class Chain
    implements FilterChain {
        int filter = 0;
        LazyList<FilterHolder> chain;
        ServletHolder servletHolder;

        Chain(LazyList<FilterHolder> filters, ServletHolder servletHolder) {
            this.chain = filters;
            this.servletHolder = servletHolder;
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            Logger.debug("doFilter " + this.filter);
            if (this.filter < LazyList.size(this.chain)) {
                FilterHolder holder = LazyList.get(this.chain, this.filter++);
                Logger.debug("call filter " + holder);
                Filter filter = holder.getFilter();
                filter.doFilter(request, response, this);
                return;
            }
            if (this.servletHolder != null) {
                Logger.debug("call servlet " + this.servletHolder);
                this.servletHolder.handle(request, response);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < LazyList.size(this.chain); ++i) {
                b.append(LazyList.get(this.chain, i).toString());
                b.append("->");
            }
            b.append(this.servletHolder);
            return b.toString();
        }
    }

    private class CachedChain
    implements FilterChain {
        FilterHolder filterHolder;
        CachedChain next;
        ServletHolder servletHolder;

        CachedChain(LazyList<FilterHolder> filters, ServletHolder servletHolder) {
            if (LazyList.size(filters) > 0) {
                this.filterHolder = LazyList.get(filters, 0);
                filters = LazyList.remove(filters, 0);
                this.next = new CachedChain(filters, servletHolder);
            } else {
                this.servletHolder = servletHolder;
            }
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.filterHolder != null) {
                Logger.debug("call filter " + this.filterHolder);
                Filter filter = this.filterHolder.getFilter();
                filter.doFilter(request, response, this.next);
                return;
            }
            if (this.servletHolder != null) {
                Logger.debug("call servlet " + this.servletHolder);
                this.servletHolder.handle(request, response);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            if (this.filterHolder != null) {
                return this.filterHolder + "->" + this.next.toString();
            }
            if (this.servletHolder != null) {
                return this.servletHolder.toString();
            }
            return "null";
        }
    }
}

