/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import com.sun.javacard.ClassLoader;
import com.sun.javacard.Logger;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.net.MalformedURLException;
import java.io.IOException;
import java.util.EventListener;
import java.util.Hashtable;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.resource.Resource;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.StringUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class WebAppContext
extends Context {
    public static final String WEB_DEFAULTS_XML = "/org/mortbay/jetty/webapp/webdefault.xml";
    public static final String ERROR_PAGE = "org.mortbay.jetty.error_page";
    private String[] configurationClasses = new String[]{"org.mortbay.jetty.webapp.WebInfConfiguration", "org.mortbay.jetty.webapp.WebXmlConfiguration"};
    private Configuration[] configurations;
    private String defaultsDescriptor = "/org/mortbay/jetty/webapp/webdefault.xml";
    private boolean distributable = false;
    private boolean extractWAR = true;
    private boolean parentLoaderPriority = false;
    private String[] systemClasses = new String[]{"java.", "javax.servlet.", "javax.xml.", "org.mortbay.naming.", "org.mortbay.log.", "org.mortbay.util.", "org.xml.", "org.w3c.", "org.apache.commons.logging.", "org.apache.log4j."};
    private String[] serverClasses = new String[]{"org.mortbay.jetty.", "org.slf4j."};
    private FileConnection tmpDir;
    private boolean isExistingTmpDir;
    private String war;
    private transient Hashtable<String, String> resourceAliases;
    private transient boolean ownClassLoader = false;

    public WebAppContext(String webApp, String contextPath, ClassLoader appClassLoader) {
        super(null, contextPath, 3);
        this.setContextPath(contextPath);
        this.setWar(webApp);
        this.setErrorHandler(new WebAppErrorHandler());
        this.setClassLoader(appClassLoader);
    }

    public void setResourceAlias(String alias, String uri) {
        if (this.resourceAliases == null) {
            this.resourceAliases = new Hashtable(5);
        }
        this.resourceAliases.put(alias, uri);
    }

    public String getResourceAlias(String alias) {
        if (this.resourceAliases == null) {
            return null;
        }
        return this.resourceAliases.get(alias);
    }

    public String removeResourceAlias(String alias) {
        if (this.resourceAliases == null) {
            return null;
        }
        return this.resourceAliases.remove(alias);
    }

    @Override
    public Resource getResource(String uriInContext) throws MalformedURLException {
        Logger.debug("org.mortbay.jetty.webapp.WebAppContext.getResource() -> " + uriInContext);
        IOException ioe = null;
        Resource resource = null;
        int loop = 0;
        while (uriInContext != null && loop++ < 100) {
            try {
                resource = super.getResource(uriInContext);
                if (resource != null && resource.exists()) {
                    return resource;
                }
                uriInContext = this.getResourceAlias(uriInContext);
            }
            catch (IOException e) {
                Logger.debug(e);
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null && ioe instanceof MalformedURLException) {
            throw (MalformedURLException)ioe;
        }
        return resource;
    }

    @Override
    protected void doStart() throws Exception {
        Logger.debug("org.mortbay.jetty.webapp.WebAppContext.doStart() -> ");
        this.loadConfigurations();
        for (Configuration element : this.configurations) {
            element.setWebAppContext(this);
        }
        this.ownClassLoader = true;
        this.getTempDirectory();
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        try {
            int i = this.configurations.length;
            while (i-- > 0) {
                this.configurations[i].deconfigureWebApp();
            }
            this.configurations = null;
            if (this.securityHandler.getHandler() == null) {
                this.sessionHandler.setHandler(this.securityHandler);
                this.securityHandler.setHandler(this.servletHandler);
            }
            if (!this.isExistingTmpDir && !this.isTempWorkDirectory()) {
                IO.delete(this.tmpDir);
            }
        }
        finally {
            if (this.ownClassLoader) {
                this.setClassLoader(null);
            }
        }
    }

    public String[] getConfigurationClasses() {
        return this.configurationClasses;
    }

    public Configuration[] getConfigurations() {
        return this.configurations;
    }

    public String getDefaultsDescriptor() {
        return this.defaultsDescriptor;
    }

    public String[] getServerClasses() {
        return this.serverClasses;
    }

    public FileConnection getTempDirectory() throws IOException {
        if (this.tmpDir != null) {
            return this.tmpDir;
        }
        Object t = this.getAttribute("javax.servlet.context.tempdir");
        if (t != null && t instanceof FileConnection) {
            this.tmpDir = (FileConnection)t;
            if (this.tmpDir.isDirectory() && this.tmpDir.canWrite()) {
                return this.tmpDir;
            }
        }
        if (t != null && t instanceof String) {
            try {
                this.tmpDir = new FileConnection((String)t);
                if (this.tmpDir.isDirectory() && this.tmpDir.canWrite()) {
                    Logger.debug("Converted to File " + this.tmpDir + " for " + this);
                    this.setAttribute("javax.servlet.context.tempdir", this.tmpDir);
                    return this.tmpDir;
                }
            }
            catch (Exception e) {
                Logger.debug(this.getClass(), e);
            }
        }
        FileConnection work = null;
        try {
            Resource web_inf;
            FileConnection w = new FileConnection(System.getProperty("jetty.home"), "work");
            if (w.exists() && w.canWrite() && w.isDirectory()) {
                work = w;
            } else if (this.getBaseResource() != null && (web_inf = this.getWebInf()) != null && web_inf.exists() && (w = new FileConnection(web_inf.getFile(), "work")).exists() && w.canWrite() && w.isDirectory()) {
                work = w;
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
        try {
            String temp = this.getCanonicalNameForWebAppTmpDir();
            if (work != null) {
                this.tmpDir = new FileConnection(work, temp);
            } else {
                this.tmpDir = new FileConnection(System.getProperty("java.io.tmpdir"), temp);
                if (this.tmpDir.exists()) {
                    Logger.debug("Delete existing temp dir " + this.tmpDir + " for " + this);
                    if (!IO.delete(this.tmpDir)) {
                        Logger.debug("Failed to delete temp dir " + this.tmpDir);
                    }
                    if (this.tmpDir.exists()) {
                        String old = this.tmpDir.toString();
                        this.tmpDir = FileConnection.createTempFile(temp + "_", "");
                        if (this.tmpDir.exists()) {
                            this.tmpDir.delete();
                        }
                        Logger.debug("Can't reuse " + old + ", using " + this.tmpDir);
                    }
                }
            }
            if (!this.tmpDir.exists()) {
                this.tmpDir.mkdirs();
            }
            if (!this.isTempWorkDirectory()) {
                this.tmpDir.deleteOnExit();
            }
            Logger.debug("Created temp dir " + this.tmpDir + " for " + this);
        }
        catch (Exception e) {
            this.tmpDir = null;
            Logger.debug(e);
        }
        if (this.tmpDir == null) {
            try {
                this.tmpDir = FileConnection.createTempFile("JettyContext", "");
                if (this.tmpDir.exists()) {
                    this.tmpDir.delete();
                }
                this.tmpDir.mkdirs();
                this.tmpDir.deleteOnExit();
                Logger.debug("Created temp dir " + this.tmpDir + " for " + this);
            }
            catch (Exception e) {
                Logger.debug("tmpdir", e);
                throw new IOException("unable to create temp dir");
            }
        }
        this.setAttribute("javax.servlet.context.tempdir", this.tmpDir);
        return this.tmpDir;
    }

    public boolean isTempWorkDirectory() throws IOException {
        FileConnection tmpDirectory = this.getTempDirectory();
        if (tmpDirectory == null) {
            return false;
        }
        if (tmpDirectory.getName().equalsIgnoreCase("work")) {
            return true;
        }
        if ((tmpDirectory = tmpDirectory.getParentFile()) == null) {
            return false;
        }
        return tmpDirectory.getName().equalsIgnoreCase("work");
    }

    public String getWar() {
        if (this.war == null) {
            this.war = this.getResourceBase();
        }
        return this.war;
    }

    public Resource getWebInf() throws IOException {
        this.resolveWebApp();
        Resource web_inf = super.getBaseResource().addPath("WEB-INF/");
        if (!web_inf.exists() || !web_inf.isDirectory()) {
            return null;
        }
        return web_inf;
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public boolean isExtractWAR() {
        return this.extractWAR;
    }

    public boolean isParentLoaderPriority() {
        return this.parentLoaderPriority;
    }

    protected void loadConfigurations() throws Exception {
        if (this.configurations != null) {
            return;
        }
        this.configurations = new Configuration[this.configurationClasses.length];
        for (int i = 0; i < this.configurations.length; ++i) {
            this.configurations[i] = (Configuration)Loader.loadClass(this.getClass(), this.configurationClasses[i], this.getClassLoader()).newInstance();
        }
    }

    @Override
    protected boolean isProtectedTarget(String target) {
        return StringUtil.startsWithIgnoreCase(target, "/web-inf") || StringUtil.startsWithIgnoreCase(target, "/meta-inf");
    }

    protected void resolveWebApp() throws IOException {
        Resource web_app = super.getBaseResource();
        if (web_app == null) {
            if (this.war == null || this.war.length() == 0) {
                this.war = this.getResourceBase();
            }
            if ((web_app = Resource.newResource(this.war)).getAlias() != null) {
                Logger.debug(web_app + " anti-aliased to " + web_app.getAlias());
                web_app = Resource.newResource(web_app.getAlias());
            }
            Logger.debug("Try webapp=" + web_app + ", exists=" + web_app.exists() + ", directory=" + web_app.isDirectory());
            if (!web_app.exists() || !web_app.isDirectory()) {
                Logger.debug("Web application not found " + this.war);
                throw new IOException(this.war + "  Not found");
            }
            Logger.debug("webapp=" + web_app);
            super.setBaseResource(web_app);
        }
    }

    public void setConfigurationClasses(String[] configurations) {
        this.configurationClasses = configurations;
    }

    public void setConfigurations(Configuration[] configurations) {
        this.configurations = configurations;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this.defaultsDescriptor = defaultsDescriptor;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    @Override
    public void setEventListeners(LazyList<EventListener> eventListeners) {
        if (this.sessionHandler != null) {
            this.sessionHandler.clearEventListeners();
        }
        super.setEventListeners(eventListeners);
        if (eventListeners != null) {
            for (EventListener listener : eventListeners) {
                if (!(listener instanceof HttpSessionAttributeListener) && !(listener instanceof HttpSessionBindingListener) && !(listener instanceof HttpSessionListener) || this.sessionHandler == null) continue;
                this.sessionHandler.addEventListener(listener);
            }
        }
    }

    @Override
    public void addEventListener(EventListener listener) {
        this.setEventListeners(LazyList.add(this.getEventListeners(), listener));
    }

    public void setExtractWAR(boolean extractWAR) {
        this.extractWAR = extractWAR;
    }

    public void setParentLoaderPriority(boolean java2compliant) {
        this.parentLoaderPriority = java2compliant;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this.securityHandler = securityHandler;
    }

    public void setServerClasses(String[] serverClasses) {
        this.serverClasses = serverClasses;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this.servletHandler = servletHandler;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void setTempDirectory(FileConnection dir) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        Logger.debug("org.mortbay.jetty.webapp.WebAppContext.setTempDirectory() -> [[. .]] " + dir);
        if (dir != null) {
            dir = new FileConnection(dir.getCanonicalPath());
        }
        try {
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
                dir.deleteOnExit();
            } else if (dir != null) {
                this.isExistingTmpDir = true;
            }
            if (!(dir == null || dir.exists() && dir.isDirectory() && dir.canWrite())) {
                throw new IllegalArgumentException("Bad temp directory: " + dir);
            }
        }
        catch (IOException e) {
            Logger.debug("IOException by FileConnection");
        }
        this.tmpDir = dir;
        this.setAttribute("javax.servlet.context.tempdir", this.tmpDir);
    }

    public void setWar(String war) {
        this.war = war;
    }

    @Override
    protected void startContext() throws Exception {
        Resource work;
        for (Configuration element : this.configurations) {
            element.configureDefaults();
        }
        Resource web_inf = this.getWebInf();
        if (web_inf != null && (work = web_inf.addPath("work")).exists() && work.isDirectory() && work.getFile() != null && work.getFile().canWrite() && this.getAttribute("javax.servlet.context.tempdir") == null) {
            this.setAttribute("javax.servlet.context.tempdir", work.getFile());
        }
        for (Configuration element : this.configurations) {
            element.configureWebApp();
        }
        this.servletHandler.setInitializeAtStart(false);
        if (this.securityHandler.getConstraintMappings() == null || LazyList.size(this.securityHandler.getConstraintMappings()) == 0) {
            this.securityHandler.setHandler(null);
            this.sessionHandler.setHandler(this.servletHandler);
        }
        super.startContext();
        if (this.servletHandler != null && this.servletHandler.isStarted()) {
            this.servletHandler.initialize();
        }
    }

    private String getCanonicalNameForWebAppTmpDir() {
        StringBuffer canonicalName = new StringBuffer();
        canonicalName.append("JavaCard_WebApp_");
        String contextPath = this.getContextPath();
        contextPath = contextPath.replace('/', '_');
        contextPath = contextPath.replace('.', '_');
        contextPath = contextPath.replace('\\', '_');
        canonicalName.append(contextPath);
        return canonicalName.toString();
    }

    public class WebAppErrorHandler
    extends ErrorHandler {
        Hashtable<String, String> errorPages;

        public Hashtable<String, String> getErrorPages() {
            return this.errorPages;
        }

        @Override
        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
            Logger.debug("\n\norg.mortbay.jetty.webapp.WebAppErrorHandler.handle() -> " + request.getRequestURI());
            Logger.debug("Error pages: " + this.errorPages);
            if (this.errorPages != null) {
                String old_error_page;
                Integer code;
                String error_page = null;
                Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception");
                Class<?> exClass = null;
                if (th != null) {
                    exClass = th.getClass();
                }
                if (th != null && th instanceof ServletException) {
                    Logger.verbose("instance of th");
                    error_page = this.errorPages.get(exClass.getName());
                    if (error_page == null) {
                        while (th instanceof ServletException) {
                            th = ((ServletException)th).getRootCause();
                        }
                        if (th != null) {
                            exClass = th.getClass();
                        }
                    }
                }
                while (error_page == null && exClass != null) {
                    error_page = this.errorPages.get(exClass.getName());
                    exClass = exClass.getSuperclass();
                }
                if (error_page == null && (code = (Integer)request.getAttribute("javax.servlet.error.status_code")) != null) {
                    error_page = this.errorPages.get(code.toString());
                }
                if (!(error_page == null || (old_error_page = (String)request.getAttribute(WebAppContext.ERROR_PAGE)) != null && old_error_page.equals(error_page))) {
                    request.setAttribute(WebAppContext.ERROR_PAGE, error_page);
                    Dispatcher dispatcher = (Dispatcher)WebAppContext.this.getServletHandler().getServletContext().getRequestDispatcher(error_page);
                    try {
                        if (dispatcher != null) {
                            dispatcher.error(request, response);
                            return;
                        }
                        Logger.debug("No error page " + error_page);
                    }
                    catch (ServletException e) {
                        Logger.debug(this.getClass(), e);
                        return;
                    }
                }
            }
            super.handle(target, request, response, dispatch);
        }

        public void setErrorPages(Hashtable<String, String> errorPages) {
            this.errorPages = errorPages;
        }
    }
}

