/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrTypeClassRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrClassRefConverter
extends InstructionConverter {
    private static final int T_ZERO = 0;
    private static final int T_BOOLEAN = 10;
    private static final int T_BYTE = 11;
    private static final int T_SHORT = 12;
    private static final int T_INT = 13;
    private static final int T_REFERENCE = 14;

    public InstrClassRefConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    public JcInstruction convert() throws Exception {
        int opcode = this.java_instr.getOpcode();
        String class_name = ((JInstrClassRef)this.java_instr).getClassName();
        JcConstantClassRef jc_const_classref = this.getClassRef(class_name);
        switch (opcode) {
            case 187: {
                this.jc_instr = new JcInstrClassRef(143, jc_const_classref);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 193: {
                int aType = this.getAtype(class_name);
                this.checkIntType(aType);
                this.jc_instr = new JcInstrTypeClassRef(149, aType, jc_const_classref);
                this.operand_stack.pop();
                this.operand_stack.push(1, this.instr_container);
                return this.jc_instr;
            }
            case 192: {
                int aType = this.getAtype(class_name);
                this.checkIntType(aType);
                this.jc_instr = new JcInstrTypeClassRef(148, aType, jc_const_classref);
                this.operand_stack.pop();
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private int getAtype(String class_name) {
        if (class_name.equals("[C") || class_name.equals("[L") || class_name.equals("[F") || class_name.equals("[D") || class_name.startsWith("[[")) {
            throw new ConverterInternalError();
        }
        if (class_name.equals("[Z")) {
            return 10;
        }
        if (class_name.equals("[B")) {
            return 11;
        }
        if (class_name.equals("[S")) {
            return 12;
        }
        if (class_name.equals("[I")) {
            return 13;
        }
        if (class_name.startsWith("[L")) {
            return 14;
        }
        return 0;
    }

    private JcConstantClassRef getClassRef(String class_name) throws Exception {
        int aType = this.getAtype(class_name);
        JcConstantPool jc_cp = this.method_converter.getJcConstantPool();
        switch (aType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return null;
            }
            case 0: {
                return jc_cp.addConstantClassRef(class_name);
            }
            case 14: {
                String actual_class_name = class_name.substring(2, class_name.length() - 1);
                return jc_cp.addConstantClassRef(actual_class_name);
            }
        }
        throw new ConversionException();
    }

    private void checkIntType(int aType) throws Exception {
        if (aType == 13) {
            if (this.method_converter.isIntSupported()) {
                Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.6", this.method_converter.getClassName().replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
            } else {
                Notifier.error(this.java_instr.getSourceLineNumber(), "int.6", this.method_converter.getClassName().replace('/', '.'));
                throw new ConversionException();
            }
        }
    }
}

