/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.optimizers;

import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrByteValue;
import com.sun.javacard.jcfile.instructions.JcInstrIncrement;
import com.sun.javacard.jcfile.instructions.JcInstruction;

public class SincInstrOptimizer {
    JcPackage jc_package;
    private int index;
    private int const_value;
    private JcInstruction store_instr;

    public SincInstrOptimizer(JcPackage jc_package) {
        this.jc_package = jc_package;
    }

    public JcPackage optimize() {
        JcClass[] jc_classes = this.jc_package.getClasses();
        for (int i = 0; i < jc_classes.length; ++i) {
            JcClass jc_class = jc_classes[i];
            JcMethod[] jc_methods = jc_class.getMethods();
            for (int j = 0; j < jc_methods.length; ++j) {
                JcMethod jc_method = jc_methods[j];
                this.optimizeByteCode(jc_method);
            }
        }
        return this.jc_package;
    }

    private void optimizeByteCode(JcMethod jc_method) {
        JcInstruction cur_instr = jc_method.getCode();
        if (cur_instr == null) {
            return;
        }
        while (cur_instr != null) {
            this.reset();
            boolean found_patten = false;
            found_patten = this.examinePatten(cur_instr);
            if (found_patten) {
                JcInstrIncrement sinc_instr = new JcInstrIncrement(89, this.index, this.const_value);
                int label = cur_instr.getLabel();
                sinc_instr.setLabel(label);
                int line_num = cur_instr.getSourceLineNumber();
                sinc_instr.setSourceLineNumber(line_num);
                JcInstruction prev_instr = cur_instr.getPrevInstr();
                if (prev_instr == null) {
                    jc_method.setCode(sinc_instr);
                } else {
                    prev_instr.setNextInstr(sinc_instr);
                    sinc_instr.setPrevInstr(prev_instr);
                }
                JcInstruction next_instr = this.store_instr.getNextInstr();
                sinc_instr.setNextInstr(next_instr);
                if (next_instr != null) {
                    next_instr.setPrevInstr(sinc_instr);
                }
                cur_instr = sinc_instr;
            }
            cur_instr = cur_instr.getNextInstr();
        }
    }

    private boolean examinePatten(JcInstruction cur_instr) {
        if (!this.checkLoadInstr(cur_instr)) {
            return false;
        }
        JcInstruction next_instr = cur_instr.getNextInstr();
        if (next_instr.getLabel() != -1) {
            return false;
        }
        if (!this.checkConstantInstr(next_instr)) {
            return false;
        }
        if ((next_instr = next_instr.getNextInstr()).getLabel() != -1) {
            return false;
        }
        if (!this.checkArithmeticInstr(next_instr)) {
            return false;
        }
        if ((next_instr = next_instr.getNextInstr()).getLabel() != -1) {
            return false;
        }
        return this.checkStoreInstr(next_instr);
    }

    private boolean checkLoadInstr(JcInstruction jc_instr) {
        if (jc_instr == null) {
            return false;
        }
        int opcode = jc_instr.getOpcode();
        switch (opcode) {
            case 28: {
                this.index = 0;
                return true;
            }
            case 29: {
                this.index = 1;
                return true;
            }
            case 30: {
                this.index = 2;
                return true;
            }
            case 31: {
                this.index = 3;
                return true;
            }
            case 22: {
                this.index = ((JcInstrByteIndex)jc_instr).getIndex();
                return true;
            }
        }
        return false;
    }

    private boolean checkConstantInstr(JcInstruction jc_instr) {
        if (jc_instr == null) {
            return false;
        }
        int opcode = jc_instr.getOpcode();
        switch (opcode) {
            case 2: {
                this.const_value = -1;
                return true;
            }
            case 3: {
                this.const_value = 0;
                return true;
            }
            case 4: {
                this.const_value = 1;
                return true;
            }
            case 5: {
                this.const_value = 2;
                return true;
            }
            case 6: {
                this.const_value = 3;
                return true;
            }
            case 7: {
                this.const_value = 4;
                return true;
            }
            case 8: {
                this.const_value = 5;
                return true;
            }
            case 16: {
                this.const_value = ((JcInstrByteValue)jc_instr).getValue();
                return true;
            }
        }
        return false;
    }

    private boolean checkArithmeticInstr(JcInstruction jc_instr) {
        if (jc_instr == null) {
            return false;
        }
        int opcode = jc_instr.getOpcode();
        if (opcode == 65) {
            return true;
        }
        if (opcode == 67) {
            if (this.const_value == -128) {
                return false;
            }
            this.const_value = -this.const_value;
            return true;
        }
        return false;
    }

    private boolean checkStoreInstr(JcInstruction jc_instr) {
        if (jc_instr == null) {
            return false;
        }
        int opcode = jc_instr.getOpcode();
        switch (opcode) {
            case 47: {
                if (this.index == 0) {
                    this.store_instr = jc_instr;
                    return true;
                }
                return false;
            }
            case 48: {
                if (this.index == 1) {
                    this.store_instr = jc_instr;
                    return true;
                }
                return false;
            }
            case 49: {
                if (this.index == 2) {
                    this.store_instr = jc_instr;
                    return true;
                }
                return false;
            }
            case 50: {
                if (this.index == 3) {
                    this.store_instr = jc_instr;
                    return true;
                }
                return false;
            }
            case 41: {
                int store_index = ((JcInstrByteIndex)jc_instr).getIndex();
                if (store_index == this.index) {
                    this.store_instr = jc_instr;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void reset() {
        this.index = 0;
        this.const_value = 0;
        this.store_instr = null;
    }
}

