/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.io.DataOutputStream;
import java.io.IOException;

public class VariableInfo {
    private int index;
    private int name_index;
    private String name;
    private int descriptor_index;
    private String descriptor;
    private int start_pc;
    private int end_pc;

    public VariableInfo(JcMethod jc_method, JcLocalVariable local_var, DebugComponent debug_comp) {
        this.build(jc_method, local_var, debug_comp);
    }

    private void build(JcMethod jc_method, JcLocalVariable local_var, DebugComponent debug_comp) {
        this.index = local_var.getJcIndex();
        this.name = local_var.getName();
        this.name_index = debug_comp.addString(this.name);
        this.descriptor = local_var.getDescriptor();
        this.descriptor_index = debug_comp.addString(this.descriptor);
        this.start_pc = this.getPC(jc_method, local_var.getJcStartPCLabel());
        this.end_pc = this.getPC(jc_method, local_var.getJcEndPCLabel());
    }

    public int getSize() {
        return 9;
    }

    public String toString(int tab_level) {
        StringBuffer tab_sb = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        tab_sb.append("\n");
        for (int i = 0; i < tab_level; ++i) {
            tab_sb.append("\t");
        }
        String indent = tab_sb.toString();
        sb.append(indent + "variable_info { ");
        sb.append(indent + "\tname_index " + "\t\t//" + this.name);
        sb.append(indent + "\tdescriptor_index " + this.descriptor_index + "\t\t//" + this.descriptor);
        sb.append(indent + "\tstart_pc " + this.start_pc);
        sb.append(indent + "\tlength " + (this.end_pc - this.start_pc));
        sb.append(indent + "}");
        return sb.toString();
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeByte(this.index);
        dos.writeShort(this.name_index);
        dos.writeShort(this.descriptor_index);
        dos.writeShort(this.start_pc);
        dos.writeShort(this.end_pc - this.start_pc);
    }

    private int getPC(JcMethod jc_method, int label) {
        JcInstruction code;
        int pc = 0;
        if (label == -1) {
            for (code = jc_method.getCode(); code != null; code = code.getNextInstr()) {
                pc += code.getSizeInBytes();
            }
            return pc;
        }
        while (code != null) {
            if (label == code.getLabel()) {
                return code.getPC();
            }
            code = code.getNextInstr();
        }
        return -1;
    }
}

