/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class ReferenceLocationComponent
extends Component {
    protected Vector ref1Vector = new Vector();
    protected Vector ref2Vector = new Vector();
    private static int f_byteOffset;
    private static int f_byte2Offset;

    public ReferenceLocationComponent(JCPackage p) {
        super(p);
        f_byte2Offset = f_byteOffset = 1;
    }

    public void addOneByteOffset(int offset) {
        if (offset < 0 || offset > 255) {
            throw new IllegalArgumentException();
        }
        this.ref1Vector.addElement(new Integer(offset));
    }

    public void addTwoByteOffset(int offset) {
        if (offset < 0 || offset > 255) {
            throw new IllegalArgumentException();
        }
        this.ref2Vector.addElement(new Integer(offset));
    }

    public int dataSize() {
        return 4 + this.ref1Vector.size() + this.ref2Vector.size();
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            Integer i;
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeShort(this.ref1Vector.size());
            Enumeration e = this.ref1Vector.elements();
            while (e.hasMoreElements()) {
                i = (Integer)e.nextElement();
                dos.writeByte(i);
            }
            dos.writeShort(this.ref2Vector.size());
            e = this.ref2Vector.elements();
            while (e.hasMoreElements()) {
                i = (Integer)e.nextElement();
                dos.writeByte(i);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
        return bos.toByteArray();
    }

    public void addException(JCClass c) {
        if (Modifier.isInterface(c.getAttributes())) {
            return;
        }
        Enumeration m = c.methodElements();
        while (m.hasMoreElements()) {
            JCMethod method = (JCMethod)m.nextElement();
            ExceptionTable e = method.getExceptionTable();
            if (e == null) continue;
            Enumeration et = e.elements();
            while (et.hasMoreElements()) {
                ExceptionTableEntry exe = (ExceptionTableEntry)et.nextElement();
                if (exe.getCatchIndex() != 0) {
                    this.addTwoByteOffset(f_byte2Offset + 6);
                    f_byte2Offset = 2;
                } else {
                    f_byte2Offset += 8;
                }
                f_byteOffset += 8;
            }
        }
    }

    public void add(JCClass c) {
        int i;
        int n;
        Operand operand;
        Enumeration o;
        Instruction inst;
        Statement statement;
        Enumeration s;
        JCMethod method;
        if (Modifier.isInterface(c.getAttributes())) {
            return;
        }
        Enumeration m = c.methodElements();
        while (m.hasMoreElements()) {
            method = (JCMethod)m.nextElement();
            f_byteOffset += method.getMethodHeader().length;
            s = method.statementElements();
            while (s.hasMoreElements()) {
                statement = (Statement)s.nextElement();
                inst = statement.getInstruction();
                ++f_byteOffset;
                o = inst.operandElements();
                block8: while (o.hasMoreElements()) {
                    operand = (Operand)o.nextElement();
                    switch (operand.getType()) {
                        case 7: {
                            if (f_byteOffset >= 255) {
                                n = f_byteOffset / 255;
                                f_byteOffset %= 255;
                                for (i = 0; i < n; ++i) {
                                    this.addOneByteOffset(255);
                                }
                            }
                            this.addOneByteOffset(f_byteOffset);
                            f_byteOffset = operand.size();
                            continue block8;
                        }
                    }
                    f_byteOffset += operand.size();
                }
            }
        }
        m = c.methodElements();
        while (m.hasMoreElements()) {
            method = (JCMethod)m.nextElement();
            f_byte2Offset += method.getMethodHeader().length;
            s = method.statementElements();
            while (s.hasMoreElements()) {
                statement = (Statement)s.nextElement();
                inst = statement.getInstruction();
                ++f_byte2Offset;
                o = inst.operandElements();
                block12: while (o.hasMoreElements()) {
                    operand = (Operand)o.nextElement();
                    switch (operand.getType()) {
                        case 8: {
                            if (f_byte2Offset >= 255) {
                                n = f_byte2Offset / 255;
                                f_byte2Offset %= 255;
                                for (i = 0; i < n; ++i) {
                                    this.addTwoByteOffset(255);
                                }
                            }
                            this.addTwoByteOffset(f_byte2Offset);
                            f_byte2Offset = operand.size();
                            continue block12;
                        }
                    }
                    f_byte2Offset += operand.size();
                }
            }
        }
    }

    public String toString() {
        Integer i;
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        int count = 0;
        sb.append("byte index count: " + this.ref1Vector.size() + Msg.eol);
        sb.append("// Offsets to Byte Indices[]: " + Msg.eol);
        Enumeration e = this.ref1Vector.elements();
        while (e.hasMoreElements()) {
            i = (Integer)e.nextElement();
            sb.append(" " + Msg.toHexString((byte)i.intValue()));
            if (++count % 16 != 0) continue;
            sb.append(Msg.eol);
        }
        if (count % 16 != 0) {
            sb.append(Msg.eol);
        }
        count = 0;
        sb.append("byte2 index count: " + this.ref2Vector.size() + Msg.eol);
        sb.append("// Offsets to Byte2 Indices[]: " + Msg.eol);
        e = this.ref2Vector.elements();
        while (e.hasMoreElements()) {
            i = (Integer)e.nextElement();
            sb.append(" " + Msg.toHexString((byte)i.intValue()));
            if (++count % 16 != 0) continue;
            sb.append(Msg.eol);
        }
        if (count % 16 != 0) {
            sb.append(Msg.eol);
        }
        return sb.toString();
    }
}

