/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SuperInterface;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Cref211OutputFormatter
extends OutputFormatter {
    protected StringBuffer preamble = new StringBuffer();
    protected StringBuffer rom;
    protected StringBuffer staticFields;
    protected StringBuffer staticInit;
    protected StringBuffer applets;
    protected StringBuffer packages;
    protected StringBuffer exceptionTable;
    protected StringBuffer exportComponent;
    protected int exportComponentLength;
    protected int nExceptionEntries;
    protected StringBuffer defineList;
    protected PackageDirectory packageDirectory;
    protected Vector suppressionVector;
    private int relocPc;
    private int relocFieldPc;
    private int m_romBase = 0;
    private int m_e2Base = 32768;
    private static final int ARRAY_HEADER_SIZE = 6;

    public Cref211OutputFormatter(BufferedReader configFile) throws IOException {
        super(configFile);
        this.preamble.append("#include \"opcode.h\"" + Msg.eol);
        this.preamble.append("#include \"mask.h\"" + Msg.eol);
        this.rom = new StringBuffer();
        this.staticFields = new StringBuffer();
        this.staticInit = new StringBuffer();
        this.applets = new StringBuffer();
        this.packages = new StringBuffer();
        this.defineList = new StringBuffer();
        this.exceptionTable = new StringBuffer();
        this.exportComponent = new StringBuffer();
        this.packageDirectory = new PackageDirectory();
        this.suppressionVector = new Vector();
        try {
            String strRomBase = this.getMapEntry("ROMBASE");
            if (strRomBase != null) {
                this.m_romBase = Integer.decode(strRomBase);
            }
        }
        catch (NumberFormatException e) {
            Msg.error("cref.0", null);
        }
        try {
            String strE2Base = this.getMapEntry("E2BASE");
            if (strE2Base != null) {
                this.m_e2Base = Integer.decode(strE2Base);
            }
        }
        catch (NumberFormatException e) {
            Msg.error("cref.1", null);
        }
        String noExportComponent = this.getMapEntry("NOEXPORTCOMPONENT");
        if (noExportComponent != null) {
            StringTokenizer parser = new StringTokenizer(noExportComponent, ",");
            while (parser.hasMoreTokens()) {
                this.suppressionVector.addElement(parser.nextToken().trim());
            }
        }
        this.relocPc = this.m_romBase;
        this.relocFieldPc = this.m_e2Base;
    }

    public void format(RomMask r) {
        this.pass1(r);
        if (Globals.errors == 0) {
            this.pass2(r);
        }
    }

    protected void pass1(RomMask r) {
        Enumeration e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = (JCPackage)e.nextElement();
            Enumeration f = p.classElements();
            while (f.hasMoreElements()) {
                JCClass c = (JCClass)f.nextElement();
                c.relocate(this.relocPc);
                this.relocPc += c.size();
                if (Modifier.isInterface(c.getAttributes())) continue;
                Enumeration g = c.fieldElements();
                while (g.hasMoreElements()) {
                    Field field = (Field)g.nextElement();
                    if (!Modifier.isStatic(field.getAttributes())) continue;
                    FieldDescriptor descriptor = field.getDescriptor();
                    if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive()) continue;
                    field.relocate(this.relocFieldPc);
                    this.relocFieldPc += field.size();
                    StaticFieldInitializer init = field.getFieldInitializer();
                    if (init == null || init.isPrimitive()) continue;
                    if (p.appletCount() == 0) {
                        Object[] args = new Object[]{field.getName(), p.getName()};
                        Msg.error("mlink.17", args);
                        continue;
                    }
                    String descStr = descriptor.getDescriptorString();
                    int[] data = init.getArrayData();
                    if (descStr.equals("[B") || descStr.equals("[Z")) {
                        this.relocFieldPc += 6 + data.length;
                        continue;
                    }
                    if (descStr.equals("[S")) {
                        this.relocFieldPc += 6 + data.length * 2;
                        continue;
                    }
                    if (descStr.equals("[I")) {
                        this.relocFieldPc += 6 + data.length * 4;
                        continue;
                    }
                    throw new InternalError();
                }
                g = c.methodElements();
                while (g.hasMoreElements()) {
                    JCMethod m = (JCMethod)g.nextElement();
                    m.relocate(this.relocPc);
                    this.relocPc += m.size();
                    if (!Modifier.isNative(m.getAttributes())) continue;
                    this.relocPc += 2;
                }
            }
        }
    }

    protected void pass2(RomMask r) {
        Enumeration e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = (JCPackage)e.nextElement();
            boolean suppressExportComponent = this.suppressionVector.contains(p.getName());
            ExportComponent export = new ExportComponent(p);
            PackageIdentifier pid = p.getIdentifier();
            this.packageDirectory.addPackage(pid);
            byte[] aid = pid.getAid().toByteArray();
            this.packages.append("{ { " + aid.length + ", { ");
            this.packages.append(Msg.toHexString(aid, ", ") + ", ");
            this.packages.append("} }, " + pid.getMajorVersion() + ", " + pid.getMinorVersion() + ", " + this.exportComponentLength + " }," + Msg.eol);
            Enumeration f = p.appletElements();
            while (f.hasMoreElements()) {
                AppletDeclarator applet = (AppletDeclarator)f.nextElement();
                byte[] appletAid = applet.getAid().toByteArray();
                int addr = applet.resolve().getRelocAddr();
                this.applets.append("{ " + this.packageDirectory.indexOf(pid) + ", { " + appletAid.length + ", { ");
                this.applets.append(Msg.toHexString(appletAid, ", ") + ", ");
                this.applets.append(" } }, " + Msg.toHexString((short)addr) + " }," + Msg.eol);
            }
            f = p.classElements();
            while (f.hasMoreElements()) {
                JCMethod m;
                int flags;
                JCClass c = (JCClass)f.nextElement();
                if (!suppressExportComponent) {
                    export.add(c);
                }
                this.rom.append(Msg.eol + "/* class@" + Msg.toHexString((short)c.getRelocAddr()) + ": " + Modifier.toString(c.getAttributes()) + " " + c.getName() + " */" + Msg.eol);
                String mapTo = this.getMapEntry(c.getName());
                if (mapTo != null) {
                    this.defineList.append("#define " + mapTo + " " + c.getRelocAddr() + "\t/* " + c.getName() + " */" + Msg.eol);
                }
                int n = flags = c.isShareable() ? 64 : 0;
                if (Modifier.isInterface(c.getAttributes())) {
                    int superCount = c.superInterfaceVector.size();
                    this.rom.append(Msg.toHexString((byte)((flags |= 0x80) | superCount & 0xF)) + ", ");
                    Enumeration g = c.superInterfaceVector.elements();
                    while (g.hasMoreElements()) {
                        SuperInterface si = (SuperInterface)g.nextElement();
                        int addr = si.resolve().getRelocAddr();
                        this.rom.append("HIGH(" + Msg.toHexString((short)addr) + "), ");
                        this.rom.append("LOW(" + Msg.toHexString((short)addr) + "), ");
                        this.rom.append(Msg.eol);
                    }
                    continue;
                }
                this.rom.append(Msg.toHexString((byte)(flags | c.interfaceVector.size() & 0xF)) + ", ");
                JCClass superClass = c.getSuperClass();
                if (superClass == null) {
                    this.rom.append(Msg.toHexString((byte)-1) + ", ");
                    this.rom.append(Msg.toHexString((byte)-1) + ", ");
                } else {
                    this.rom.append("HIGH(" + Msg.toHexString((short)superClass.getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)superClass.getRelocAddr()) + "), ");
                }
                int instanceSize = 0;
                for (JCClass currentClass = c; currentClass != null; currentClass = currentClass.getSuperClass()) {
                    instanceSize += currentClass.getInstanceSize();
                }
                this.rom.append(Msg.toHexString((byte)instanceSize) + ", ");
                this.rom.append(Msg.toHexString((byte)c.getFirstReferenceToken()) + ", ");
                this.rom.append(Msg.toHexString((byte)c.getReferenceCount()) + ", ");
                this.rom.append(Msg.toHexString((byte)c.publicMethodTable.getBase()) + ", ");
                this.rom.append(Msg.toHexString((byte)c.publicMethodTable.getCount()) + ", ");
                this.rom.append(Msg.toHexString((byte)c.packageMethodTable.getBase()) + ", ");
                this.rom.append(Msg.toHexString((byte)c.packageMethodTable.getCount()) + ", ");
                this.rom.append(Msg.eol);
                Enumeration g = c.publicMethodTable.elements();
                while (g.hasMoreElements()) {
                    m = (JCMethod)g.nextElement();
                    this.rom.append("HIGH(" + Msg.toHexString((short)m.getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)m.getRelocAddr()) + "),\t\t/* " + m.getName() + " */" + Msg.eol);
                }
                g = c.packageMethodTable.elements();
                while (g.hasMoreElements()) {
                    m = (JCMethod)g.nextElement();
                    this.rom.append("HIGH(" + Msg.toHexString((short)m.getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)m.getRelocAddr()) + "),\t\t/* " + m.getName() + " */" + Msg.eol);
                }
                g = c.interfaceVector.elements();
                while (g.hasMoreElements()) {
                    InterfaceTable itbl = (InterfaceTable)g.nextElement();
                    byte[] table = itbl.toByteArray();
                    int addr = itbl.resolve().getRelocAddr();
                    this.rom.append("HIGH(" + Msg.toHexString((short)addr) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)addr) + "), ");
                    for (int i = 2; i < table.length; ++i) {
                        this.rom.append(table[i] + ", ");
                    }
                    this.rom.append(Msg.eol);
                }
                Enumeration g2 = c.fieldElements();
                while (g2.hasMoreElements()) {
                    Field field = (Field)g2.nextElement();
                    int mod = field.getAttributes();
                    if (Modifier.isStatic(mod) && !Modifier.isFinal(mod) && (mapTo = this.getMapEntry(field.getName())) != null) {
                        this.defineList.append("#define " + mapTo + " " + field.getRelocAddr() + "\t/* " + field.getName() + " */" + Msg.eol);
                    }
                    if (!Modifier.isStatic(mod)) continue;
                    FieldDescriptor descriptor = field.getDescriptor();
                    if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive()) continue;
                    StaticFieldInitializer init = field.getFieldInitializer();
                    if (init != null && init.isPrimitive()) {
                        int data = init.getPrimitiveData();
                        switch (field.size()) {
                            case 1: {
                                this.staticInit.append(Msg.toHexString((byte)data) + ",");
                                break;
                            }
                            case 2: {
                                this.staticInit.append(Msg.toHexString((byte)(data >> 8)) + ", ");
                                this.staticInit.append(Msg.toHexString((byte)data) + ",");
                                break;
                            }
                            case 4: {
                                this.staticInit.append(Msg.toHexString((byte)(data >> 24)) + ", ");
                                this.staticInit.append(Msg.toHexString((byte)(data >> 16)) + ", ");
                                this.staticInit.append(Msg.toHexString((byte)(data >> 8)) + ", ");
                                this.staticInit.append(Msg.toHexString((byte)data) + ",");
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                        this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toHexString((short)field.getRelocAddr()) + " */" + Msg.eol);
                        continue;
                    }
                    if (init != null && !init.isPrimitive()) {
                        int i;
                        byte[] obj;
                        int addr = field.getRelocAddr() + 2;
                        this.staticInit.append(Msg.toHexString((byte)(addr >> 8)) + ", ");
                        this.staticInit.append(Msg.toHexString((byte)addr) + ",");
                        this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toHexString((short)field.getRelocAddr()) + " */" + Msg.eol);
                        String descStr = descriptor.getDescriptorString();
                        int[] data = init.getArrayData();
                        if (descStr.equals("[B")) {
                            obj = new byte[data.length + 6];
                            obj[0] = -128;
                            addr = ((JCClass)r.classSymbolTable.get("[B")).getRelocAddr();
                            for (i = 0; i < data.length; ++i) {
                                obj[6 + i] = (byte)data[i];
                            }
                        } else if (descStr.equals("[Z")) {
                            obj = new byte[data.length + 6];
                            obj[0] = 96;
                            addr = ((JCClass)r.classSymbolTable.get("[Z")).getRelocAddr();
                            for (i = 0; i < data.length; ++i) {
                                obj[6 + i] = (byte)data[i];
                            }
                        } else if (descStr.equals("[S")) {
                            obj = new byte[data.length * 2 + 6];
                            obj[0] = -96;
                            addr = ((JCClass)r.classSymbolTable.get("[S")).getRelocAddr();
                            for (i = 0; i < data.length; ++i) {
                                obj[6 + i * 2] = (byte)(data[i] >> 8);
                                obj[6 + i * 2 + 1] = (byte)data[i];
                            }
                        } else if (descStr.equals("[I")) {
                            obj = new byte[data.length * 4 + 6];
                            obj[0] = -64;
                            addr = ((JCClass)r.classSymbolTable.get("[I")).getRelocAddr();
                            for (i = 0; i < data.length; ++i) {
                                obj[6 + i * 4] = (byte)(data[i] >> 24);
                                obj[6 + i * 4 + 1] = (byte)(data[i] >> 16);
                                obj[6 + i * 4 + 2] = (byte)(data[i] >> 8);
                                obj[6 + i * 4 + 3] = (byte)data[i];
                            }
                        } else {
                            throw new InternalError();
                        }
                        obj[1] = (byte)(this.packageDirectory.indexOf(pid) << 4);
                        obj[2] = (byte)(addr >> 8);
                        obj[3] = (byte)addr;
                        obj[4] = (byte)(data.length >> 8);
                        obj[5] = (byte)data.length;
                        this.staticInit.append(Msg.toHexString(obj, ", ") + "," + Msg.eol);
                        continue;
                    }
                    switch (field.size()) {
                        case 1: {
                            this.staticInit.append("0,");
                            break;
                        }
                        case 2: {
                            this.staticInit.append("0, 0,");
                            break;
                        }
                        case 4: {
                            this.staticInit.append("0, 0, 0, 0,");
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toHexString((short)field.getRelocAddr()) + " */" + Msg.eol);
                }
                g2 = c.methodElements();
                while (g2.hasMoreElements()) {
                    JCMethod m2 = (JCMethod)g2.nextElement();
                    mapTo = this.getMapEntry(m2.getName());
                    if (mapTo != null) {
                        this.defineList.append("#define " + mapTo + " " + m2.getRelocAddr() + "\t/* " + m2.getName() + " */" + Msg.eol);
                    }
                    this.rom.append(Msg.eol + "/* method@" + Msg.toHexString((short)m2.getRelocAddr()) + ": " + Modifier.toString(m2.getAttributes()) + " " + m2.getName() + " */" + Msg.eol);
                    this.rom.append(Msg.toHexString(m2.getMethodHeader(), ", ") + ", " + Msg.eol);
                    if (Modifier.isAbstract(m2.getAttributes())) continue;
                    if (Modifier.isNative(m2.getAttributes())) {
                        int tag = m2.getRelocAddr();
                        this.rom.append(Msg.toHexString((byte)(tag >> 8)) + ", " + Msg.toHexString((byte)tag) + ", " + Msg.eol);
                        continue;
                    }
                    Enumeration h = m2.statementElements();
                    while (h.hasMoreElements()) {
                        Statement s = (Statement)h.nextElement();
                        this.format(s);
                        this.rom.append(", " + Msg.eol);
                    }
                    ExceptionTable exTbl = m2.getExceptionTable();
                    if (exTbl == null) continue;
                    Enumeration h2 = exTbl.elements();
                    while (h2.hasMoreElements()) {
                        ExceptionTableEntry entry = (ExceptionTableEntry)h2.nextElement();
                        this.exceptionTable.append("{ ");
                        this.exceptionTable.append(Msg.toHexString((short)entry.getStartOffset()) + ", ");
                        int active_length = entry.getActiveLength();
                        if (entry.isOuterMost()) {
                            active_length |= 0x8000;
                        }
                        this.exceptionTable.append(Msg.toHexString((short)active_length) + ", ");
                        this.exceptionTable.append(Msg.toHexString((short)entry.getHandlerOffset()) + ", ");
                        this.exceptionTable.append(Msg.toHexString((short)entry.getCatchIndex()) + ", ");
                        this.exceptionTable.append(" }," + Msg.eol);
                        ++this.nExceptionEntries;
                    }
                }
            }
            byte[] exportComponentByteArray = export.toByteArray();
            this.exportComponent.append("/* " + p.getName() + " */" + Msg.eol);
            for (int i = 0; i < exportComponentByteArray.length; ++i) {
                this.exportComponent.append(Msg.toHexString(exportComponentByteArray[i]) + ", ");
                if (i % 8 != 7) continue;
                this.exportComponent.append(Msg.eol);
            }
            this.exportComponent.append(Msg.eol);
            this.exportComponentLength += exportComponentByteArray.length;
        }
    }

    protected void format(Statement s) {
        if (s.getInstruction() == null) {
            return;
        }
        this.format(s.getInstruction());
    }

    protected void format(Instruction i) {
        this.rom.append("_" + i.getMnemonic().toUpperCase());
        Enumeration e = i.operandElements();
        while (e.hasMoreElements()) {
            Operand o = (Operand)e.nextElement();
            this.format(o);
        }
    }

    protected void format(Operand o) {
        if (o.getType() == 8) {
            Info info = o.resolve();
            switch (info.getType()) {
                case 1: 
                case 4: 
                case 6: {
                    int addr = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + Msg.toHexString((short)addr) + "), LOW(" + Msg.toHexString((short)addr) + ")");
                    break;
                }
                case 5: {
                    int addr = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + Msg.toHexString((short)addr) + "), LOW(" + Msg.toHexString((short)addr) + ")");
                    break;
                }
                case 3: {
                    JCMethod m = (JCMethod)info.resolve();
                    MethodIdentifier mid = m.getMethodIdentifier();
                    int token = mid.getMethodToken();
                    int params = m.getParams();
                    this.rom.append(", " + Msg.toHexString((byte)params) + ", " + Msg.toHexString((byte)token));
                    break;
                }
                case 2: {
                    Field f = (Field)info.resolve();
                    JCClass c = f.getParentClass();
                    int fToken = f.getFieldIdentifier().getFieldToken();
                    int offset = fToken + c.getInstanceBase();
                    this.rom.append(", " + Msg.toHexString((byte)offset >> 8) + ", " + Msg.toHexString((byte)offset));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (o.getType() == 7) {
            Info info = o.resolve();
            switch (info.getType()) {
                case 2: {
                    Field f = (Field)info.resolve();
                    JCClass c = f.getParentClass();
                    int fToken = f.getFieldIdentifier().getFieldToken();
                    int offset = fToken + c.getInstanceBase();
                    this.rom.append(", " + Msg.toHexString((byte)offset));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (o.size() == 1) {
            this.rom.append(", " + o.getValue());
        } else if (o.size() == 2) {
            this.rom.append(", " + (o.getValue() >> 8 & 0xFF) + ", " + (o.getValue() & 0xFF));
        } else if (o.size() == 4) {
            this.rom.append(", " + (o.getValue() >> 24 & 0xFF) + ", " + (o.getValue() >> 16 & 0xFF));
            this.rom.append(", " + (o.getValue() >> 8 & 0xFF) + ", " + (o.getValue() & 0xFF));
        }
    }

    public void write(OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        pw.println("#ifdef __MASK_HEADER__" + Msg.eol);
        pw.println(this.defineList.toString());
        pw.println("#else" + Msg.eol);
        pw.println(this.preamble.toString());
        pw.println("const unsigned char rommask[] = {");
        pw.println(this.rom.toString() + "};");
        pw.println("const unsigned short romsize = sizeof rommask;" + Msg.eol);
        if (this.nExceptionEntries == 0) {
            pw.println("const struct exception exceptiontable[] = { NULL };");
        } else {
            pw.println("const struct exception exceptiontable[] = {");
            pw.println(this.exceptionTable.toString() + "};");
        }
        pw.println("const unsigned short exceptiontablesize = sizeof exceptiontable / sizeof (struct exception);" + Msg.eol);
        pw.println("const unsigned short staticfieldsize = " + (this.relocFieldPc - this.m_e2Base) + ";" + Msg.eol);
        pw.println("const unsigned char staticinit[] = {");
        if (this.staticInit.length() == 0) {
            pw.println(" NULL ");
        } else {
            pw.print(this.staticInit.toString());
        }
        pw.println("};");
        pw.println("const struct applet applets[] = {");
        if (this.applets.length() == 0) {
            pw.println(" NULL ");
        } else {
            pw.print(this.applets.toString());
        }
        pw.println("};" + Msg.eol + "const unsigned short napplets = (sizeof applets / sizeof (struct applet));" + Msg.eol);
        pw.println("#ifdef POST_ISSUANCE_INSTALL");
        pw.println("const struct package packages[] = {");
        pw.print(this.packages.toString());
        pw.println("};" + Msg.eol + "const unsigned short npackages = (sizeof packages / sizeof (struct package));" + Msg.eol);
        pw.println("const unsigned char exportComponent[] = {");
        pw.print(this.exportComponent.toString());
        pw.println("};");
        pw.println("const unsigned short exportComponentSize = sizeof exportComponent;" + Msg.eol);
        pw.println("#endif /* __POST_ISSUANCE_INSTALL__ */");
        pw.println("#endif /* __MASK_HEADER__ */" + Msg.eol);
        pw.flush();
    }
}

