/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask.jrefmask;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SymbolTable;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.RomMask;
import com.sun.javacard.jcasm.mask.jrefmask.AppletTable;
import com.sun.javacard.jcasm.mask.jrefmask.CardMemory;
import com.sun.javacard.jcasm.mask.jrefmask.ExceptionInfo;
import com.sun.javacard.jcasm.mask.jrefmask.MethodFormatter;
import com.sun.javacard.jcasm.mask.jrefmask.ObjectTable;
import com.sun.javacard.jcasm.mask.jrefmask.TransactionBuffer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

class PersistentState {
    CardMemory cardMemoryInfo;
    ObjectTable objectInfo;
    TransactionBuffer transactionBufferInfo;
    AppletTable maskAppletInfo;
    ExceptionInfo maskExceptionInfo;
    com.sun.javacard.jcasm.mask.jrefmask.SymbolTable maskSymbols;
    static short nativeToken;
    Vector suppressionVector;
    Vector exportVector;
    protected PackageDirectory packageDirectory;
    private static final int ARRAY_HEADER_SIZE = 6;
    private Properties mappingTable;

    public PersistentState(Properties properties) {
        int m_romSize = 0;
        this.objectInfo = new ObjectTable();
        this.transactionBufferInfo = new TransactionBuffer();
        this.maskAppletInfo = new AppletTable();
        this.maskExceptionInfo = new ExceptionInfo();
        this.packageDirectory = new PackageDirectory();
        this.suppressionVector = new Vector();
        this.exportVector = new Vector();
        this.mappingTable = properties;
        try {
            String romSize = (String)this.mappingTable.get("ROMSIZE");
            if (romSize != null) {
                m_romSize = Integer.decode(romSize);
            }
        }
        catch (NumberFormatException e) {
            Msg.warn("jref.3", null);
            ++Globals.errors;
        }
        this.cardMemoryInfo = new CardMemory(m_romSize);
        String noExportComponent = (String)this.mappingTable.get("NOEXPORTCOMPONENT");
        if (noExportComponent != null) {
            StringTokenizer parser = new StringTokenizer(noExportComponent, ",");
            while (parser.hasMoreTokens()) {
                this.suppressionVector.addElement(parser.nextToken().trim());
            }
        }
    }

    void formatPS(RomMask r) {
        this.initializeSymbolTable(r);
        this.pass1(r);
        if (Globals.errors == 0) {
            this.pass2(r);
        }
    }

    void initializeSymbolTable(RomMask r) {
        this.maskSymbols = new com.sun.javacard.jcasm.mask.jrefmask.SymbolTable(r.getSymbolCount());
    }

    void pass1(RomMask r) {
        int relocPc = 0;
        int relocFieldPc = this.cardMemoryInfo.getE2Base();
        nativeToken = 0;
        Enumeration e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = (JCPackage)e.nextElement();
            Enumeration f = p.classElements();
            while (f.hasMoreElements()) {
                JCClass c = (JCClass)f.nextElement();
                c.relocate(relocPc);
                this.maskSymbols.addField("CLASS:" + c.getName(), this.toHexString((short)c.getRelocAddr()));
                String mapTo = (String)this.mappingTable.get(c.getName());
                if (mapTo != null) {
                    this.maskSymbols.addField("CLASS:" + mapTo, this.toHexString((short)c.getRelocAddr()));
                }
                relocPc += c.size();
                if (Modifier.isInterface(c.getAttributes())) continue;
                Enumeration g = c.fieldElements();
                while (g.hasMoreElements()) {
                    StaticFieldInitializer init;
                    Field field = (Field)g.nextElement();
                    if (!Modifier.isStatic(field.getAttributes())) continue;
                    FieldDescriptor descriptor = field.getDescriptor();
                    if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive()) continue;
                    field.relocate(relocFieldPc);
                    relocFieldPc += field.size();
                    this.maskSymbols.addField("FIELD:" + field.getName(), this.toHexString((short)field.getRelocAddr()));
                    mapTo = (String)this.mappingTable.get(field.getName());
                    if (mapTo != null) {
                        this.maskSymbols.addField("FIELD:" + mapTo, this.toHexString((short)field.getRelocAddr()));
                    }
                    if ((init = field.getFieldInitializer()) == null || init.isPrimitive()) continue;
                    if (p.appletCount() == 0) {
                        Object[] args = new Object[]{field.getName(), p.getName()};
                        Msg.error("mlink.17", args);
                        continue;
                    }
                    String descStr = descriptor.getDescriptorString();
                    int[] data = init.getArrayData();
                    if (descStr.equals("[B") || descStr.equals("[Z")) {
                        relocFieldPc += 6 + data.length;
                        continue;
                    }
                    if (descStr.equals("[S")) {
                        relocFieldPc += 6 + data.length * 2;
                        continue;
                    }
                    if (descStr.equals("[I")) {
                        relocFieldPc += 6 + data.length * 4;
                        continue;
                    }
                    throw new InternalError();
                }
                g = c.methodElements();
                while (g.hasMoreElements()) {
                    JCMethod m = (JCMethod)g.nextElement();
                    m.relocate(relocPc);
                    relocPc += m.size();
                    if (Modifier.isNative(m.getAttributes())) {
                        relocPc += 2;
                        MethodIdentifier mid = m.getMethodIdentifier();
                        m.setNativeToken(nativeToken);
                        String strToken = this.toHexString(nativeToken);
                        this.maskSymbols.addField(strToken, "METHOD:" + m.getName());
                        mapTo = (String)this.mappingTable.get(m.getName());
                        if (mapTo != null) {
                            this.maskSymbols.addField(m.getName(), mapTo);
                        }
                        nativeToken = (short)(nativeToken + 1);
                    }
                    this.maskSymbols.addField("METHOD:" + m.getName(), this.toHexString((short)m.getRelocAddr()));
                    mapTo = (String)this.mappingTable.get(m.getName());
                    if (mapTo == null) continue;
                    this.maskSymbols.addField("METHOD:" + mapTo, this.toHexString((short)m.getRelocAddr()));
                }
            }
        }
    }

    String toHexString(short value) {
        int nvalue = value & 0xFFFF;
        if (nvalue > 4095) {
            return Integer.toHexString(nvalue);
        }
        if (nvalue > 255) {
            return "0" + Integer.toHexString(nvalue);
        }
        if (nvalue > 15) {
            return "00" + Integer.toHexString(nvalue);
        }
        return "000" + Integer.toHexString(nvalue);
    }

    void pass2(RomMask r) {
        int i = 0;
        Enumeration e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = (JCPackage)e.nextElement();
            PackageIdentifier pid = p.getIdentifier();
            this.packageDirectory.addPackage(pid);
            boolean suppressExportComponent = this.suppressionVector.contains(p.getName());
            ExportComponent export = new ExportComponent(p);
            Enumeration f = p.classElements();
            while (f.hasMoreElements()) {
                JCClass c = (JCClass)f.nextElement();
                byte[] classRecord = c.toByteArray();
                if (!Modifier.isInterface(c.getAttributes())) {
                    byte instanceSize = 0;
                    for (JCClass currentClass = c; currentClass != null; currentClass = currentClass.getSuperClass()) {
                        instanceSize = (byte)(instanceSize + (byte)currentClass.getInstanceSize());
                    }
                    classRecord[3] = instanceSize;
                }
                this.cardMemoryInfo.addToRom(classRecord);
                this.outputE2(pid, c, r);
                Enumeration g = c.methodElements();
                while (g.hasMoreElements()) {
                    JCMethod m = (JCMethod)g.nextElement();
                    MethodFormatter mf = new MethodFormatter(m);
                    byte[] methodRecord = mf.toByteArray();
                    this.cardMemoryInfo.addToRom(methodRecord);
                    if (m.getExceptionTable() == null) continue;
                    this.maskExceptionInfo.addmethodExceptionInfo(m.getExceptionTable().toByteArray());
                }
                if (suppressExportComponent) continue;
                export.add(c);
            }
            this.exportVector.add(export);
            if (p.appletCount() > 0) {
                p.resolveAppletInstallAddrs(r.getMethodSymbolTable());
                this.maskAppletInfo.addAppletData(p.getAppletTableByteArray((byte)i));
            }
            ++i;
        }
        this.maskExceptionInfo.addExcTableToROM(this.cardMemoryInfo);
        this.formatExportOutput();
    }

    void outputE2(PackageIdentifier pid, JCClass c, RomMask r) {
        Enumeration g = c.fieldElements();
        while (g.hasMoreElements()) {
            byte[] array;
            Field field = (Field)g.nextElement();
            int mod = field.getAttributes();
            if (!Modifier.isStatic(mod)) continue;
            FieldDescriptor descriptor = field.getDescriptor();
            if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive()) continue;
            StaticFieldInitializer init = field.getFieldInitializer();
            if (init != null && init.isPrimitive()) {
                byte[] array2;
                int data = init.getPrimitiveData();
                switch (field.size()) {
                    case 1: {
                        array2 = new byte[]{(byte)data};
                        break;
                    }
                    case 2: {
                        array2 = new byte[]{(byte)(data >> 8), (byte)data};
                        break;
                    }
                    case 4: {
                        array2 = new byte[]{(byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)data};
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                this.cardMemoryInfo.addToE2(array2);
                continue;
            }
            if (init != null && !init.isPrimitive()) {
                int i;
                byte[] obj;
                int addr = field.getRelocAddr() + 2;
                byte[] fieldHeaderAddr = new byte[]{(byte)(addr >> 8), (byte)addr};
                this.cardMemoryInfo.addToE2(fieldHeaderAddr);
                SymbolTable cst = r.getClassSymbolTable();
                String descStr = descriptor.getDescriptorString();
                int[] data = init.getArrayData();
                if (descStr.equals("[B")) {
                    obj = new byte[data.length + 6];
                    obj[0] = -128;
                    addr = ((JCClass)cst.get("[B")).getRelocAddr();
                    for (i = 0; i < data.length; ++i) {
                        obj[6 + i] = (byte)data[i];
                    }
                } else if (descStr.equals("[Z")) {
                    obj = new byte[data.length + 6];
                    obj[0] = 96;
                    addr = ((JCClass)cst.get("[Z")).getRelocAddr();
                    for (i = 0; i < data.length; ++i) {
                        obj[6 + i] = (byte)data[i];
                    }
                } else if (descStr.equals("[S")) {
                    obj = new byte[data.length * 2 + 6];
                    obj[0] = -96;
                    addr = ((JCClass)cst.get("[S")).getRelocAddr();
                    for (i = 0; i < data.length; ++i) {
                        obj[6 + i * 2] = (byte)(data[i] >> 8);
                        obj[6 + i * 2 + 1] = (byte)data[i];
                    }
                } else if (descStr.equals("[I")) {
                    obj = new byte[data.length * 4 + 6];
                    obj[0] = -64;
                    addr = ((JCClass)cst.get("[I")).getRelocAddr();
                    for (i = 0; i < data.length; ++i) {
                        obj[6 + i * 4] = (byte)(data[i] >> 24);
                        obj[6 + i * 4 + 1] = (byte)(data[i] >> 16);
                        obj[6 + i * 4 + 2] = (byte)(data[i] >> 8);
                        obj[6 + i * 4 + 3] = (byte)data[i];
                    }
                } else {
                    throw new InternalError();
                }
                obj[1] = (byte)(this.packageDirectory.indexOf(pid) << 4);
                obj[2] = (byte)(addr >> 8);
                obj[3] = (byte)addr;
                obj[4] = (byte)(data.length >> 8);
                obj[5] = (byte)data.length;
                this.cardMemoryInfo.addToE2(obj);
                this.objectInfo.addObjectAddresses((short)((short)field.getRelocAddr() + 2));
                continue;
            }
            switch (field.size()) {
                case 1: {
                    array = new byte[]{0};
                    break;
                }
                case 2: {
                    array = new byte[]{0, 0};
                    break;
                }
                case 4: {
                    array = new byte[]{0, 0, 0, 0};
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            this.cardMemoryInfo.addToE2(array);
        }
    }

    void formatExportOutput() {
        for (int i = 0; i < this.exportVector.size(); ++i) {
            ExportComponent export = (ExportComponent)this.exportVector.elementAt(i);
            JCPackage p = export.getParentPackage();
            short addr = this.cardMemoryInfo.getNextRomAddr();
            p.getIdentifier().setECA(addr);
            this.cardMemoryInfo.addToRom(export.toByteArray());
        }
    }

    void write(DataOutputStream os) throws IOException {
        this.cardMemoryInfo.write(os);
        this.objectInfo.write(os);
        this.transactionBufferInfo.write(os);
        os.write(this.packageDirectory.toByteArray());
        this.maskAppletInfo.write(os);
        this.maskExceptionInfo.write(os);
        this.maskSymbols.write(os);
    }
}

