/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.Kind;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import com.sun.javacard.debugproxy.types.PacketElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClassEvent
implements PacketElement {
    public byte suspendPolicy;
    private Kind kind;
    private ClassDebugInfo cl;
    private int id;

    public ClassEvent(byte suspendPolicy, Kind kind, int id, ClassDebugInfo cl) {
        this.suspendPolicy = suspendPolicy;
        this.kind = kind;
        this.id = id;
        this.cl = cl;
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.kind.code());
        out.writeInt(this.id);
        if (this.kind == Kind.ClassUnloaded) {
            EncodingUtils.writeString(out, this.cl.getClassSignature());
        } else {
            out.writeInt(-31);
            VMClassPool.writeClass(out, this.cl);
        }
    }

    public String toString() {
        return "ClassEvent{kind=" + (Object)((Object)this.kind) + ", class-name=" + this.cl.getClassName() + ", request-id=0x" + Integer.toHexString(this.id) + ", suspendPolicy=" + this.suspendPolicy + '}';
    }
}

