/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.BreakPointsHandler;
import com.oracle.javacard.jcdebugproxy.events.BreakPointsPool;
import com.oracle.javacard.jcdebugproxy.events.ClassUpdateRequestHandler;
import com.oracle.javacard.jcdebugproxy.events.EncodingUtils;
import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.EventHandler;
import com.oracle.javacard.jcdebugproxy.events.EventHandlerImpl;
import com.oracle.javacard.jcdebugproxy.events.ExceptionHandler;
import com.oracle.javacard.jcdebugproxy.events.Kind;
import com.oracle.javacard.jcdebugproxy.events.MethodEnterHandler;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.oracle.javacard.jcdebugproxy.events.PackageEventListener;
import com.oracle.javacard.jcdebugproxy.events.StateEventHandler;
import com.oracle.javacard.jcdebugproxy.events.StepHandler;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.VMStateChangeListener;
import com.sun.javacard.debugproxy.classic.VmState;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import com.sun.javacard.debugproxy.comm.ByteArrayDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EventManager
extends ClassicPacketHandlerImpl
implements PackageEventListener {
    static final byte COUNT_MODIFIER = 1;
    static final byte LOCATION_MODIFIER = 7;
    static final byte EXCEPTION_MODIFIER = 8;
    static final byte STEP_MODIFIER = 10;
    public static final byte VM_DISCONNECTED = 100;
    static final byte KIND_REQUEST = 0;
    static final byte KIND_BREAKPOINT = 1;
    static final byte KIND_STEP = 2;
    static final byte KIND_METHOD_ENTER = 3;
    static final byte KIND_METHOD_EXIT = 4;
    static final byte KIND_EXCEPTION = 5;
    static final byte KIND_CLASS_EVENT = 6;
    private final BreakPointsPool locations = new BreakPointsPool();
    private ClassicProxyProtocol proxy;
    private Set<VMStateChangeListener> runningListeners = Collections.synchronizedSet(new HashSet());
    private Set<VMStateChangeListener> suspendinglisteners = Collections.synchronizedSet(new HashSet());
    private EventHandlers handlers = new EventHandlers();
    private BreakPointsHandler breakpoints = new BreakPointsHandler(this.locations);
    private ClassUpdateRequestHandler classRequests;
    private StepHandler stepping = new StepHandler();
    private MethodEnterHandler methodEnter = new MethodEnterHandler(this.locations);
    private ClassicPacketHandler clearHandler = new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.CLEAR_EVENTS){

        @Override
        public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
            int id;
            EventHandler handler = (EventHandler)state.args.get("event-handler");
            if (handler == null) {
                Kind kind = Kind.find(state.in.readByte());
                id = state.in.readInt();
                handler = (EventHandler)EventManager.this.handlers.byIdeCode.get((Object)kind);
                state.args.put("event-handler", handler);
                state.args.put("event-request-id", id);
            } else {
                id = (Integer)state.args.get("event-request-id");
            }
            return handler.handleClearEventRequest(id, state, toVm);
        }

        @Override
        public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
            EventHandler handler = (EventHandler)state.args.get("event-handler");
            handler.handleClearConfirmation(state, in, length);
        }
    };

    public void clearAll() {
        try {
            if (this.proxy.state().getState() != VmState.State.RUNNING) {
                this.proxy.requestVMStateChange(VmState.State.RUNNING);
            }
            this.locations.clearAll();
            for (EventHandler handler : this.handlers.byVmCode) {
                if (handler == null) continue;
                try {
                    handler.clear();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            byte[] data = new byte[]{(byte)VMPacketHandler.CommandCode.CLEAR_EVENTS.getTag(), 1, 0};
            this.proxy.sendToVmSync(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void syncQueue() throws Exception {
        this.classRequests.handleEventsQueue();
    }

    public EventManager(ClassicProxyProtocol proxy) {
        super(VMPacketHandler.CommandCode.EVENTS);
        this.proxy = proxy;
        this.classRequests = new ClassUpdateRequestHandler(proxy.getIDEClassPath());
        this.handlers.set(Kind.BreakPoint, 1, this.breakpoints);
        this.handlers.set(Kind.SingleStep, 2, this.stepping);
        this.handlers.set(Kind.ClassLoaded, this.classRequests);
        this.handlers.set(Kind.ClassPrepared, this.classRequests);
        this.handlers.set(Kind.ClassUnloaded, 6, this.classRequests);
        this.handlers.set(Kind.Exception, 5, new ExceptionHandler());
        this.handlers.set(Kind.MethodExit, 4, new StateEventHandler(4));
        this.handlers.set(Kind.MethodEntry, this.methodEnter);
        proxy.state().classes().addPackageEventListener(this);
    }

    @Override
    public void init(ClassicProxyProtocol proxy) {
        super.init(proxy);
        this.handlers.init(proxy, this.locations);
    }

    public int requestVMStateChange(VmState.State state, VMStateChangeListener handler, DataOutputStream out) throws Exception {
        short id = (short)this.proxy.state().getNextRequestCounter();
        if (this.proxy.state().getState() == VmState.State.SUSPENDED && state == VmState.State.RUNNING && this.stepping.currentStepFilter.state == EventFilter.State.EnablingInProcess) {
            ByteArrayDataOutputStream stepOut = new ByteArrayDataOutputStream();
            stepOut.write(VMPacketHandler.CommandCode.EVENTS.getCode());
            stepOut.write(0);
            EncodingUtils.getInstance().encodeStepRequest(stepOut, this.proxy.state(), this.stepping.currentStepFilter);
            byte[] data = stepOut.toByteArray();
            data[1] = (byte)(data.length - 2);
            this.proxy.sendToVmSync(data);
        }
        if (handler != null) {
            (state == VmState.State.RUNNING ? this.runningListeners : this.suspendinglisteners).add(handler);
        }
        out.writeByte(state.getCode());
        out.writeShort(id);
        return 0xFFFF & id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNewState(VmState.State newState, int requestId, int changeId) {
        boolean retVal;
        Set<VMStateChangeListener> set;
        if (newState == VmState.State.UNCHANGED) {
            return false;
        }
        Log.LOG(3, "*setNewState:" + (Object)((Object)this.proxy.state().getState()) + " -> " + (Object)((Object)newState));
        Set<VMStateChangeListener> set2 = set = newState == VmState.State.RUNNING ? this.runningListeners : this.suspendinglisteners;
        if (newState == VmState.State.SUSPENDED) {
            this.proxy.state().suspend();
        }
        if (newState == VmState.State.RUNNING) {
            this.proxy.state().resume();
        }
        this.proxy.state().setState(newState);
        Set<VMStateChangeListener> set3 = set;
        synchronized (set3) {
            retVal = !set.isEmpty();
            for (VMStateChangeListener handler : set) {
                handler.stateChanged((short)requestId, this.proxy.state().getState(), newState, null);
            }
            set.clear();
        }
        return retVal;
    }

    public ClassicPacketHandler getClearHandler() {
        return this.clearHandler;
    }

    public ClassicPacketHandler getClearAllBreakpointsHandler() {
        return this.breakpoints.clearAllBreakpointsHandler;
    }

    public void parsePacketFromCard(VMPacketHandler.CommandCode command, DataInputStream packet) throws Exception {
        int length = 0xFF & packet.readByte();
        switch (command) {
            case STATE_CHANGED: {
                OnCardEvent event = this.parseEventFromCard(packet, length);
                this.setNewState(event.state, event.requestId, event.changeId);
                if (!this.proxy.isConnectedToIde() && event.state == VmState.State.SUSPENDED) {
                    this.proxy.requestVMStateChange(VmState.State.RUNNING);
                }
                try {
                    this.handlers.get(event.onCardKind).handleEventFromCard(event);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case GET_STACK: {
                if (packet.readShort() == -1) {
                    throw new IOException("Read failed");
                }
                int[] stack = new int[packet.readShort() & 0xFFFF];
                for (int i = 0; i < stack.length; ++i) {
                    stack[i] = 0xFFFFFF & (packet.readByte() << 16 | packet.readShort() & 0xFFFF);
                }
                this.proxy.state().setStack(stack);
                break;
            }
            default: {
                Log.LOG(3, "ERROR: UNKNOWN:" + (Object)((Object)command));
            }
        }
    }

    public OnCardEvent parseEventFromCard(DataInputStream packet, int length) throws IOException {
        VMClassPool pool = this.proxy.state().pool;
        OnCardEvent event = new OnCardEvent();
        event.state = VmState.State.findByCode(packet.readByte());
        event.changeId = packet.readShort();
        event.location = pool.getLocation(packet.readByte(), packet.readShort());
        event.onCardKind = packet.readByte();
        switch (event.onCardKind) {
            case 1: {
                break;
            }
            case 0: 
            case 2: {
                event.requestId = packet.readShort();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                event.exceptionInstance = packet.readInt();
                if (packet.readByte() == -1) {
                    throw new IOException("Read failed");
                }
                short packageID = packet.readByte();
                short location = packet.readShort();
                event.exceptionType = this.proxy.state().classes().getClassByVMData(packageID, location);
                packageID = packet.readByte();
                location = packet.readShort();
                if (location == 0) break;
                event.catchLocation = this.proxy.state().classes().getLocation((byte)packageID, location);
                break;
            }
            case 6: {
                event.package_action = packet.readByte();
                event.package_index = packet.readByte();
                event.package_aid = new byte[packet.readByte()];
                if (packet.read(event.package_aid) == -1) {
                    throw new IOException("Read failed");
                }
                event.package_owner_aid = new byte[packet.readByte()];
                if (packet.read(event.package_owner_aid) != -1) break;
                throw new IOException("Read failed");
            }
            default: {
                return null;
            }
        }
        return event;
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
        EventHandler handler = (EventHandler)state.args.get("event-handler");
        EventFilter filter = (EventFilter)state.args.get("event-filter");
        if (handler == null) {
            Kind event = Kind.find(state.in.readByte());
            byte suspendPolicy = state.in.readByte();
            filter = this.parseSetRequest(state.in);
            filter.setKind(event);
            filter.setSuspendPolicy(suspendPolicy);
            filter.state = EventFilter.State.EnablingInProcess;
            handler = this.handlers.get(event);
            state.args.put("event-filter", filter);
            state.args.put("event-handler", handler);
            Log.LOG(4, "BP:SET-EVENT:" + filter);
        }
        return handler.handleSetEventRequest(filter, state, toVm);
    }

    @Override
    public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
        EventFilter filter = (EventFilter)state.args.get("event-filter");
        EventHandler handler = (EventHandler)state.args.get("event-handler");
        handler.handleSetConfirmation(state, in, length);
        filter.state = EventFilter.State.Enabled;
        state.out.writeInt(filter.getID());
    }

    @Override
    public void classesAreLoaded(List<ClassDebugInfo> list) throws Exception {
        this.methodEnter.classesAreLoaded(list);
        this.locations.resetEventCountModifier();
    }

    @Override
    public void classesAreUnloaded(List<ClassDebugInfo> list) {
        this.breakpoints.clearUnloadedBreakpoints(list);
    }

    private EventFilter parseSetRequest(DataInputStream in) throws IOException {
        EventFilter filter = new EventFilter();
        filter.setID(this.proxy.state().createProxyNameSpaceRequestID());
        int modifiers = in.readInt();
        if (modifiers == -1) {
            throw new IOException("Read failed");
        }
        block13: for (int i = 0; i < modifiers; ++i) {
            byte mod = in.readByte();
            switch (mod) {
                case 1: {
                    EventFilter.EventModifier current = new EventFilter.CountModifier();
                    current.read((byte)1, in);
                    filter.addModifier(current);
                    continue block13;
                }
                case 2: {
                    in.readInt();
                    continue block13;
                }
                case 3: {
                    filter.addThreadFilter(in.readInt());
                    continue block13;
                }
                case 4: {
                    ClassDebugInfo cl = this.proxy.state().classes().getClassByID(in.readInt());
                    if (cl == null) continue block13;
                    filter.addClassMatch(cl.getClassName());
                    continue block13;
                }
                case 5: {
                    filter.addClassMatch(com.sun.javacard.debugproxy.comm.EncodingUtils.readString(in));
                    continue block13;
                }
                case 6: {
                    filter.addClassExclude(com.sun.javacard.debugproxy.comm.EncodingUtils.readString(in));
                    continue block13;
                }
                case 7: {
                    EventFilter.EventModifier current = new EventFilter.LocationModifier();
                    current.read(mod, in);
                    filter.addModifier(current);
                    continue block13;
                }
                case 8: {
                    filter.addException(this.proxy.state().pool, in);
                    continue block13;
                }
                case 9: {
                    if (in.readLong() != -1L) continue block13;
                    throw new IOException("Read failed");
                }
                case 10: {
                    EventFilter.EventModifier current = new EventFilter.StepModifier();
                    current.read((byte)10, in);
                    filter.addModifier(current);
                    continue block13;
                }
                case 11: {
                    filter.addInstanceFilter(in.readInt());
                    continue block13;
                }
                default: {
                    Log.LOG(3, "Unknown modifier:" + mod);
                    return filter;
                }
            }
        }
        return filter;
    }

    private static class EventHandlers {
        public static final EventHandler NONE = new EventHandlerImpl();
        private EnumMap<Kind, EventHandler> byIdeCode = new EnumMap(Kind.class);
        private EventHandler[] byVmCode = new EventHandler[7];

        private EventHandlers() {
        }

        public synchronized void set(Kind kind, EventHandler handler) {
            this.byIdeCode.put(kind, handler);
        }

        public synchronized EventHandler get(Kind kind) {
            EventHandler retVal = this.byIdeCode.get((Object)kind);
            return retVal == null ? NONE : retVal;
        }

        public synchronized EventHandler get(int code) {
            EventHandler retVal = this.byVmCode[code];
            return retVal == null ? NONE : retVal;
        }

        public synchronized void set(Kind kind, int vmCode, EventHandler handler) {
            this.byIdeCode.put(kind, handler);
            this.byVmCode[vmCode] = handler;
        }

        public synchronized void init(ClassicProxyProtocol proxy, BreakPointsPool locations) {
            for (EventHandler handler : this.byIdeCode.values()) {
                handler.init(proxy);
            }
        }
    }
}

