/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.DebugProxyMain;
import com.oracle.javacard.jcdebugproxy.events.EncodingUtils;
import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.EventHandlerImpl;
import com.oracle.javacard.jcdebugproxy.events.JDWPEvent;
import com.oracle.javacard.jcdebugproxy.events.Kind;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import java.io.DataOutputStream;
import java.util.Collections;
import java.util.logging.Logger;

public class StepHandler
extends EventHandlerImpl {
    volatile EventFilter currentStepFilter = new EventFilter();
    private volatile int stepCounter = 0;

    @Override
    public ClassicPacketHandler.DeliveryType handleClearEventRequest(int id, HandlerState state, DataOutputStream toVM) throws Exception {
        if (this.currentStepFilter.getID() == id) {
            EncodingUtils.getInstance().encodeClearStepRequest(toVM, id);
            this.currentStepFilter.state = EventFilter.State.DisablingInProcess;
            state.args.put("event-filters", Collections.singleton(this.currentStepFilter));
            return ClassicPacketHandler.DeliveryType.IMMEDIATELY;
        }
        return ClassicPacketHandler.DeliveryType.NONE;
    }

    @Override
    public void handleEventFromCard(OnCardEvent event) {
        this.currentStepFilter.state = EventFilter.State.EnablingInProcess;
        JDWPEvent bp = new JDWPEvent(event, Kind.SingleStep, 0x2000000 | event.requestId);
        if (DebugProxyMain.isInIdeDebugger()) {
            this.proxy.sendEventsToIDE((byte)1, Collections.singleton(bp));
        } else {
            this.proxy.sendEventsToIDE((byte)2, Collections.singleton(bp));
        }
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleSetEventRequest(EventFilter filter, HandlerState state, DataOutputStream toVm) throws Exception {
        filter.setID(0x2000000 | ++this.stepCounter);
        if (this.currentStepFilter.state != EventFilter.State.Disabled) {
            Logger.getAnonymousLogger().severe("ERROR:DOUBLE STEP_SETTING");
        }
        this.currentStepFilter = filter;
        EncodingUtils.getInstance().encodeStepRequest(toVm, this.proxy.state(), filter);
        return ClassicPacketHandler.DeliveryType.NORMAL;
    }

    @Override
    public synchronized void clear() throws Exception {
        super.clear();
        this.currentStepFilter = new EventFilter();
    }
}

