/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic.handlers;

import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FixedDataHandler
extends ClassicPacketHandlerImpl {
    private byte[] data;

    public FixedDataHandler(Object ... args) {
        super(VMPacketHandler.CommandCode.NONE);
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        DataOutputStream ps = new DataOutputStream(buff);
        try {
            for (Object val : args) {
                if (val instanceof String) {
                    EncodingUtils.writeString(ps, (String)val);
                    continue;
                }
                if (val instanceof Integer) {
                    ps.writeInt((Integer)val);
                    continue;
                }
                if (val instanceof Short) {
                    ps.writeShort(((Short)val).shortValue());
                    continue;
                }
                if (val instanceof Character) {
                    ps.writeChar(((Character)val).charValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    ps.writeBoolean((Boolean)val);
                    continue;
                }
                if (val instanceof Byte) {
                    ps.writeByte(((Byte)val).byteValue());
                    continue;
                }
                if (!(val instanceof Long)) continue;
                ps.writeLong((Long)val);
            }
            ps.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.data = buff.toByteArray();
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
        return ClassicPacketHandler.DeliveryType.NONE;
    }

    @Override
    public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
        state.out.write(this.data);
    }

    public void setError(boolean b) {
    }
}

