/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfAttribute;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfConstantValueAttribute;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Vector;

abstract class BaseClassInterfaceConverter {
    JClassFile java_class;
    JcClass jc_class;
    PackageConverter p_converter;

    BaseClassInterfaceConverter(JClassFile java_class, PackageConverter p_converter) {
        this.java_class = java_class;
        this.p_converter = p_converter;
        this.jc_class = new JcClass(java_class);
        if (p_converter.getJcPackage().getEfExportFile() != null) {
            this.jc_class.setEfClass(p_converter.getJcPackage().getEfExportFile().getClass(java_class.getClassName()));
        }
    }

    public JcClass getJcClass() {
        return this.jc_class;
    }

    public JClassFile getJavaClass() {
        return this.java_class;
    }

    public PackageConverter getPackageConverter() {
        return this.p_converter;
    }

    protected String[] determinePublicSuperInterfaces() throws Exception {
        String[] all_interfaces = this.jc_class.getSuperInterfaces();
        Vector<String> public_interfaces = new Vector<String>(15);
        String this_package_name = Names.getPackageName(this.java_class.getClassName());
        int i = 0;
        while (i < all_interfaces.length) {
            String an_interface = all_interfaces[i];
            if (Names.getPackageName(an_interface).equals(this_package_name)) {
                JcClass jc_interface = this.p_converter.getJcClass(an_interface);
                if (jc_interface == null) {
                    throw new ConversionException();
                }
                int access_flags = jc_interface.getAccessFlags();
                if (Modifier.isPublic(access_flags)) {
                    public_interfaces.addElement(an_interface);
                }
            } else {
                EfClass ef_interface = this.getExportClass(an_interface);
                if (ef_interface == null) {
                    throw new ConversionException();
                }
                public_interfaces.addElement(an_interface);
            }
            ++i;
        }
        Object[] public_interface_names = new String[public_interfaces.size()];
        public_interfaces.copyInto(public_interface_names);
        return public_interface_names;
    }

    protected boolean determineShareableType() {
        String[] public_interfaces = this.jc_class.getPublicSuperInterfaces();
        int i = 0;
        while (i < public_interfaces.length) {
            if (public_interfaces[i].equals("javacard/framework/Shareable")) {
                return true;
            }
            ++i;
        }
        return this.java_class.getClassName().equals("javacard/framework/Shareable");
    }

    protected void addInterfaces(Vector vector, String[] interface_names) {
        int i = 0;
        while (i < interface_names.length) {
            this.addInterface(vector, interface_names[i]);
            ++i;
        }
    }

    protected void addInterface(Vector vector, String interface_name) {
        int i = 0;
        while (i < vector.size()) {
            String an_interface = (String)vector.elementAt(i);
            if (an_interface.equals(interface_name)) {
                return;
            }
            ++i;
        }
        vector.addElement(interface_name);
    }

    protected void intTypeCheck() throws Exception {
        JField[] java_fields = this.java_class.getFields();
        int i = 0;
        while (i < java_fields.length) {
            String descriptor = java_fields[i].getFieldDescriptor();
            if (descriptor.equals("I") || descriptor.equals("[I")) {
                Object[] args;
                if (this.p_converter.isIntSupported()) {
                    args = new Object[]{this.java_class.getClassName().replace('/', '.'), java_fields[i].getFieldName()};
                    Notifier.progress("warning.1", args);
                    this.p_converter.setIntFlag(true);
                } else {
                    args = new Object[]{this.java_class.getClassName().replace('/', '.'), java_fields[i].getFieldName()};
                    Notifier.error("int.1", args);
                    throw new ConversionException();
                }
            }
            ++i;
        }
        JMethod[] java_methods = this.java_class.getMethods();
        int i2 = 0;
        while (i2 < java_methods.length) {
            JMethod java_method = java_methods[i2];
            String descriptor = java_method.getMethodDescriptor();
            String[] param_descs = MethodDescriptor.getParamDescriptors(descriptor);
            int j = 0;
            while (j < param_descs.length) {
                if (param_descs[j].equals("I") || param_descs[j].equals("[I")) {
                    Object[] args;
                    if (this.p_converter.isIntSupported()) {
                        args = new Object[]{this.java_class.getClassName().replace('/', '.'), java_method.getMethodName()};
                        Notifier.progress("warning.2", args);
                        this.p_converter.setIntFlag(true);
                    } else {
                        args = new Object[]{this.java_class.getClassName().replace('/', '.'), java_method.getMethodName()};
                        Notifier.error("int.2", args);
                        throw new ConversionException();
                    }
                }
                ++j;
            }
            String return_desc = MethodDescriptor.getReturnDescriptor(descriptor);
            if (return_desc.equals("I") || return_desc.equals("[I")) {
                Object[] args;
                if (this.p_converter.isIntSupported()) {
                    args = new Object[]{this.java_class.getClassName().replace('/', '.'), java_method.getMethodName()};
                    Notifier.progress("warning.3", args);
                    this.p_converter.setIntFlag(true);
                } else {
                    args = new Object[]{this.java_class.getClassName().replace('/', '.'), java_method.getMethodName()};
                    Notifier.error("int.3", args);
                    throw new ConversionException();
                }
            }
            ++i2;
        }
    }

    protected EfClass getExportClass(String class_name) throws Exception {
        ExportFileManager ex_manager = this.p_converter.getExportFileManager();
        EfClass ef_class = ex_manager.getClass(class_name);
        return ef_class;
    }

    protected EfClass getExportClassIfAvailable(String class_name) {
        ExportFileManager ex_manager = this.p_converter.getExportFileManager();
        EfClass ef_class = ex_manager.getClassIfAvailable(class_name);
        return ef_class;
    }

    protected JcClass getJcClass(String class_name) {
        JcClass jc_class = this.p_converter.getJcClass(class_name);
        return jc_class;
    }

    protected void detectRemovedAPIFields() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfField[] efField = this.getJcClass().getEfClass().getFields();
        int i = 0;
        while (i < efField.length) {
            EfField eff = efField[i];
            JcField jcf = this.getJcClass().getField(eff.getFieldName(), eff.getFieldDescriptor());
            if (jcf == null || !jcf.isAPIElement(this.getJcClass(), this.getPackageConverter().getJcPackage())) {
                Object[] args = new Object[]{eff.getFieldName()};
                Notifier.error("binary.3", args);
                throw new ConversionException();
            }
            ++i;
        }
    }

    protected void checkFieldFlags() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        int i = 0;
        while (i < this.getJcClass().getFields().length) {
            JcField jcF = this.getJcClass().getFields()[i];
            if (jcF.getEfField() != null) {
                EfField efF = jcF.getEfField();
                if (efF.isStatic() && !jcF.isStatic()) {
                    Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.4", args);
                    throw new ConversionException();
                }
                if (!efF.isStatic() && jcF.isStatic()) {
                    Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.5", args);
                    throw new ConversionException();
                }
                if (efF.isPublic() && jcF.isProtected()) {
                    Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.6", args);
                    throw new ConversionException();
                }
                if (!efF.isFinal() && jcF.isFinal()) {
                    Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.7", args);
                    throw new ConversionException();
                }
                if (efF.isFinal() && !jcF.isFinal() && jcF.isStatic()) {
                    Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.8", args);
                    throw new ConversionException();
                }
            }
            ++i;
        }
    }

    protected void checkMethodFlags() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        int i = 0;
        while (i < this.getJcClass().getMethods().length) {
            JcMethod jcM = this.getJcClass().getMethods()[i];
            if (jcM.getEfMethod() != null) {
                Object[] args;
                EfMethod efM = jcM.getEfMethod();
                if (efM.isStatic() && !jcM.isStatic()) {
                    args = new Object[]{jcM.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.9", args);
                    throw new ConversionException();
                }
                if (!efM.isStatic() && jcM.isStatic()) {
                    args = new Object[]{jcM.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.10", args);
                    throw new ConversionException();
                }
                if (efM.isPublic() && jcM.isProtected()) {
                    args = new Object[]{jcM.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.11", args);
                    throw new ConversionException();
                }
                EfClass efClass = this.getJcClass().getEfClass();
                if (!efM.isFinal() && jcM.isFinal() && !efClass.isFinal()) {
                    Object[] args2 = new Object[]{jcM.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.12", args2);
                    throw new ConversionException();
                }
                if (!efM.isAbstract() && jcM.isAbstract()) {
                    Object[] args3 = new Object[]{jcM.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.13", args3);
                    throw new ConversionException();
                }
            }
            ++i;
        }
    }

    protected void detectAddedAPIFields() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        boolean hadReferenceAPIField = this.getJcClass().getEfClass().hasReferenceAPIField();
        int i = 0;
        while (i < this.getJcClass().getFields().length) {
            JcField jcF = this.getJcClass().getFields()[i];
            if (jcF.isAPIElement(this.getJcClass(), this.getPackageConverter().getJcPackage())) {
                if (jcF.getEfField() == null) {
                    if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
                        Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                        Notifier.error("binary.14", args);
                        throw new ConversionException();
                    }
                    if (hadReferenceAPIField && !jcF.isReferenceType()) {
                        Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                        Notifier.error("binary.15", args);
                        throw new ConversionException();
                    }
                } else if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
                    if (jcF.getEfField().isProtected() && jcF.isPublic()) {
                        Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                        Notifier.error("binary.16", args);
                        throw new ConversionException();
                    }
                    if (jcF.getEfField().isFinal() && !jcF.isFinal()) {
                        Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                        Notifier.error("binary.17", args);
                        throw new ConversionException();
                    }
                }
            }
            ++i;
        }
    }

    protected void assignKnownFieldTokens() {
        JcField[] jc_fields = this.getJcClass().getFields();
        int i = 0;
        while (i < jc_fields.length) {
            if (jc_fields[i].getEfField() != null) {
                jc_fields[i].setFieldToken(jc_fields[i].getEfField().getFieldToken());
            } else {
                jc_fields[i].setFieldToken(255);
            }
            ++i;
        }
    }

    protected void presortFieldsByTokens() {
        JcField[] jc_fields = this.getJcClass().getFields();
        boolean again = true;
        while (again) {
            again = false;
            int i = 0;
            while (i < jc_fields.length - 1) {
                if ((jc_fields[i].isStatic() || !jc_fields[i + 1].isStatic()) && (jc_fields[i].getFieldToken() > jc_fields[i + 1].getFieldToken() && jc_fields[i].getFieldToken() != 255 && jc_fields[i + 1].getFieldToken() != 255 || jc_fields[i].getFieldToken() == 255 && jc_fields[i + 1].getFieldToken() != 255)) {
                    JcField jcf = jc_fields[i];
                    jc_fields[i] = jc_fields[i + 1];
                    jc_fields[i + 1] = jcf;
                    again = true;
                }
                ++i;
            }
        }
    }

    protected void checkFieldValues() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        JcField[] jcf = this.getJcClass().getFields();
        int i = 0;
        while (i < jcf.length) {
            if (jcf[i].isPublic() && jcf[i].isStatic() && jcf[i].isFinal() && jcf[i].getEfField() != null) {
                JcField jcF = jcf[i];
                EfAttribute efa = jcf[i].getEfField().getAttribute();
                int[] ar2 = jcf[i].getValue();
                if (ar2.length == 0 || !(efa instanceof EfConstantValueAttribute)) {
                    Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.18", args);
                    throw new ConversionException();
                }
                if (efa == null) {
                    Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.19", args);
                    throw new ConversionException();
                }
                if (ar2[0] != ((EfConstantValueAttribute)efa).getValue()) {
                    Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.'), "" + ((EfConstantValueAttribute)efa).getValue(), "" + ar2[0]};
                    Notifier.error("binary.20", args);
                    throw new ConversionException();
                }
            }
            ++i;
        }
    }

    protected void detectRemovedPublicSuperinterfaces() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfClass efClass = this.getJcClass().getEfClass();
        JcClass jcClass = this.getJcClass();
        Vector<String> ev = new Vector<String>(Arrays.asList(efClass.getInterfaceNames()));
        Vector<String> jv = new Vector<String>(Arrays.asList(jcClass.getPublicSuperInterfaces()));
        if (jv.containsAll(ev)) {
            return;
        }
        ev.removeAll(jv);
        if (!ev.isEmpty()) {
            Object[] args = new Object[]{ev.toString().replace('/', '.'), jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.21", args);
            throw new ConversionException();
        }
    }

    protected void detectAddedPublicSuperinterfaces() throws Exception {
        Vector<String> jv;
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfClass efClass = this.getJcClass().getEfClass();
        JcClass jcClass = this.getJcClass();
        Vector<String> ev = new Vector<String>(Arrays.asList(efClass.getInterfaceNames()));
        if (ev.containsAll(jv = new Vector<String>(Arrays.asList(jcClass.getPublicSuperInterfaces())))) {
            return;
        }
        jv.removeAll(ev);
        if (!jv.isEmpty()) {
            Object[] args = new Object[]{jv.toString().replace('/', '.'), jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.37", args);
            throw new ConversionException();
        }
    }
}

