/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.efbuilder;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.jcfile.JcAppletInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class ExportFileBuilder {
    private JcPackage jc_package;
    private boolean debugFlag;
    private boolean remoteFlag;

    public void setDebug(boolean flag) {
        this.debugFlag = flag;
    }

    public ExportFileBuilder(JcPackage jc_package, ConversionProfile conversion_profile) {
        this.jc_package = jc_package;
    }

    public EfExportFile build() {
        if (this.debugFlag) {
            System.out.println("Building an export file for " + this.jc_package.getPackageName());
        }
        byte package_flags = 0;
        JcAppletInfo[] applet_infos = this.jc_package.getAppletInfos();
        if (applet_infos.length == 0) {
            package_flags = EfExportFile.LIBRARY_PACKAGE;
        }
        EfConstantPool cp = new EfConstantPool();
        JcClass[] jc_classes = this.jc_package.getClasses();
        Vector<EfClass> ef_class_vector = new Vector<EfClass>(20);
        int i = 0;
        while (i < jc_classes.length) {
            if (jc_classes[i].isAPIElement(this.jc_package)) {
                EfClass ef_class = this.generateExportClass(jc_classes[i], jc_classes[i].isShareableType(), cp);
                ef_class_vector.addElement(ef_class);
            }
            ++i;
        }
        Object[] ef_classes = new EfClass[ef_class_vector.size()];
        ef_class_vector.copyInto(ef_classes);
        int version = this.remoteFlag ? 2 : 1;
        EfExportFile ef_file = new EfExportFile(2, (byte)version, package_flags, this.jc_package, cp, (EfClass[])ef_classes);
        return ef_file;
    }

    private EfClass generateExportClass(JcClass jc_class, boolean shareable_flag, EfConstantPool cp) {
        if (this.debugFlag) {
            System.out.println("\n\n\nGenerating EfClass for " + jc_class.getClassName());
            System.out.println("Class token = " + jc_class.getClassToken());
        }
        String[] super_class_names = jc_class.getPublicSuperClasses();
        String[] interface_names = jc_class.getPublicSuperInterfaces();
        boolean remote = jc_class.isRemote();
        Vector<EfField> field_vector = new Vector<EfField>(20);
        JcField[] all_fields = jc_class.getFields();
        int i = 0;
        while (i < all_fields.length) {
            int access_flags = all_fields[i].getAccessFlags();
            if (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) {
                EfField ef_field = new EfField(all_fields[i], cp);
                field_vector.addElement(ef_field);
            }
            ++i;
        }
        Object[] fields = new EfField[field_vector.size()];
        field_vector.copyInto(fields);
        Vector<EfMethod> method_vector = new Vector<EfMethod>(20);
        JcMethod[] all_methods = jc_class.getMethods();
        if (all_methods == null) {
            // empty if block
        }
        int i2 = 0;
        while (i2 < all_methods.length) {
            int access_flags = all_methods[i2].getAccessFlags();
            if ((Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) && (Modifier.isStatic(access_flags) || all_methods[i2].getMethodName().equals("<init>"))) {
                EfMethod ef_method = new EfMethod(all_methods[i2], cp);
                method_vector.addElement(ef_method);
            }
            ++i2;
        }
        MethodDefinition[] public_methods = jc_class.getPublicMethodTable().getMethods();
        int i3 = 0;
        while (i3 < public_methods.length) {
            EfMethod ef_method = new EfMethod(public_methods[i3], cp);
            method_vector.addElement(ef_method);
            ++i3;
        }
        Object[] methods = new EfMethod[method_vector.size()];
        method_vector.copyInto(methods);
        EfClass ef_class = new EfClass(jc_class, shareable_flag, super_class_names, interface_names, cp, (EfField[])fields, (EfMethod[])methods);
        if (remote) {
            ef_class.setRemote(true);
            this.remoteFlag = true;
        }
        if (this.debugFlag) {
            if (jc_class.getEfClass() != null) {
                jc_class.getEfClass().printFields();
            }
            jc_class.printFields();
            ef_class.printFields();
            if (jc_class.getEfClass() != null) {
                jc_class.getEfClass().printMethods();
            }
            jc_class.printMethods();
            ef_class.printMethods();
        }
        return ef_class;
    }
}

