/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.optimizers;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrBranch;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;

public class WideInstrOptimizer {
    JcPackage jc_package;

    public WideInstrOptimizer(JcPackage jc_package) {
        this.jc_package = jc_package;
    }

    public JcPackage optimize() {
        JcConstantPool jc_cp = this.jc_package.getConstantPool();
        jc_cp.order();
        JcClass[] jc_classes = this.jc_package.getClasses();
        int i = 0;
        while (i < jc_classes.length) {
            JcMethod[] jc_methods = jc_classes[i].getMethods();
            int j = 0;
            while (j < jc_methods.length) {
                JcMethod jc_method = jc_methods[j];
                this.passOne(jc_method);
                this.passTwo(jc_method);
                ++j;
            }
            ++i;
        }
        return this.jc_package;
    }

    private void passOne(JcMethod jc_method) {
        JcInstruction jc_instr = jc_method.getCode();
        while (jc_instr != null) {
            int jc_opcode = jc_instr.getOpcode();
            switch (jc_opcode) {
                case 169: {
                    this.optimizeFieldInstr(jc_instr, 131);
                    break;
                }
                case 170: {
                    this.optimizeFieldInstr(jc_instr, 132);
                    break;
                }
                case 171: {
                    this.optimizeFieldInstr(jc_instr, 133);
                    break;
                }
                case 172: {
                    this.optimizeFieldInstr(jc_instr, 134);
                    break;
                }
                case 177: {
                    this.optimizeFieldInstr(jc_instr, 135);
                    break;
                }
                case 178: {
                    this.optimizeFieldInstr(jc_instr, 136);
                    break;
                }
                case 179: {
                    this.optimizeFieldInstr(jc_instr, 137);
                    break;
                }
                case 180: {
                    this.optimizeFieldInstr(jc_instr, 138);
                    break;
                }
                case 152: {
                    this.setBranchInstr(jc_instr, 96);
                    break;
                }
                case 153: {
                    this.setBranchInstr(jc_instr, 97);
                    break;
                }
                case 154: {
                    this.setBranchInstr(jc_instr, 98);
                    break;
                }
                case 155: {
                    this.setBranchInstr(jc_instr, 99);
                    break;
                }
                case 156: {
                    this.setBranchInstr(jc_instr, 100);
                    break;
                }
                case 157: {
                    this.setBranchInstr(jc_instr, 101);
                    break;
                }
                case 158: {
                    this.setBranchInstr(jc_instr, 102);
                    break;
                }
                case 159: {
                    this.setBranchInstr(jc_instr, 103);
                    break;
                }
                case 160: {
                    this.setBranchInstr(jc_instr, 104);
                    break;
                }
                case 161: {
                    this.setBranchInstr(jc_instr, 105);
                    break;
                }
                case 162: {
                    this.setBranchInstr(jc_instr, 106);
                    break;
                }
                case 163: {
                    this.setBranchInstr(jc_instr, 107);
                    break;
                }
                case 164: {
                    this.setBranchInstr(jc_instr, 108);
                    break;
                }
                case 165: {
                    this.setBranchInstr(jc_instr, 109);
                    break;
                }
                case 166: {
                    this.setBranchInstr(jc_instr, 110);
                    break;
                }
                case 167: {
                    this.setBranchInstr(jc_instr, 111);
                    break;
                }
                case 168: {
                    this.setBranchInstr(jc_instr, 112);
                }
            }
            jc_instr = jc_instr.getNextInstr();
        }
    }

    private void optimizeFieldInstr(JcInstruction jc_instr, int narrow_opcode) {
        JcInstrFieldRef instr_field_ref = (JcInstrFieldRef)jc_instr;
        JcConstantFieldRef const_field_ref = instr_field_ref.getFieldRef();
        if ((const_field_ref.getIndex() & 0xFF00) == 0) {
            instr_field_ref.setWideInstr(false);
            instr_field_ref.setOpcode(narrow_opcode);
        }
    }

    private void setBranchInstr(JcInstruction jc_instr, int narrow_opcode) {
        JcInstrBranch branch_instr = (JcInstrBranch)jc_instr;
        branch_instr.setWideInstr(false);
        branch_instr.setOpcode(narrow_opcode);
    }

    private void passTwo(JcMethod jc_method) {
        JcInstruction code = jc_method.getCode();
        if (code == null) {
            return;
        }
        boolean changed = true;
        while (changed) {
            JcInstruction jc_instr = code;
            changed = false;
            while (jc_instr != null) {
                int jc_opcode = jc_instr.getOpcode();
                switch (jc_opcode) {
                    case 96: {
                        changed = this.optimizeBranchInstr(jc_instr, 152, jc_method);
                        break;
                    }
                    case 97: {
                        changed = this.optimizeBranchInstr(jc_instr, 153, jc_method);
                        break;
                    }
                    case 98: {
                        changed = this.optimizeBranchInstr(jc_instr, 154, jc_method);
                        break;
                    }
                    case 99: {
                        changed = this.optimizeBranchInstr(jc_instr, 155, jc_method);
                        break;
                    }
                    case 100: {
                        changed = this.optimizeBranchInstr(jc_instr, 156, jc_method);
                        break;
                    }
                    case 101: {
                        changed = this.optimizeBranchInstr(jc_instr, 157, jc_method);
                        break;
                    }
                    case 102: {
                        changed = this.optimizeBranchInstr(jc_instr, 158, jc_method);
                        break;
                    }
                    case 103: {
                        changed = this.optimizeBranchInstr(jc_instr, 159, jc_method);
                        break;
                    }
                    case 104: {
                        changed = this.optimizeBranchInstr(jc_instr, 160, jc_method);
                        break;
                    }
                    case 105: {
                        changed = this.optimizeBranchInstr(jc_instr, 161, jc_method);
                        break;
                    }
                    case 106: {
                        changed = this.optimizeBranchInstr(jc_instr, 162, jc_method);
                        break;
                    }
                    case 107: {
                        changed = this.optimizeBranchInstr(jc_instr, 163, jc_method);
                        break;
                    }
                    case 108: {
                        changed = this.optimizeBranchInstr(jc_instr, 164, jc_method);
                        break;
                    }
                    case 109: {
                        changed = this.optimizeBranchInstr(jc_instr, 165, jc_method);
                        break;
                    }
                    case 110: {
                        changed = this.optimizeBranchInstr(jc_instr, 166, jc_method);
                        break;
                    }
                    case 111: {
                        changed = this.optimizeBranchInstr(jc_instr, 167, jc_method);
                        break;
                    }
                    case 112: {
                        changed = this.optimizeBranchInstr(jc_instr, 168, jc_method);
                    }
                }
                jc_instr = jc_instr.getNextInstr();
            }
        }
    }

    private boolean optimizeBranchInstr(JcInstruction jc_instr, int wide_opcode, JcMethod jc_method) {
        JcInstrBranch branch_instr = (JcInstrBranch)jc_instr;
        int label = branch_instr.getBranchLabel();
        int offset = this.computeOffset(jc_instr, label, jc_method);
        if (DataType.getType(offset) != 1) {
            branch_instr.setWideInstr(true);
            branch_instr.setOpcode(wide_opcode);
            return true;
        }
        return false;
    }

    private int computeOffset(JcInstruction jc_instr, int label, JcMethod jc_method) {
        JcInstruction code = jc_method.getCode();
        JcInstruction target_instr = null;
        while (code != null) {
            if (code.getLabel() == label) {
                target_instr = code;
                break;
            }
            code = code.getNextInstr();
        }
        if (target_instr == null) {
            throw new ConverterInternalError();
        }
        int branch_pc = 0;
        int target_pc = 0;
        int current_pc = 0;
        code = jc_method.getCode();
        while (code != null) {
            if (code == jc_instr) {
                branch_pc = current_pc;
            }
            if (code == target_instr) {
                target_pc = current_pc;
            }
            current_pc += code.getSizeInBytes();
            code = code.getNextInstr();
        }
        return target_pc - branch_pc;
    }
}

