/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.exportfile.EfConstant;
import com.sun.javacard.exportfile.EfConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class EfConstantUtf8
extends EfConstant {
    private String utf8String;
    private byte[] utf8Bytes;
    private EfConstantPool constant_pool;

    public EfConstantUtf8(EfConstantPool cp) {
        this.constant_pool = cp;
    }

    public EfConstantUtf8(EfConstantPool cp, String utf8String) {
        this.constant_pool = cp;
        this.utf8String = utf8String;
        try {
            this.utf8Bytes = utf8String.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException wow) {
            throw new ConverterInternalError(wow.getMessage());
        }
    }

    public void parse(DataInputStream dis) throws IOException {
        this.utf8Bytes = new byte[dis.readUnsignedShort()];
        dis.readFully(this.utf8Bytes);
        this.utf8String = new String(this.utf8Bytes, "UTF8");
    }

    public String getUtf8String() {
        return this.utf8String;
    }

    public byte[] getUtf8Bytes() {
        return this.utf8Bytes;
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tab_level) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        pw.println(indent + "Constant_Utf8_info {");
        pw.println(indent + "\ttag\t" + 1);
        pw.println(indent + "\tlength\t" + this.utf8Bytes.length);
        pw.println(indent + "\tbytes\t" + this.utf8String);
        pw.println(indent + "}");
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeByte(1);
        dos.writeShort(this.utf8Bytes.length);
        dos.write(this.utf8Bytes, 0, this.utf8Bytes.length);
    }
}

