/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import java.util.Enumeration;
import java.util.Vector;

public class ConstantPool {
    protected Vector cpVector;
    private JCPackage jPackage;
    private boolean printedError;

    public ConstantPool(JCPackage p) {
        this.jPackage = p;
        this.cpVector = new Vector();
    }

    void addConstantPoolEntry(Info info) {
        Assert.PreCondition(info != null, "info != null");
        this.cpVector.addElement(info);
        if (this.cpVector.size() > 65535 && !this.printedError) {
            Object[] args = new Object[]{this.jPackage.getName()};
            Msg.error("package.2", args);
            this.printedError = true;
        }
    }

    public Info getConstantPoolEntry(int index) {
        Assert.PreCondition(index >= 0, "index >= 0");
        if (index >= this.cpVector.size()) {
            return null;
        }
        return (Info)this.cpVector.elementAt(index);
    }

    public Enumeration elements() {
        return this.cpVector.elements();
    }

    public int getCount() {
        return this.cpVector.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(".constantPool {" + Msg.eol);
        Enumeration e = this.cpVector.elements();
        while (e.hasMoreElements()) {
            Info info = (Info)e.nextElement();
            sb.append(info + ";" + Msg.eol);
        }
        sb.append("}");
        return sb.toString();
    }
}

