/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.Aid;
import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.ClassRefInfo;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldIdentifier;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.InstanceFieldRefInfo;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.MethodTable;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.StaticFieldRefInfo;
import com.sun.javacard.jcasm.StaticMethodRefInfo;
import com.sun.javacard.jcasm.SuperInterface;
import com.sun.javacard.jcasm.SuperMethodRefInfo;
import com.sun.javacard.jcasm.SymbolTable;
import com.sun.javacard.jcasm.VirtualMethodRefInfo;
import com.sun.javacard.jcasm.mask.RomMask;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

class MaskLinker {
    MaskLinker() {
    }

    static void link(RomMask r) {
        Object[] args;
        Enumeration e;
        SymbolTable classSymbolTable = r.classSymbolTable;
        SymbolTable methodSymbolTable = r.methodSymbolTable;
        SymbolTable fieldSymbolTable = r.fieldSymbolTable;
        Enumeration e2 = r.packageElements();
        while (e2.hasMoreElements()) {
            JCPackage p = (JCPackage)e2.nextElement();
            Enumeration f = p.importElements();
            while (f.hasMoreElements()) {
                PackageIdentifier pi = (PackageIdentifier)f.nextElement();
                if (r.containsPackage(pi)) continue;
                Object[] args2 = new Object[]{pi.toString(), p.getName()};
                Msg.error("mlink.0", args2);
            }
        }
        if (Globals.errors != 0) {
            return;
        }
        JCClass obj = (JCClass)classSymbolTable.get("java/lang/Object");
        if (obj == null) {
            Msg.error("mlink.1", null);
            return;
        }
        byte[] aidData = new byte[]{-96, 0, 0, 0, 98, 3, 1, 1, 1};
        PackageIdentifier pid = new PackageIdentifier(new Aid(aidData), 1, 0);
        JCPackage arrayPackage = new JCPackage("VM Array Implementation", pid, 0);
        String[] arrayClasses = new String[]{"[B", "[S", "[Z", "[L;", "[I"};
        int i = 0;
        while (i < arrayClasses.length) {
            ClassIdentifier cid = new ClassIdentifier(pid, i);
            JCClass c = new JCClass(arrayPackage, 16, arrayClasses[i], cid, 0);
            c.setSuperClassIdentifier(obj.getClassIdentifier());
            c.publicMethodTable = new MethodTable(c, obj.publicMethodTable.getBase() + obj.publicMethodTable.getCount(), true);
            e = obj.publicMethodTable.nameElements();
            while (e.hasMoreElements()) {
                c.publicMethodTable.addMethod((String)e.nextElement());
            }
            c.packageMethodTable = new MethodTable(c, obj.packageMethodTable.getBase() + obj.packageMethodTable.getCount(), false);
            Enumeration e3 = obj.packageMethodTable.nameElements();
            while (e3.hasMoreElements()) {
                c.packageMethodTable.addMethod((String)e3.nextElement());
            }
            arrayPackage.addClass(c);
            ++i;
        }
        r.addPackage(arrayPackage);
        Enumeration e4 = r.packageElements();
        while (e4.hasMoreElements()) {
            JCPackage p = (JCPackage)e4.nextElement();
            Enumeration f = p.classElements();
            while (f.hasMoreElements()) {
                JCClass sc;
                JCClass c = (JCClass)f.nextElement();
                String className = c.getName();
                String superName = c.getSuperClassName();
                ClassIdentifier superId = c.getSuperClassIdentifier();
                if (superName != null) {
                    sc = (JCClass)classSymbolTable.get(superName);
                    if (sc == null) {
                        args = new Object[]{className};
                        Msg.error("mlink.2", args);
                        continue;
                    }
                    c.setSuperClass(sc);
                    continue;
                }
                if (superId == null) continue;
                sc = (JCClass)classSymbolTable.get(superId);
                if (sc == null) {
                    args = new Object[]{className};
                    Msg.error("mlink.2", args);
                    continue;
                }
                c.setSuperClass(sc);
            }
        }
        JCClass shareable = (JCClass)classSymbolTable.get("javacard/framework/Shareable");
        if (shareable == null) {
            Msg.warn("mlink.7", null);
        }
        e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = (JCPackage)e.nextElement();
            Enumeration f = p.appletElements();
            while (f.hasMoreElements()) {
                AppletDeclarator applet = (AppletDeclarator)f.nextElement();
                String installMethod = applet.getInstallMethodName();
                JCMethod m = (JCMethod)methodSymbolTable.get(installMethod);
                if (m == null) {
                    args = new Object[]{installMethod, applet.toString()};
                    Msg.error("mlink.13", args);
                    continue;
                }
                if (!Modifier.isStatic(m.getAttributes())) {
                    args = new Object[]{installMethod};
                    Msg.error("mlink.14", args);
                    continue;
                }
                applet.resolve(m);
            }
            Enumeration f2 = p.classElements();
            while (f2.hasMoreElements()) {
                JCClass c = (JCClass)f2.nextElement();
                if (Modifier.isInterface(c.getAttributes())) {
                    Enumeration i2 = c.superInterfaceElements();
                    while (i2.hasMoreElements()) {
                        Object[] args3;
                        JCClass ic;
                        SuperInterface s = (SuperInterface)i2.nextElement();
                        String superInterfaceName = s.getName();
                        ClassIdentifier sId = s.getClassIdentifier();
                        if (superInterfaceName != null) {
                            ic = (JCClass)classSymbolTable.get(superInterfaceName);
                            if (ic == null) {
                                args3 = new Object[]{superInterfaceName, c.getName()};
                                Msg.error("mlink.16", args3);
                                continue;
                            }
                            s.resolve(ic);
                            continue;
                        }
                        if (sId == null) continue;
                        ic = (JCClass)classSymbolTable.get(sId);
                        if (ic == null) {
                            args3 = new Object[]{sId.toString(), c.getName()};
                            Msg.error("mlink.16", args3);
                            continue;
                        }
                        s.resolve(ic);
                    }
                    continue;
                }
                c.publicMethodTable.resolve(methodSymbolTable, false);
                c.packageMethodTable.resolve(methodSymbolTable, false);
                MaskLinker.linkInterfaceInfo(classSymbolTable, c, c.interfaceElements());
                if (!c.isRemote()) continue;
                MaskLinker.linkInterfaceInfo(classSymbolTable, c, c.remoteInterfaceElements());
            }
            Enumeration e1 = p.constantPoolElements();
            while (e1.hasMoreElements()) {
                Info info = (Info)e1.nextElement();
                switch (info.getType()) {
                    case 1: {
                        MaskLinker.linkClassRefInfo((ClassRefInfo)info, classSymbolTable);
                        break;
                    }
                    case 6: {
                        MaskLinker.linkStaticMethodRefInfo((StaticMethodRefInfo)info, methodSymbolTable);
                        break;
                    }
                    case 5: {
                        MaskLinker.linkStaticFieldRefInfo((StaticFieldRefInfo)info, fieldSymbolTable);
                        break;
                    }
                    case 2: {
                        MaskLinker.linkInstanceFieldRefInfo((InstanceFieldRefInfo)info, fieldSymbolTable);
                        break;
                    }
                    case 3: {
                        MaskLinker.linkVirtualMethodRefInfo((VirtualMethodRefInfo)info, methodSymbolTable, classSymbolTable);
                        break;
                    }
                    case 4: {
                        MaskLinker.linkSuperMethodRefInfo((SuperMethodRefInfo)info, methodSymbolTable, classSymbolTable);
                        break;
                    }
                    default: {
                        Assert.Assert(false, "info.getType()");
                    }
                }
            }
        }
    }

    private static void linkInterfaceInfo(SymbolTable classSymbolTable, JCClass c, Enumeration i) {
        while (i.hasMoreElements()) {
            Object[] args;
            JCClass ic;
            InterfaceTable itable = (InterfaceTable)i.nextElement();
            String interfaceName = itable.getName();
            ClassIdentifier iId = itable.getClassIdentifier();
            if (interfaceName != null) {
                ic = (JCClass)classSymbolTable.get(interfaceName);
                if (ic == null) {
                    args = new Object[]{interfaceName, c.getName()};
                    Msg.error("mlink.12", args);
                    continue;
                }
                itable.resolve(ic);
                continue;
            }
            if (iId == null) continue;
            ic = (JCClass)classSymbolTable.get(iId);
            if (ic == null) {
                args = new Object[]{iId.toString(), c.getName()};
                Msg.error("mlink.12", args);
                continue;
            }
            itable.resolve(ic);
        }
    }

    private static void linkClassRefInfo(ClassRefInfo info, SymbolTable classSymbolTable) {
        JCClass c;
        Assert.PreCondition(info != null, "info != null");
        if (info.isPackageInternal()) {
            c = (JCClass)classSymbolTable.get(info.getName());
        } else {
            ClassIdentifier cid = new ClassIdentifier(info.getPackageIdentifier(), info.getClassToken());
            c = (JCClass)classSymbolTable.get(cid);
        }
        if (c == null) {
            Object[] args = new Object[]{info.toString(), new Integer(info.getLineNumber())};
            Msg.error("mlink.21", args);
            return;
        }
        info.resolve(c);
    }

    private static void linkInstanceFieldRefInfo(InstanceFieldRefInfo info, SymbolTable fieldSymbolTable) {
        Object[] args;
        Field f;
        Assert.PreCondition(info != null, "info != null");
        if (info.isPackageInternal()) {
            f = (Field)fieldSymbolTable.get(info.getName());
        } else {
            ClassIdentifier cid = new ClassIdentifier(info.getPackageIdentifier(), info.getClassToken());
            FieldIdentifier fid = new FieldIdentifier(cid, info.getInstanceFieldToken(), false);
            f = (Field)fieldSymbolTable.get(fid);
        }
        if (f == null) {
            args = new Object[]{info.toString(), new Integer(info.getLineNumber())};
            Msg.error("mlink.22", args);
            return;
        }
        if (!(info.isPackageInternal() || Modifier.isPublic(f.getAttributes()) || Modifier.isProtected(f.getAttributes()))) {
            args = new Object[]{info.toString(), f.getName(), new Integer(info.getLineNumber())};
            Msg.error("mlink.42", args);
            return;
        }
        if (Modifier.isStatic(f.getAttributes())) {
            args = new Object[]{f.getName(), info.getName()};
            Msg.error("mlink.32", args);
            return;
        }
        info.resolve(f);
    }

    private static void linkVirtualMethodRefInfo(VirtualMethodRefInfo info, SymbolTable methodSymbolTable, SymbolTable classSymbolTable) {
        Object[] args;
        JCMethod m;
        Assert.PreCondition(info != null, "info != null");
        if (info.isPackageInternal()) {
            m = (JCMethod)methodSymbolTable.get(info.getName());
        } else {
            ClassIdentifier cid = new ClassIdentifier(info.getPackageIdentifier(), info.getClassToken());
            do {
                MethodIdentifier mid;
                if ((m = (JCMethod)methodSymbolTable.get(mid = new MethodIdentifier(cid, info.getVirtualMethodToken(), false))) != null) continue;
                JCClass myc = (JCClass)classSymbolTable.get(cid);
                cid = myc.getSuperClassIdentifier();
            } while (m == null || cid == null);
        }
        if (m == null) {
            args = new Object[]{info.toString(), new Integer(info.getLineNumber())};
            Msg.error("mlink.23", args);
            return;
        }
        if (!(info.isPackageInternal() || Modifier.isPublic(m.getAttributes()) || Modifier.isProtected(m.getAttributes()))) {
            args = new Object[]{info.toString(), m.getName(), new Integer(info.getLineNumber())};
            Msg.error("mlink.43", args);
            return;
        }
        if (Modifier.isStatic(m.getAttributes())) {
            args = new Object[]{m.getName(), info.getName()};
            Msg.error("mlink.33", args);
            return;
        }
        info.resolve(m);
    }

    private static void linkSuperMethodRefInfo(SuperMethodRefInfo info, SymbolTable methodSymbolTable, SymbolTable classSymbolTable) {
        Object[] args;
        ClassIdentifier sid;
        MethodIdentifier mid;
        int methodToken;
        JCClass currentClass;
        JCMethod m;
        block9: {
            Assert.PreCondition(info != null, "info != null");
            m = (JCMethod)methodSymbolTable.get(info.getName());
            currentClass = null;
            methodToken = -1;
            if (m != null) {
                methodToken = m.getMethodIdentifier().getMethodToken();
                currentClass = m.getParentClass();
            } else {
                String infoName = info.getName();
                String methodName = infoName.substring(0, infoName.indexOf(40));
                String className = methodName.substring(0, methodName.lastIndexOf(47));
                currentClass = (JCClass)classSymbolTable.get(className);
                if (currentClass == null) {
                    Object[] args2 = new Object[]{info.toString(), new Integer(info.getLineNumber())};
                    Msg.error("mlink.24", args2);
                    return;
                }
                String methodSignature = infoName.substring(className.length() + 1);
                methodToken = 0;
                Enumeration names = currentClass.publicMethodTable.nameElements();
                while (names.hasMoreElements()) {
                    String tableName = (String)names.nextElement();
                    if (!tableName.equals(methodSignature)) {
                        ++methodToken;
                        continue;
                    }
                    break block9;
                }
                methodToken = 128;
                Enumeration names2 = currentClass.packageMethodTable.nameElements();
                while (names2.hasMoreElements()) {
                    String tableName = (String)names2.nextElement();
                    if (!tableName.equals(methodSignature)) {
                        ++methodToken;
                        continue;
                    }
                    break block9;
                }
                Object[] args3 = new Object[]{info.toString(), new Integer(info.getLineNumber())};
                Msg.error("mlink.24", args3);
                return;
            }
        }
        do {
            if ((currentClass = currentClass.getSuperClass()) != null) continue;
            args = new Object[]{info.toString(), new Integer(info.getLineNumber())};
            Msg.error("mlink.24", args);
            return;
        } while ((m = (JCMethod)methodSymbolTable.get(mid = new MethodIdentifier(sid = currentClass.getClassIdentifier(), methodToken, false))) == null);
        if (Modifier.isStatic(m.getAttributes())) {
            args = new Object[]{m.getName(), info.getName()};
            Msg.error("mlink.34", args);
            return;
        }
        info.resolve(m);
    }

    private static void linkStaticFieldRefInfo(StaticFieldRefInfo info, SymbolTable fieldSymbolTable) {
        Object[] args;
        Field f;
        Assert.PreCondition(info != null, "info != null");
        if (info.isPackageInternal()) {
            f = (Field)fieldSymbolTable.get(info.getName());
        } else {
            ClassIdentifier cid = new ClassIdentifier(info.getPackageIdentifier(), info.getClassToken());
            FieldIdentifier fid = new FieldIdentifier(cid, info.getStaticFieldToken(), true);
            f = (Field)fieldSymbolTable.get(fid);
        }
        if (f == null) {
            args = new Object[]{info.toString(), new Integer(info.getLineNumber())};
            Msg.error("mlink.25", args);
            return;
        }
        if (!(info.isPackageInternal() || Modifier.isPublic(f.getAttributes()) || Modifier.isProtected(f.getAttributes()))) {
            args = new Object[]{info.toString(), f.getName(), new Integer(info.getLineNumber())};
            Msg.error("mlink.45", args);
            return;
        }
        if (!Modifier.isStatic(f.getAttributes())) {
            args = new Object[]{f.getName(), info.getName()};
            Msg.error("mlink.35", args);
            return;
        }
        info.resolve(f);
    }

    private static void linkStaticMethodRefInfo(StaticMethodRefInfo info, SymbolTable methodSymbolTable) {
        Object[] args;
        JCMethod m;
        Assert.PreCondition(info != null, "info != null");
        if (info.isPackageInternal()) {
            m = (JCMethod)methodSymbolTable.get(info.getName());
        } else {
            ClassIdentifier cid = new ClassIdentifier(info.getPackageIdentifier(), info.getClassToken());
            MethodIdentifier mid = new MethodIdentifier(cid, info.getStaticMethodToken(), true);
            m = (JCMethod)methodSymbolTable.get(mid);
        }
        if (m == null) {
            args = new Object[]{info.toString(), new Integer(info.getLineNumber())};
            Msg.error("mlink.26", args);
            return;
        }
        if (!(info.isPackageInternal() || Modifier.isPublic(m.getAttributes()) || Modifier.isProtected(m.getAttributes()))) {
            args = new Object[]{info.toString(), m.getName(), new Integer(info.getLineNumber())};
            Msg.error("mlink.46", args);
            return;
        }
        if (!Modifier.isStatic(m.getAttributes()) && !Modifier.isPrivate(m.getAttributes()) && m.getName().indexOf("/<init>(") == -1) {
            args = new Object[]{m.getName(), info.getName()};
            Msg.error("mlink.36", args);
            return;
        }
        info.resolve(m);
    }
}

