/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.mask.CrefOutputFormatter;
import com.sun.javacard.jcasm.mask.Main;
import com.sun.javacard.jcasm.mask.PackageTableManager;
import com.sun.javacard.jcasm.mask.SubRef;
import com.sun.javacard.jcasm.mask.TargetReference;
import java.util.Enumeration;
import java.util.Hashtable;

public class TableManager {
    public static final short EXTERNAL_REFERENCE_MASK = Short.MIN_VALUE;
    public static final int FIRST_TABLE_MAX = 64;
    public static final int SECOND_TABLE_MAX = 128;
    public static final int FIRST_LEVEL_BIT_SHIFT = 6;
    public static final int SECOND_LEVEL_BIT_SHIFT = 7;
    public static final int GLOBAL_REFERENCE_TABLE = 0;
    public static final int OBJECT_TABLE = 1;
    public static int FIRST_TABLE_ENTRY_SIZE;
    public static int REF_SIZE;
    private boolean isGRTResolved;
    Hashtable references;
    SubRef[] sr;
    int tableIdentifier = 0;
    int tableLocation = 0;

    TableManager(int tableType) {
        if (Main.FLAG_32_BIT) {
            FIRST_TABLE_ENTRY_SIZE = 5;
            REF_SIZE = 3;
        } else {
            FIRST_TABLE_ENTRY_SIZE = 3;
            REF_SIZE = 2;
        }
        this.references = new Hashtable();
        this.sr = new SubRef[64];
        this.tableIdentifier = tableType;
        if (tableType == 0) {
            this.isGRTResolved = false;
        }
    }

    int addExportedReference(Object ref, int refAddr, int pkgId) {
        int mainTableRef = 0;
        int i = 0;
        while (i < 64) {
            if (this.sr[i] == null) {
                this.sr[i] = new SubRef();
            }
            if (this.sr[i].availableSlot != -1) {
                mainTableRef = this.sr[i].addTargetReference(refAddr, pkgId);
                mainTableRef |= i << 7 | Short.MIN_VALUE;
                break;
            }
            ++i;
        }
        this.references.put(ref, new Integer(mainTableRef));
        return mainTableRef;
    }

    public int getExportedReference(Object ref) {
        Integer i = (Integer)this.references.get(ref);
        return i;
    }

    TargetReference getExportedReference(int refId) {
        int firstIndex = (refId & 0x1F80) >> 7;
        int targetIndex = refId & 0x7F;
        return this.sr[firstIndex].tr[targetIndex];
    }

    void resolveExportAddresses() {
        if (this.isGRTResolved) {
            return;
        }
        Enumeration g = this.references.keys();
        while (g.hasMoreElements()) {
            int baseAddress;
            JCPackage p;
            Member ref = (Member)g.nextElement();
            Integer exportedRef = (Integer)this.references.get(ref);
            if (ref instanceof JCClass) {
                p = ((JCClass)ref).getParentPackage();
                baseAddress = PackageTableManager.getCompBaseAddress(p, 0);
            } else if (ref instanceof JCMethod) {
                if (exportedRef == -32716) {
                    System.out.println("");
                }
                p = ((JCMethod)ref).getParentClass().getParentPackage();
                baseAddress = PackageTableManager.getCompBaseAddress(p, 1);
            } else {
                p = ((Field)ref).getParentClass().getParentPackage();
                baseAddress = PackageTableManager.getCompBaseAddress(p, 2);
            }
            TargetReference tr = this.getExportedReference(exportedRef);
            tr.address = baseAddress + tr.address;
        }
        this.isGRTResolved = true;
    }

    int addObject(int objectAddress) {
        int mainTableRef = 0;
        int i = 0;
        while (i < 64) {
            if (this.sr[i] == null) {
                this.sr[i] = new SubRef();
            }
            if (this.sr[i].availableSlot != -1) {
                mainTableRef = this.sr[i].addObjectLevel1(objectAddress);
                mainTableRef |= i << 7;
                break;
            }
            ++i;
        }
        return mainTableRef;
    }

    int addToMask(StringBuffer eepromImage) {
        int i;
        int currentLocationInMemory = CrefOutputFormatter.cof.getCurrentEEPROMAddr();
        int currentLocationInROMMemory = CrefOutputFormatter.cof.currentRomAddr;
        int startingLoc = currentLocationInMemory;
        if (this.tableIdentifier == 0) {
            CrefOutputFormatter.cof.rom_GrtObjectPkgFilledTable.append("/* Global reference table */" + Msg.eol);
            i = 0;
            while (i < 64) {
                if (this.sr[i] != null) {
                    if (this.sr[i].availableSlot == -1) {
                        currentLocationInROMMemory += this.sr[i].addGRTToMask(CrefOutputFormatter.cof.rom_GrtObjectPkgFilledTable, currentLocationInROMMemory, i);
                    } else {
                        currentLocationInMemory += this.sr[i].addGRTToMask(eepromImage, currentLocationInMemory, i);
                    }
                }
                ++i;
            }
            eepromImage.append("/* Global Reference Table: Main Table @" + Msg.toAddressString(currentLocationInMemory) + "*/" + Msg.eol);
        } else {
            eepromImage.append("/* Object Table */" + Msg.eol);
            i = 0;
            while (i < 64) {
                if (this.sr[i] != null) {
                    if (this.sr[i].availableSlot == -1) {
                        currentLocationInROMMemory += this.sr[i].addObjectTableToMask(CrefOutputFormatter.cof.rom_GrtObjectPkgFilledTable, currentLocationInROMMemory, i);
                    } else {
                        currentLocationInMemory += this.sr[i].addObjectTableToMask(eepromImage, currentLocationInMemory, i);
                    }
                }
                ++i;
            }
            eepromImage.append(Msg.eol + "/* Object Table: Main Table @" + Msg.toAddressString(currentLocationInMemory) + "*/" + Msg.eol);
        }
        this.tableLocation = currentLocationInMemory;
        String emptyEntryFiller = "0x00, 0x00, 0x00, ";
        if (Main.FLAG_32_BIT) {
            emptyEntryFiller = "0x00, 0x00, 0x00, 0x00, 0x00, ";
        }
        int i2 = 0;
        while (i2 < 64) {
            if (this.sr[i2] != null) {
                if (Main.FLAG_32_BIT) {
                    eepromImage.append(Msg.to32BitHexString(this.sr[i2].location));
                    eepromImage.append(Msg.toHexString((byte)this.sr[i2].availableSlot) + ", ");
                } else {
                    eepromImage.append(Msg.to16BitHexString(this.sr[i2].location));
                    eepromImage.append(Msg.toHexString((byte)this.sr[i2].availableSlot) + ", ");
                }
            } else {
                eepromImage.append(emptyEntryFiller);
            }
            if (i2 % 8 == 7) {
                eepromImage.append(Msg.eol);
            }
            ++i2;
        }
        CrefOutputFormatter.cof.setCurrentEEPROMAddr(currentLocationInMemory += FIRST_TABLE_ENTRY_SIZE * 64);
        CrefOutputFormatter.cof.currentRomAddr = currentLocationInROMMemory;
        return currentLocationInMemory - startingLoc;
    }
}

