/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.ImplementedInterface;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.OffsetAndLength;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import java.util.Iterator;
import java.util.TreeSet;

class ClassComponent
extends Safeptr {
    private TreeSet allClasses;

    ClassComponent(byte[] data) {
        super(data, "Class");
    }

    private void addSuperInterfaces(TreeSet superIntf, int iref) {
        superIntf.add(new Integer(iref));
        if (Classref.isExternal(iref)) {
            EfClass ei = Classref.checkExternal(iref);
            int i = 0;
            while (i < ei.interfaces.length) {
                superIntf.add(new Integer(Classref.refForName(ei.interfaceName(i))));
                ++i;
            }
        } else {
            ClassInfo iinfo = this.infoOfs(iref);
            int i = 0;
            while (i < iinfo.interfaceCount()) {
                this.addSuperInterfaces(superIntf, iinfo.superinterface(i));
                ++i;
            }
        }
    }

    private void checkClassField(ClassInfo cinfo, FieldDescriptor f, TreeSet allInstanceFields) {
        if ((f.flags() & 8) != 0) {
            return;
        }
        int typOfs = f.type();
        int fieldsize = typOfs == 32773 ? 2 : 1;
        int token = f.token();
        if (token + fieldsize > cinfo.declaredInstanceSize()) {
            throw new VerifierError("ClassComponent.13", token, (Object)f);
        }
        if ((typOfs & 0x8000) == 0) {
            if (cinfo.firstReferenceIndex() == 255) {
                throw new VerifierError("ClassComponent.35");
            }
            if (token < cinfo.firstReferenceIndex() || token >= cinfo.firstReferenceIndex() + cinfo.referenceCount()) {
                throw new VerifierError("ClassComponent.36", token, (Object)f);
            }
        } else if ((f.flags() & 5) == 0) {
            if (cinfo.firstReferenceIndex() != 255 && token < cinfo.firstReferenceIndex() + cinfo.referenceCount()) {
                throw new VerifierError("ClassComponent.48", token, (Object)f);
            }
        } else if (cinfo.firstReferenceIndex() != 255 && token + fieldsize > cinfo.firstReferenceIndex()) {
            throw new VerifierError("ClassComponent.49", token, (Object)f);
        }
        if (!allInstanceFields.add(new OffsetAndLength(token, fieldsize))) {
            throw new VerifierError("ClassComponent.32", token);
        }
    }

    static void checkClassImplIntf(ClassDescriptor cdesc, ClassInfo cinfo, ImplementedInterface intf) {
        int intfref = intf.interfaceImpl();
        Classref.check(intfref);
        if (!Classref.implementsInterface(cdesc.thisClass(), intfref)) {
            throw new VerifierError("ClassComponent.21", intfref);
        }
        if (!Classref.isExternal(intfref) && intfref >= cdesc.thisClass()) {
            throw new VerifierError("ClassComponent.43");
        }
        int intfToken = 0;
        while (intfToken < intf.count()) {
            int implToken = intf.indexMethod(intfToken);
            MethodTypeAndFlags intfMtyf = Methodref.findByToken(intf.interfaceImpl(), intfToken, false);
            if (intfMtyf == null) {
                throw new VerifierError("ClassComponent.22", intf.interfaceImpl());
            }
            MethodTypeAndFlags implMtyf = Methodref.findByToken(cdesc.thisClass(), implToken, false);
            if (implMtyf == null) {
                throw new VerifierError("ClassComponent.23", intf.interfaceImpl());
            }
            if ((implMtyf.flags & 1) == 0) {
                throw new VerifierError("ClassComponent.24");
            }
            if (!implMtyf.mty.equals(intfMtyf.mty)) {
                throw new VerifierError("ClassComponent.25");
            }
            ++intfToken;
        }
        if (intf.count() != Classref.numberOfMethods(intf.interfaceImpl())) {
            throw new VerifierError("ClassComponent.39", intf.interfaceImpl());
        }
    }

    private void checkClassMethod(ClassDescriptor cdesc, ClassInfo cinfo, int ofs, int token, boolean holesNotAllowed) {
        if (ofs == 65535) {
            if (holesNotAllowed) {
                throw new VerifierError("ClassComponent.44");
            }
            MethodDescriptor md = Methodref.virtualMethodDescriptor(cdesc, token);
            if (md != null && (md.flags() & 4) == 0) {
                throw new VerifierError("ClassComponent.45", token);
            }
            return;
        }
        ClassAndMethodDescriptor cmd = Methodref.findDescr(ofs);
        ClassDescriptor defclass = cmd.classDescr;
        MethodDescriptor meth = cmd.methodDescr;
        if (!Classref.isSubclass(cdesc.thisClass(), defclass.thisClass())) {
            throw new VerifierError("ClassComponent.16", ofs);
        }
        if (meth.token() != token) {
            throw new VerifierError("ClassComponent.17", meth.token(), token);
        }
        if ((meth.flags() & 0x88) != 0) {
            throw new VerifierError("ClassComponent.18");
        }
        MethodTypeAndFlags mtyf = Methodref.findByToken(cinfo.superclass(), token, false);
        if (mtyf != null && mtyf.offset != ofs) {
            TypeMethod mty = TypeMethod.parseCap(Cap.TypeDescr.at(meth.type()));
            if (!mty.equals(mtyf.mty)) {
                throw new VerifierError("ClassComponent.19", (Object)mty, (Object)mtyf.mty);
            }
            if ((mtyf.flags & 0x10) != 0) {
                throw new VerifierError("ClassComponent.20");
            }
            if (ClassComponent.visibilityLevel(meth.flags()) < ClassComponent.visibilityLevel(mtyf.flags)) {
                throw new VerifierError("ClassComponent.30");
            }
        }
    }

    void checkFieldTokenOrdering(ClassDescriptor cdesc) {
        int minPrivateToken = Integer.MAX_VALUE;
        int maxPublicToken = Integer.MIN_VALUE;
        int j = 0;
        while (j < cdesc.fieldCount()) {
            FieldDescriptor fdesc = cdesc.fieldDescr(j);
            if ((fdesc.flags() & 8) == 0) {
                int token = fdesc.token();
                if ((fdesc.flags() & 5) == 0) {
                    if (token <= maxPublicToken) {
                        throw new VerifierError("ClassComponent.46", token, (Object)fdesc);
                    }
                    if (token < minPrivateToken) {
                        minPrivateToken = token;
                    }
                } else {
                    if (token >= minPrivateToken) {
                        throw new VerifierError("ClassComponent.47", token, (Object)fdesc);
                    }
                    if (token > maxPublicToken) {
                        maxPublicToken = token;
                    }
                }
            }
            ++j;
        }
    }

    private static void checkMethodsAreProvided(ClassInfo cinfo, int pkg, int base, int count, Safeptr vtable) {
        int i = 0;
        while (i < base + count) {
            MethodTypeAndFlags mtyf;
            int token = pkg + i;
            if (!(i >= base && vtable.u2((i - base) * 2) != 65535 || (mtyf = Methodref.findByToken(cinfo.ofs, token, false)) != null && (mtyf.flags & 0x40) == 0)) {
                throw new VerifierError("ClassComponent.26", token);
            }
            ++i;
        }
    }

    private static boolean classInfoImplementsInterface(int cref, int intfRef) {
        if (Classref.isExternal(cref)) {
            EfClass ec = Classref.checkExternal(cref);
            int i = 0;
            while (i < ec.supers.length) {
                if (Classref.refForName(ec.interfaceName(i)) == intfRef) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        ClassInfo cinfo = Cap.Class.infoOfs(cref);
        ImplementedInterface p = cinfo.firstImplementedInterface();
        int j = cinfo.interfaceCount();
        while (j > 0) {
            if (p.interfaceImpl() == intfRef) {
                return true;
            }
            --j;
            p.next();
        }
        int superRef = cinfo.superclass();
        if (superRef == 65535) {
            return false;
        }
        return ClassComponent.classInfoImplementsInterface(superRef, intfRef);
    }

    ClassInfo infoOfs(int ofs) {
        return new ClassInfo(this.offset(ofs));
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("ClassComponent.100");
        }
        this.allClasses = new TreeSet();
        ClassDescriptor cdesc = Cap.Descriptor.firstClassDescriptor();
        int i = Cap.Descriptor.classCount();
        while (i > 0) {
            ClassInfo cinfo = this.infoOfs(cdesc.thisClass());
            try {
                this.verifyClass(cdesc, cinfo);
            }
            catch (VerifierError e) {
                throw new VerifierError("ClassComponent.1", (Object)cdesc, (Object)cinfo, (Object)e.getMessage());
            }
            --i;
            cdesc.next();
        }
        this.verifyOverlap();
        this.allClasses = null;
    }

    private void verifyClass(ClassDescriptor cdesc, ClassInfo cinfo) {
        int len;
        int j;
        if ((cinfo.flags() & 0xFFFFFFF3) != 0) {
            throw new VerifierError("ClassComponent.2", cinfo.flags());
        }
        if ((cdesc.flags() & 0x40) != 0) {
            if ((cinfo.flags() & 8) == 0) {
                throw new VerifierError("ClassComponent.4");
            }
        } else if ((cinfo.flags() & 8) != 0) {
            throw new VerifierError("ClassComponent.7");
        }
        boolean claimsToBeShareable = (cinfo.flags() & 4) != 0;
        boolean isActuallyShareable = false;
        if (Classref.Shareable != -1) {
            isActuallyShareable = (cinfo.flags() & 8) != 0 ? Classref.extendsInterface(cdesc.thisClass(), Classref.Shareable) : Classref.implementsInterface(cdesc.thisClass(), Classref.Shareable);
        }
        if (claimsToBeShareable != isActuallyShareable) {
            throw new VerifierError("ClassComponent.3");
        }
        if ((cdesc.flags() & 0x40) != 0) {
            TreeSet<Integer> claimedSuperIntf = new TreeSet<Integer>();
            TreeSet actualSuperIntf = new TreeSet();
            j = 0;
            while (j < cinfo.interfaceCount()) {
                int supintf = cinfo.superinterface(j);
                int flags = Classref.checkAndGetAccessFlags(supintf);
                if ((flags & 0x40) == 0) {
                    throw new VerifierError("ClassComponent.5", supintf);
                }
                if (!Classref.isExternal(supintf) && supintf >= cdesc.thisClass()) {
                    throw new VerifierError("ClassComponent.41");
                }
                if (!claimedSuperIntf.add(new Integer(supintf))) {
                    throw new VerifierError("ClassComponent.51", supintf);
                }
                this.addSuperInterfaces(actualSuperIntf, supintf);
                ++j;
            }
            if (!claimedSuperIntf.equals(actualSuperIntf)) {
                throw new VerifierError("ClassComponent.50");
            }
        } else {
            int supclass = cinfo.superclass();
            if (supclass == 65535) {
                if (Cap.Import != null && Cap.Import.count() != 0 || cdesc.token() != 0) {
                    throw new VerifierError("ClassComponent.8");
                }
            } else {
                int flags = Classref.checkAndGetAccessFlags(supclass);
                if ((flags & 0x40) != 0) {
                    throw new VerifierError("ClassComponent.9", supclass);
                }
                if ((flags & 0x10) != 0) {
                    throw new VerifierError("ClassComponent.10", supclass);
                }
                if (!Classref.isExternal(supclass) && supclass >= cdesc.thisClass()) {
                    throw new VerifierError("ClassComponent.42");
                }
            }
            TreeSet allInstanceFields = new TreeSet();
            j = 0;
            while (j < cdesc.fieldCount()) {
                this.checkClassField(cinfo, cdesc.fieldDescr(j), allInstanceFields);
                ++j;
            }
            this.verifyTokenOverlap(allInstanceFields, cinfo.declaredInstanceSize());
            this.checkFieldTokenOrdering(cdesc);
            if (cinfo.referenceCount() == 0 && cinfo.firstReferenceIndex() != 255) {
                throw new VerifierError("ClassComponent.38");
            }
            if (Classref.totalInstanceSize(cinfo.ofs) > 255) {
                Messages.println("ClassComponent.53", cinfo.ofs);
                ++Messages.numWarning;
            }
            int j2 = 0;
            while (j2 < cinfo.publicMethodCount()) {
                this.checkClassMethod(cdesc, cinfo, cinfo.publicMethod(j2), cinfo.publicMethodBase() + j2, false);
                ++j2;
            }
            int j3 = 0;
            while (j3 < cinfo.packageMethodCount()) {
                this.checkClassMethod(cdesc, cinfo, cinfo.packageMethod(j3), cinfo.packageMethodBase() + j3 + 128, true);
                ++j3;
            }
            int j4 = 0;
            while (j4 < cinfo.publicMethodBase()) {
                this.checkClassMethod(cdesc, cinfo, 65535, j4, false);
                ++j4;
            }
            int j5 = 0;
            while (j5 < cinfo.packageMethodBase()) {
                this.checkClassMethod(cdesc, cinfo, 65535, j5 + 128, false);
                ++j5;
            }
            TreeSet<Integer> implementedInterfaces = new TreeSet<Integer>();
            ImplementedInterface p = cinfo.firstImplementedInterface();
            int j6 = cinfo.interfaceCount();
            while (j6 > 0) {
                if (!implementedInterfaces.add(new Integer(p.interfaceImpl()))) {
                    throw new VerifierError("ClassComponent.52", p.interfaceImpl());
                }
                ClassComponent.checkClassImplIntf(cdesc, cinfo, p);
                --j6;
                p.next();
            }
            int j7 = 0;
            while (j7 < cdesc.interfaceCount()) {
                if (!ClassComponent.classInfoImplementsInterface(cdesc.thisClass(), cdesc.interfaceRef(j7))) {
                    throw new VerifierError("ClassComponent.40", cdesc.interfaceRef(j7));
                }
                ++j7;
            }
            if ((cdesc.flags() & 0x80) == 0) {
                ClassComponent.checkMethodsAreProvided(cinfo, 0, cinfo.publicMethodBase(), cinfo.publicMethodCount(), cinfo.publicVtable());
                ClassComponent.checkMethodsAreProvided(cinfo, 128, cinfo.packageMethodBase(), cinfo.packageMethodCount(), cinfo.packageVtable());
            }
        }
        if ((cdesc.flags() & 0x40) == 0) {
            ImplementedInterface p = cinfo.firstImplementedInterface();
            j = cinfo.interfaceCount();
            while (j > 0) {
                p.next();
                --j;
            }
            len = p.ofs - cinfo.ofs;
        } else {
            len = 1 + 2 * cinfo.interfaceCount();
        }
        if (!this.allClasses.add(new OffsetAndLength(cinfo.ofs, len))) {
            throw new VerifierError("ClassComponent.31");
        }
    }

    private void verifyOverlap() {
        Safeptr curr = this.offset(0);
        Iterator cls = this.allClasses.iterator();
        while (cls.hasNext()) {
            OffsetAndLength ol = (OffsetAndLength)cls.next();
            if (ol.offset < curr.ofs) {
                throw new VerifierError("ClassComponent.27", curr.ofs);
            }
            if (ol.offset > curr.ofs) {
                throw new VerifierError("ClassComponent.28", curr.ofs);
            }
            curr.advance(ol.length);
        }
        if (!curr.atComponentEnd()) {
            throw new VerifierError("ClassComponent.29");
        }
    }

    private void verifyTokenOverlap(TreeSet allInstanceFields, int declaredInstanceSize) {
        int curr = 0;
        Iterator tok = allInstanceFields.iterator();
        while (tok.hasNext()) {
            OffsetAndLength ol = (OffsetAndLength)tok.next();
            if (ol.offset < curr) {
                throw new VerifierError("ClassComponent.33", curr);
            }
            if (ol.offset > curr) {
                throw new VerifierError("ClassComponent.34", curr);
            }
            curr += ol.length;
        }
        if (curr != declaredInstanceSize) {
            throw new VerifierError("ClassComponent.34", curr);
        }
    }

    private static int visibilityLevel(int flags) {
        if ((flags & 1) != 0) {
            return 3;
        }
        if ((flags & 4) != 0) {
            return 2;
        }
        if ((flags & 2) != 0) {
            return 0;
        }
        return 1;
    }
}

