/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.AIDintf;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;

class HeaderComponent
extends Safeptr {
    static final int MAGIC_NUMBER = -557121555;
    static final int MINOR_VERSION = 1;
    static final int MAJOR_VERSION = 2;
    private boolean useInts = false;
    boolean supportInts;
    private static byte[] AID_java_lang;

    static {
        byte[] byArray = new byte[7];
        byArray[0] = -96;
        byArray[4] = 98;
        byArray[6] = 1;
        AID_java_lang = byArray;
    }

    HeaderComponent(byte[] data) {
        super(data, "Header");
    }

    void checkIntFlag() {
        if (this.useInts != this.supportInts) {
            if (this.useInts) {
                throw new VerifierError("HeaderComponent.10");
            }
            throw new VerifierError("HeaderComponent.11");
        }
    }

    int flags() {
        return this.u1(6);
    }

    int magic() {
        return this.s4(0);
    }

    int majorVersion() {
        return this.u1(5);
    }

    int minorVersion() {
        return this.u1(4);
    }

    PackageInfo thisPackage() {
        return new PackageInfo(this.offset(7));
    }

    void useInts() {
        this.useInts = true;
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("Header.100");
        }
        if (this.magic() != -557121555) {
            throw new VerifierError("HeaderComponent.1", this.magic());
        }
        if (this.majorVersion() != 2) {
            throw new VerifierError("HeaderComponent.2", this.majorVersion());
        }
        if (this.minorVersion() != 1) {
            throw new VerifierError("HeaderComponent.3", this.minorVersion());
        }
        if ((this.flags() & 0xFFFFFFF8) != 0) {
            throw new VerifierError("HeaderComponent.4", this.flags());
        }
        if ((this.flags() & 2) == 0 != (Cap.Export == null)) {
            throw new VerifierError("HeaderComponent.5");
        }
        if ((this.flags() & 4) == 0 != (Cap.Applet == null)) {
            throw new VerifierError("HeaderComponent.6");
        }
        this.supportInts = (this.flags() & 1) != 0;
        PackageInfo hdr = this.thisPackage();
        if (!AID.same((AIDintf)hdr, AID_java_lang) && Cap.Import == null) {
            throw new VerifierError("HeaderComponent.7");
        }
        int aidLen = hdr.AID_length();
        if (aidLen < 5 || aidLen > 16) {
            throw new VerifierError("HeaderComponent.8", aidLen);
        }
        if (!hdr.offset(hdr.length()).atComponentEnd()) {
            throw new VerifierError("HeaderComponent.9");
        }
    }
}

