/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

class RefLocComponent
extends Safeptr {
    RefLocComponent(byte[] data) {
        super(data, "ReferenceLocation");
    }

    private void addReferencesInMethod(TreeSet byteRefs, TreeSet byte2_refs, MethodDescriptor mdesc) {
        MethodInfo minfo = Cap.Method.methodInfo(mdesc.methodOffset());
        int flags = minfo.flags();
        if ((flags & 4) != 0) {
            return;
        }
        Safeptr pc = (flags & 8) == 0 ? minfo.bytecodeCompact() : minfo.bytecodeExtended();
        int endCode = pc.ofs + mdesc.bytecodeCount();
        while (pc.ofs < endCode) {
            Instr i = Instr.instrAt(pc);
            block0 : switch (i.opcode) {
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 145: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    byte2_refs.add(new Integer(pc.ofs + 1));
                    break;
                }
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 181: 
                case 182: 
                case 183: 
                case 184: {
                    byteRefs.add(new Integer(pc.ofs + 1));
                    break;
                }
                case 142: {
                    byte2_refs.add(new Integer(pc.ofs + 2));
                    break;
                }
                case 148: 
                case 149: {
                    switch (pc.u1(1)) {
                        case 0: 
                        case 14: {
                            byte2_refs.add(new Integer(pc.ofs + 2));
                            break block0;
                        }
                    }
                }
            }
            pc.advance(i.length());
        }
    }

    private void addReflocs(Vector refs, int numRefs, Safeptr p) {
        int ofs = 0;
        int i = 0;
        while (i < numRefs) {
            int delta = p.u1(i);
            ofs += delta;
            if (delta != 255) {
                refs.add(new Integer(ofs));
            }
            ++i;
        }
    }

    int byte2_indexCount() {
        return this.u2(2 + this.byteIndexCount());
    }

    int byteIndexCount() {
        return this.u2(0);
    }

    private void checkReflocEqual(Vector loc1, TreeSet loc2, int len) {
        Enumeration e1 = loc1.elements();
        Iterator i2 = loc2.iterator();
        while (e1.hasMoreElements() && i2.hasNext()) {
            int ofs2;
            int ofs1 = (Integer)e1.nextElement();
            if (ofs1 < (ofs2 = ((Integer)i2.next()).intValue())) {
                throw new VerifierError("RefLocComponent.2", len, ofs1);
            }
            if (ofs1 <= ofs2) continue;
            throw new VerifierError("RefLocComponent.3", len, ofs2);
        }
        if (e1.hasMoreElements()) {
            throw new VerifierError("RefLocComponent.4", len);
        }
        if (i2.hasNext()) {
            throw new VerifierError("RefLocComponent.5", len);
        }
    }

    Safeptr offsetsToByte2Indices() {
        return this.offset(4 + this.byteIndexCount());
    }

    Safeptr offsetsToByteIndices() {
        return this.offset(2);
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("RefLocComponent.100");
        }
        Vector byteRefloc = new Vector();
        Vector byte2_refloc = new Vector();
        this.addReflocs(byteRefloc, this.byteIndexCount(), this.offsetsToByteIndices());
        this.addReflocs(byte2_refloc, this.byte2_indexCount(), this.offsetsToByte2Indices());
        TreeSet byteRefs = new TreeSet();
        TreeSet<Integer> byte2_refs = new TreeSet<Integer>();
        ClassDescriptor c = Cap.Descriptor.firstClassDescriptor();
        int i = Cap.Descriptor.classCount();
        while (i > 0) {
            if ((c.flags() & 0x40) == 0) {
                int j = 0;
                while (j < c.methodCount()) {
                    MethodDescriptor mdesc = c.methodDescr(j);
                    this.addReferencesInMethod(byteRefs, byte2_refs, mdesc);
                    ++j;
                }
            }
            --i;
            c.next();
        }
        int i2 = 0;
        while (i2 < Cap.Method.handlerCount()) {
            ExnHandlerInfo exn = Cap.Method.exceptionHandler(i2);
            if (exn.catchType() != 0) {
                byte2_refs.add(new Integer(exn.ofs + 6));
            }
            ++i2;
        }
        this.checkReflocEqual(byteRefloc, byteRefs, 1);
        this.checkReflocEqual(byte2_refloc, byte2_refs, 2);
        if (4 + this.byteIndexCount() + this.byte2_indexCount() != Cap.ReferenceLocation.size()) {
            throw new VerifierError("RefLocComponent.1");
        }
    }
}

