/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeBase;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.TypeNull;
import com.sun.javacard.offcardverifier.VerifierError;

abstract class Type {
    protected Type beforeNormalization = null;
    static final Type Byte = new TypeBase(3);
    static final Type Short = new TypeBase(4);
    static final Type Int = new TypeBase(5);
    static final Type Int2 = new TypeBase(6);
    static final Type Boolean = new TypeBase(2);
    static final Type Void = new TypeBase(1);
    static final Type BooleanArray = new TypeArray(Boolean);
    static final Type ByteArray = new TypeArray(Byte);
    static final Type ShortArray = new TypeArray(Short);
    static final Type IntArray = new TypeArray(Int);
    static final Type Null = new TypeNull();

    Type() {
    }

    abstract boolean isSubtype(Type var1);

    abstract Type lub(Type var1);

    Type normalize() {
        return this;
    }

    static Type parseCap(Safeptr typtr) {
        TypeMethod mty = TypeMethod.parseCap(typtr);
        if (mty.args.length != 0) {
            throw new VerifierError("Type.1", typtr);
        }
        if (mty.res.equals(Void)) {
            throw new VerifierError("Type.2", typtr);
        }
        return mty.res;
    }

    static Type parseExport(String sig) {
        TypeMethod mty = TypeMethod.parseExport(sig);
        if (mty.args.length != 0) {
            throw new VerifierError("Type.4", sig);
        }
        if (mty.res.equals(Void)) {
            throw new VerifierError("Type.5", sig);
        }
        return mty.res;
    }

    static Type parseField(int tyOfs) {
        if ((tyOfs & 0x8000) == 0) {
            return Type.parseCap(Cap.TypeDescr.at(tyOfs));
        }
        switch (tyOfs) {
            case 32770: {
                return Boolean;
            }
            case 32771: {
                return Byte;
            }
            case 32772: {
                return Short;
            }
            case 32773: {
                return Int;
            }
        }
        throw new VerifierError("Type.3", tyOfs);
    }

    public String toString() {
        if (this.beforeNormalization != null) {
            return this.beforeNormalization.toStringAux();
        }
        return this.toStringAux();
    }

    abstract String toStringAux();

    int wordSize() {
        return 1;
    }
}

