/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Type;

class TypeBase
extends Type {
    int kind;
    static final int VOID = 1;
    static final int BOOLEAN = 2;
    static final int BYTE = 3;
    static final int SHORT = 4;
    static final int INT = 5;
    static final int INT2 = 6;

    TypeBase(int k) {
        this.kind = k;
    }

    public boolean equals(Object ty) {
        return ty != null && ty instanceof TypeBase && ((TypeBase)ty).kind == this.kind;
    }

    public int hashCode() {
        return this.kind;
    }

    boolean isSubtype(Type ty) {
        return ty instanceof TypeBase && ((TypeBase)ty).kind == this.kind;
    }

    Type lub(Type ty) {
        if (ty instanceof TypeBase && ((TypeBase)ty).kind == this.kind) {
            return this;
        }
        return null;
    }

    Type normalize() {
        switch (this.kind) {
            case 2: 
            case 3: {
                TypeBase ty = new TypeBase(4);
                ty.beforeNormalization = this;
                return ty;
            }
        }
        return this;
    }

    String toStringAux() {
        switch (this.kind) {
            case 1: {
                return "void";
            }
            case 2: {
                return "boolean";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "int";
            }
        }
        return "<??" + this.kind + "??>";
    }

    int wordSize() {
        return this.kind == 5 ? 2 : 1;
    }
}

