/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Vector;

public class TypeMethod {
    Type[] args;
    Type res;

    TypeMethod() {
    }

    TypeMethod(Type tyres) {
        this.args = new Type[0];
        this.res = tyres;
    }

    TypeMethod(Type tyarg1, Type tyres) {
        this.args = new Type[1];
        this.args[0] = tyarg1;
        this.res = tyres;
    }

    TypeMethod(Type tyarg1, Type tyarg2, Type tyres) {
        this.args = new Type[2];
        this.args[0] = tyarg1;
        this.args[1] = tyarg2;
        this.res = tyres;
    }

    TypeMethod(Type tyarg1, Type tyarg2, Type tyarg3, Type tyres) {
        this.args = new Type[3];
        this.args[0] = tyarg1;
        this.args[1] = tyarg2;
        this.args[2] = tyarg3;
        this.res = tyres;
    }

    int argumentsWordSize() {
        return this.args.length;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TypeMethod)) {
            return false;
        }
        TypeMethod mty = (TypeMethod)obj;
        if (mty.args.length != this.args.length) {
            return false;
        }
        int i = 0;
        while (i < this.args.length) {
            if (!mty.args[i].equals(this.args[i])) {
                return false;
            }
            ++i;
        }
        return mty.res.equals(this.res);
    }

    static TypeMethod parseCap(Safeptr typtr) {
        Vector<Type> tyvec = new Vector<Type>(4);
        int nibbleCount = typtr.u1(0);
        Safeptr p = typtr.offset(1);
        Type ty = null;
        int i = 0;
        while (i < nibbleCount) {
            if (ty != null) {
                tyvec.add(ty);
                if (ty.equals(Type.Int)) {
                    tyvec.add(Type.Int2);
                }
                ty = null;
            }
            switch (p.nibble(i)) {
                case 1: {
                    ty = Type.Void;
                    break;
                }
                case 2: {
                    ty = Type.Boolean;
                    break;
                }
                case 3: {
                    ty = Type.Byte;
                    break;
                }
                case 4: {
                    ty = Type.Short;
                    break;
                }
                case 5: {
                    ty = Type.Int;
                    break;
                }
                case 6: {
                    int cref = p.nibble(i + 1) << 12 | p.nibble(i + 2) << 8 | p.nibble(i + 3) << 4 | p.nibble(i + 4);
                    Classref.check(cref);
                    ty = new TypeClass(cref);
                    i += 4;
                    break;
                }
                case 10: {
                    ty = Type.BooleanArray;
                    break;
                }
                case 11: {
                    ty = Type.ByteArray;
                    break;
                }
                case 12: {
                    ty = Type.ShortArray;
                    break;
                }
                case 13: {
                    ty = Type.IntArray;
                    break;
                }
                case 14: {
                    int cref = p.nibble(i + 1) << 12 | p.nibble(i + 2) << 8 | p.nibble(i + 3) << 4 | p.nibble(i + 4);
                    Classref.check(cref);
                    ty = new TypeArray(new TypeClass(cref));
                    i += 4;
                    break;
                }
                default: {
                    throw new VerifierError("TypeMethod.1", p.nibble(i), (Object)typtr);
                }
            }
            ++i;
        }
        if (i > nibbleCount) {
            throw new VerifierError("TypeMethod.2", typtr);
        }
        if (ty == null) {
            throw new VerifierError("TypeMethod.3", typtr);
        }
        TypeMethod mty = new TypeMethod();
        mty.res = ty;
        mty.args = new Type[tyvec.size()];
        i = 0;
        while (i < mty.args.length) {
            mty.args[i] = (Type)tyvec.elementAt(i);
            if (mty.args[i].equals(Type.Void)) {
                throw new VerifierError("TypeMethod.4", typtr);
            }
            if (mty.args[i].equals(Type.Int)) {
                Cap.Header.useInts();
            }
            ++i;
        }
        return mty;
    }

    public static TypeMethod parseExport(String sig) {
        Vector<Type> tyvec = new Vector<Type>(4);
        Type ty = null;
        int i = 0;
        while (i < sig.length()) {
            if (ty != null) {
                tyvec.add(ty);
                if (ty.equals(Type.Int)) {
                    tyvec.add(Type.Int2);
                }
                ty = null;
            }
            block0 : switch (sig.charAt(i)) {
                case 'B': {
                    ty = Type.Byte;
                    break;
                }
                case 'I': {
                    ty = Type.Int;
                    break;
                }
                case 'L': {
                    int j = sig.indexOf(59, i + 1);
                    if (j == -1) {
                        throw new VerifierError("TypeMethod.5", sig);
                    }
                    int cref = Classref.refForName(sig.substring(i + 1, j));
                    ty = new TypeClass(cref);
                    i = j;
                    break;
                }
                case 'S': {
                    ty = Type.Short;
                    break;
                }
                case 'Z': {
                    ty = Type.Boolean;
                    break;
                }
                case '[': {
                    int cref;
                    int j;
                    switch (sig.charAt(++i)) {
                        case 'B': {
                            ty = Type.ByteArray;
                            break block0;
                        }
                        case 'I': {
                            ty = Type.IntArray;
                            break block0;
                        }
                        case 'L': {
                            j = sig.indexOf(59, i + 1);
                            if (j == -1) {
                                throw new VerifierError("TypeMethod.6", sig);
                            }
                            cref = Classref.refForName(sig.substring(i + 1, j));
                            ty = new TypeArray(new TypeClass(cref));
                            i = j;
                            break block0;
                        }
                        case 'S': {
                            ty = Type.ShortArray;
                            break block0;
                        }
                        case 'Z': {
                            ty = Type.BooleanArray;
                            break block0;
                        }
                    }
                    throw new VerifierError("TypeMethod.7", (Object)sig.substring(i, i + 1), (Object)sig);
                }
                case 'V': {
                    ty = Type.Void;
                    break;
                }
                default: {
                    throw new VerifierError("TypeMethod.8", (Object)sig.substring(i, i + 1), (Object)sig);
                }
                case '(': 
                case ')': 
            }
            ++i;
        }
        if (ty == null) {
            throw new VerifierError("TypeMethod.9", sig);
        }
        TypeMethod mty = new TypeMethod();
        mty.res = ty;
        mty.args = new Type[tyvec.size()];
        i = 0;
        while (i < mty.args.length) {
            mty.args[i] = (Type)tyvec.elementAt(i);
            if (mty.args[i].equals(Type.Void)) {
                throw new VerifierError("TypeMethod.10", sig);
            }
            ++i;
        }
        return mty;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.res.toString());
        sb.append('(');
        int i = 0;
        while (i < this.args.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.args[i].toString());
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }
}

