/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_ClassRef;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Vector;

public class EfClass
extends EfElement {
    public short token;
    public int accessFlag;
    int nameIndex;
    public int[] supers;
    public int[] interfaces;
    public EfField[] fields;
    public EfMethod[] methods;
    private Vector newMethodList;
    private Vector newFields;
    private boolean sameVersion;
    private boolean refExists;
    private boolean isInterface;
    private static final int validFlags = 3601;
    private static final int abstractFinalFlags = 1040;
    private static final int shareableInterfaceFlags = 2560;

    EfClass(ExportFile ef) {
        super(ef);
    }

    void checkEquality(EfClass ec) {
        this.sameVersion = true;
        int ic1 = this.accessFlag & 0x200;
        if (ic1 == 0 && (this.accessFlag & 0x10) != (ec.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        if ((this.accessFlag & 0x400) != (ec.accessFlag & 0x400)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        if ((this.accessFlag & 0x800) != (ec.accessFlag & 0x800)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        this.compareCommon(ec);
    }

    void checkNewFields(EfClass c2) {
        if (this.newFields.size() > 0 && this.refExists) {
            int i = 0;
            while (i < this.newFields.size()) {
                EfField f2 = (EfField)this.newFields.get(i);
                String descriptor = f2.sig();
                if (descriptor.indexOf("L") < 0 && (f2.accessFlag & 8) <= 0) {
                    throw new VerifierError("RevisionError.22", (Object)f2.name(), (Object)this.thisName());
                }
                ++i;
            }
        }
    }

    private void checkNewMethods(EfClass c2) {
        if (this.newMethodList.size() > 0) {
            if ((this.accessFlag & 0x10) > 0 || (c2.accessFlag & 0x10) > 0 || this.isInterface) {
                return;
            }
            int newSize = this.newMethodList.size();
            int i = 0;
            while (i < newSize) {
                EfMethod m2 = (EfMethod)this.newMethodList.get(i);
                if ((m2.accessFlag & 8) == 0) {
                    throw new VerifierError("RevisionError.19", (Object)m2.name(), (Object)this.thisName());
                }
                ++i;
            }
        }
    }

    void compareCommon(EfClass ec) {
        if (this.token != ec.token) {
            throw new VerifierError("RevisionError.8", this.thisName());
        }
        int ic1 = this.accessFlag & 0x200;
        int ic2 = ec.accessFlag & 0x200;
        if (ic1 != ic2) {
            throw new VerifierError("RevisionError.9", this.thisName());
        }
        if (ic1 == 0) {
            this.compareSuperClasses(ec);
        }
        this.compareInterfaces(ec);
        this.compareMethodLists(ec);
        this.compareFieldLists(ec);
    }

    boolean compareFieldLists(EfClass c2) {
        boolean found = false;
        EfField f1 = null;
        EfField f2 = null;
        this.refExists = false;
        this.newFields = new Vector(c2.fields.length);
        int i = 0;
        while (i < c2.fields.length) {
            this.newFields.addElement(c2.fields[i]);
            ++i;
        }
        int oldSize = this.fields.length;
        int newSize = this.newFields.size();
        if (this.sameVersion) {
            if (oldSize != newSize) {
                throw new VerifierError("RevisionError.20", this.thisName());
            }
        } else if (oldSize == 0) {
            return true;
        }
        int i2 = 0;
        while (i2 < oldSize) {
            String descriptor;
            found = false;
            f1 = this.fields[i2];
            String fieldName1 = f1.name();
            if (!this.refExists && (descriptor = f1.sig()).indexOf("L") >= 0) {
                this.refExists = true;
            }
            int j = 0;
            while (j < this.newFields.size()) {
                f2 = (EfField)this.newFields.get(j);
                String fieldName2 = f2.name();
                if (fieldName1.equals(fieldName2)) {
                    found = true;
                    this.newFields.removeElementAt(j);
                    break;
                }
                ++j;
            }
            if (found) {
                if (this.sameVersion) {
                    f1.checkEquality(f2);
                } else {
                    f1.compareTo(f2);
                }
            } else {
                throw new VerifierError("RevisionError.21", (Object)fieldName1, (Object)this.thisName());
            }
            ++i2;
        }
        return true;
    }

    private void compareInterfaces(EfClass c2) {
        boolean found = false;
        int newSize = 0;
        int oldSize = 0;
        oldSize = this.interfaces.length;
        newSize = c2.interfaces.length;
        if (this.sameVersion && oldSize != newSize) {
            throw new VerifierError("RevisionError.13", this.thisName());
        }
        int i = 0;
        while (i < oldSize) {
            found = false;
            String fromOld = this.interfaceName(i);
            int j = 0;
            while (j < newSize) {
                String fromNew = c2.interfaceName(j);
                if (fromOld.equals(fromNew)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                if (this.isInterface) {
                    throw new VerifierError("RevisionError.14", (Object)fromOld, (Object)this.thisName());
                }
                throw new VerifierError("RevisionError.15", (Object)fromOld, (Object)this.thisName());
            }
            ++i;
        }
    }

    private void compareMethodLists(EfClass c2) {
        boolean found = false;
        EfMethod m1 = null;
        EfMethod m2 = null;
        this.newMethodList = new Vector(c2.methods.length);
        int i = 0;
        while (i < c2.methods.length) {
            this.newMethodList.addElement(c2.methods[i]);
            ++i;
        }
        int oldSize = this.methods.length;
        int newSize = this.newMethodList.size();
        if (this.sameVersion && oldSize != newSize) {
            throw new VerifierError("RevisionError.16", this.thisName());
        }
        int i2 = 0;
        while (i2 < oldSize) {
            found = false;
            m1 = this.methods[i2];
            String methodName1 = m1.name();
            String des1 = m1.sig();
            int j = 0;
            while (j < this.newMethodList.size()) {
                m2 = (EfMethod)this.newMethodList.get(j);
                String methodName2 = m2.name();
                String des2 = m2.sig();
                if (methodName1.equals(methodName2) && des1.equals(des2)) {
                    found = true;
                    this.newMethodList.removeElementAt(j);
                    break;
                }
                ++j;
            }
            if (found) {
                if (this.sameVersion) {
                    m1.checkEquality(m2);
                } else {
                    m1.compareTo(m2);
                }
            } else {
                throw new VerifierError("RevisionError.18", (Object)methodName1, (Object)this.thisName());
            }
            ++i2;
        }
    }

    private void compareSuperClasses(EfClass c2) {
        boolean found = false;
        int newSize = 0;
        int oldSize = 0;
        oldSize = this.supers.length;
        newSize = c2.supers.length;
        if (this.sameVersion && oldSize != newSize) {
            throw new VerifierError("RevisionError.10", this.thisName());
        }
        int i = 0;
        while (i < oldSize) {
            found = false;
            String fromOld = this.superName(i);
            int j = 0;
            while (j < newSize) {
                String fromNew = c2.superName(j);
                if (fromOld.equals(fromNew)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                throw new VerifierError("RevisionError.12", (Object)fromOld, (Object)this.thisName());
            }
            ++i;
        }
    }

    void compareTo(EfClass ec) {
        this.sameVersion = false;
        int ic1 = this.accessFlag & 0x200;
        if (ic1 == 0) {
            this.isInterface = false;
            if ((this.accessFlag & 0x10) < (ec.accessFlag & 0x10)) {
                throw new VerifierError("RevisionError.4", this.thisName());
            }
        } else {
            this.isInterface = true;
        }
        if ((this.accessFlag & 0x400) < (ec.accessFlag & 0x400)) {
            if (this.isInterface) {
                VerifierError.warning("RevisionWarning.2", this.thisName());
            } else {
                throw new VerifierError("RevisionError.5", this.thisName());
            }
        }
        if ((this.accessFlag & 0x800) > (ec.accessFlag & 0x800)) {
            throw new VerifierError("RevisionError.6", this.thisName());
        }
        this.compareCommon(ec);
        this.checkNewMethods(ec);
        this.checkNewFields(ec);
    }

    public int declaredInstanceSize() {
        int size = 0;
        int i = 0;
        while (i < this.fields.length) {
            int s;
            EfField f = this.fields[i];
            if (!f.isStatic() && (s = f.token + f.wordSize()) > size) {
                size = s;
            }
            ++i;
        }
        return size;
    }

    public String interfaceName(int i) {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.interfaces[i]]).classname();
    }

    void read() throws IOException {
        this.token = (short)this.ef.in.readUnsignedByte();
        this.accessFlag = this.ef.in.readUnsignedShort();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.ef.checkClassrefIndex(this.nameIndex);
        int exportSupersCount = this.ef.in.readUnsignedShort();
        this.supers = new int[exportSupersCount];
        int i = 0;
        while (i < exportSupersCount) {
            this.supers[i] = this.ef.in.readUnsignedShort();
            this.ef.checkClassrefIndex(this.supers[i]);
            ++i;
        }
        int exportInterfaceCount = this.ef.in.readUnsignedByte();
        this.interfaces = new int[exportInterfaceCount];
        int i2 = 0;
        while (i2 < exportInterfaceCount) {
            this.interfaces[i2] = this.ef.in.readUnsignedShort();
            this.ef.checkClassrefIndex(this.interfaces[i2]);
            ++i2;
        }
        int exportFieldCount = this.ef.in.readUnsignedShort();
        this.fields = new EfField[exportFieldCount];
        int i3 = 0;
        while (i3 < exportFieldCount) {
            EfField fi = new EfField(this.ef, this.thisName());
            fi.read();
            this.fields[i3] = fi;
            ++i3;
        }
        int exportMethodsCount = this.ef.in.readUnsignedShort();
        this.methods = new EfMethod[exportMethodsCount];
        int i4 = 0;
        while (i4 < exportMethodsCount) {
            EfMethod mi = new EfMethod(this.ef, this.thisName());
            mi.read();
            this.methods[i4] = mi;
            ++i4;
        }
    }

    public String superName(int i) {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.supers[i]]).classname();
    }

    public String thisName() {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.nameIndex]).classname();
    }

    public String toString() {
        return EfNames.prettyClass(this.thisName());
    }

    void verify(HashSet classNames, BitSet classTokens) {
        String name = this.thisName();
        if (!EfNames.validClassName(name)) {
            throw new VerifierError("EfClass.20", name);
        }
        try {
            String pkgname;
            int lastslash = name.lastIndexOf(47);
            String string = pkgname = lastslash == -1 ? "" : name.substring(0, lastslash);
            if (!pkgname.equals(this.ef.thisName())) {
                throw new VerifierError("EfClass.6", EfNames.prettyClass(this.ef.thisName()));
            }
            if ((this.accessFlag & 0xFFFFF1EE) != 0) {
                throw new VerifierError("EfClass.1", this.accessFlag);
            }
            if ((this.accessFlag & 1) == 0) {
                throw new VerifierError("EfClass.2");
            }
            if ((this.accessFlag & 0x200) != 0) {
                if ((this.accessFlag & 0x400) == 0) {
                    throw new VerifierError("EfClass.3");
                }
                if ((this.accessFlag & 0x10) != 0) {
                    throw new VerifierError("EfClass.4");
                }
            }
            if ((this.accessFlag & 0x410) == 1040) {
                throw new VerifierError("EfClass.5");
            }
            boolean claimsToBeShareable = (this.accessFlag & 0x800) != 0;
            boolean isActuallyShareable = this.thisName().equals("javacard/framework/Shareable");
            int i = 0;
            while (i < this.interfaces.length) {
                if (this.interfaceName(i).equals("javacard/framework/Shareable")) {
                    isActuallyShareable = true;
                }
                ++i;
            }
            if (isActuallyShareable != claimsToBeShareable) {
                throw new VerifierError("EfClass.7");
            }
            if ((this.ef.thisPackage().flags & 1) == 0 && (this.accessFlag & 0xA00) != 2560) {
                throw new VerifierError("EfClass.8");
            }
            if (!classNames.add(this.thisName())) {
                throw new VerifierError("EfClass.15");
            }
            if (classTokens.get(this.token)) {
                throw new VerifierError("EfClass.16", this.token);
            }
            classTokens.set(this.token);
            HashSet<String> superNames = new HashSet<String>();
            int i2 = 0;
            while (i2 < this.supers.length) {
                if (!superNames.add(this.superName(i2))) {
                    throw new VerifierError("EfClass.17", EfNames.prettyClass(this.superName(i2)));
                }
                ++i2;
            }
            HashSet<String> interfaceNames = new HashSet<String>();
            int i3 = 0;
            while (i3 < this.interfaces.length) {
                if (!interfaceNames.add(this.interfaceName(i3))) {
                    throw new VerifierError("EfClass.18", EfNames.prettyClass(this.interfaceName(i3)));
                }
                ++i3;
            }
            boolean isInterface = (this.accessFlag & 0x200) != 0;
            HashSet fieldNames = new HashSet();
            BitSet staticFieldTokens = new BitSet();
            BitSet instanceFieldTokens = new BitSet();
            int i4 = 0;
            while (i4 < this.fields.length) {
                this.fields[i4].verify(isInterface, fieldNames, staticFieldTokens, instanceFieldTokens);
                ++i4;
            }
            HashSet methodNames = new HashSet();
            BitSet staticMethodTokens = new BitSet();
            BitSet virtualMethodTokens = new BitSet();
            int i5 = 0;
            while (i5 < this.methods.length) {
                this.methods[i5].verify(isInterface, methodNames, staticMethodTokens, virtualMethodTokens);
                ++i5;
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("EfClass.19", (Object)EfNames.prettyClass(this.thisName()), (Object)e.getMessage());
        }
    }
}

