/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfAttribute;
import com.sun.javacard.offcardverifier.exportfile.EfAttributeConstantValue;
import com.sun.javacard.offcardverifier.exportfile.EfAttributeGeneric;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Utf8;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;

public class EfField
extends EfElement {
    public short token;
    public int accessFlag;
    int nameIndex;
    int descriptorIndex;
    public EfAttribute[] attributes;
    private boolean sameVersion;
    private String parentClassName;
    private static final int validFlags = 29;
    private static final int staticFinalFlags = 24;
    private static final int publicProtectedFlags = 5;

    EfField(ExportFile ef, String className) {
        super(ef);
        this.parentClassName = className;
    }

    public void checkEquality(EfField newField) {
        this.sameVersion = true;
        this.compareCommon(newField);
        if ((this.accessFlag & 1) != (newField.accessFlag & 1)) {
            throw new VerifierError("RevisionError.30", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 4) != (newField.accessFlag & 4)) {
            throw new VerifierError("RevisionError.30", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x10) != (newField.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.30", (Object)this.name(), (Object)this.parentClassName);
        }
    }

    public void compareCommon(EfField newField) {
        if (this.token != newField.token) {
            throw new VerifierError("RevisionError.31", (Object)this.name(), (Object)this.parentClassName);
        }
        if (!this.sig().equals(newField.sig())) {
            throw new VerifierError("RevisionError.32", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 8) != (newField.accessFlag & 8)) {
            throw new VerifierError("RevisionError.39", (Object)this.name(), (Object)this.parentClassName);
        }
        EfAttributeConstantValue efa1 = this.constantvalue();
        EfAttributeConstantValue efa2 = newField.constantvalue();
        if (efa1 == null && efa2 != null) {
            throw new VerifierError("RevisionError.33", (Object)this.name(), (Object)this.parentClassName);
        }
        if (efa1 != null && efa2 == null) {
            throw new VerifierError("RevisionError.34", (Object)this.name(), (Object)this.parentClassName);
        }
        if (efa1 != null && efa1.value() != efa2.value()) {
            throw new VerifierError("RevisionError.35", (Object)newField.name(), (Object)this.parentClassName);
        }
    }

    public void compareTo(EfField newField) {
        this.sameVersion = false;
        this.compareCommon(newField);
        if ((this.accessFlag & 1) > (newField.accessFlag & 1)) {
            throw new VerifierError("RevisionError.29", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 4) < (newField.accessFlag & 4)) {
            throw new VerifierError("RevisionError.29", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x10) < (newField.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.33", (Object)this.name(), (Object)this.parentClassName);
        }
    }

    EfAttributeConstantValue constantvalue() {
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i] instanceof EfAttributeConstantValue) {
                return (EfAttributeConstantValue)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EfField)) {
            return false;
        }
        EfField that = (EfField)obj;
        return this.name().equals(that.name()) && this.sig().equals(that.sig());
    }

    public boolean isInlined() {
        String s = this.sig();
        return (this.accessFlag & 0x18) == 24 && (s.equals("B") || s.equals("I") || s.equals("S") || s.equals("Z"));
    }

    public boolean isStatic() {
        return (this.accessFlag & 8) != 0;
    }

    public String name() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.nameIndex]).contents;
    }

    void read() throws IOException {
        this.token = (short)this.ef.in.readUnsignedByte();
        this.accessFlag = this.ef.in.readUnsignedShort();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.ef.checkUtf8Index(this.nameIndex);
        this.descriptorIndex = this.ef.in.readUnsignedShort();
        this.ef.checkUtf8Index(this.descriptorIndex);
        int attributesCount = this.ef.in.readUnsignedShort();
        this.attributes = new EfAttribute[attributesCount];
        int i = 0;
        while (i < attributesCount) {
            int attIndex = this.ef.in.readUnsignedShort();
            int length = this.ef.in.readInt();
            this.ef.checkUtf8Index(attIndex);
            String name = ((EfConstant_Utf8)this.ef.constantPool[attIndex]).contents;
            EfAttribute at = name.equals("ConstantValue") ? new EfAttributeConstantValue(this.ef) : new EfAttributeGeneric(this.ef);
            at.attributeNameIndex = attIndex;
            at.attributeLength = length;
            at.read();
            this.attributes[i] = at;
            ++i;
        }
    }

    public String sig() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.descriptorIndex]).contents;
    }

    public String toString() {
        return EfNames.prettyField(this.name(), this.sig());
    }

    void verify(boolean inInterface, HashSet fieldNames, BitSet staticFieldTokens, BitSet instanceFieldTokens) {
        if (!EfNames.validFieldName(this.name())) {
            throw new VerifierError("EfField.5", this.name());
        }
        if (!EfNames.validFieldDescriptor(this.sig())) {
            throw new VerifierError("EfField.6", this.sig());
        }
        try {
            if ((this.accessFlag & 0xFFFFFFE2) != 0) {
                throw new VerifierError("EfField.1", this.accessFlag);
            }
            if ((this.accessFlag & 5) == 5) {
                throw new VerifierError("EfField.2");
            }
            if ((this.accessFlag & 5) == 0) {
                throw new VerifierError("EfField.3");
            }
            if (inInterface && (this.accessFlag & 0x18) != 24) {
                throw new VerifierError("EfField.4");
            }
            if (!this.isInlined()) {
                if (this.attributes.length != 0) {
                    throw new VerifierError("EfField.7");
                }
            } else {
                if (this.attributes.length != 1 || !(this.attributes[0] instanceof EfAttributeConstantValue)) {
                    throw new VerifierError("EfField.8");
                }
                EfAttributeConstantValue cv = this.constantvalue();
                cv.verify(this.sig());
            }
            if (!fieldNames.add(this)) {
                throw new VerifierError("EfField.9");
            }
            if (this.isInlined()) {
                if (this.token != 255) {
                    throw new VerifierError("EfField.10");
                }
            } else {
                BitSet fieldTokens;
                BitSet bitSet = fieldTokens = this.isStatic() ? staticFieldTokens : instanceFieldTokens;
                if (fieldTokens.get(this.token)) {
                    throw new VerifierError("EfField.11", this.token);
                }
                fieldTokens.set(this.token);
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("EfField.12", (Object)this, (Object)e.getMessage());
        }
    }

    public int wordSize() {
        if (this.sig().equals("I")) {
            return 2;
        }
        return 1;
    }
}

