/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apdutool;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadDevice;
import com.sun.javacard.apduio.CadTransportException;
import com.sun.javacard.apdutool.Main;
import com.sun.javacard.apdutool.Msg;
import com.sun.javacard.apdutool.ParseException;
import com.sun.javacard.apdutool.ReaderWriterError;
import com.sun.javacard.apdutool.ScriptCommand;
import com.sun.javacard.apdutool.ScriptParser;
import com.sun.javacard.apdutool.TokenMgrError;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;

public class ReaderWriter
implements Runnable {
    protected PrintWriter log;
    protected ScriptParser parser;
    protected CadClientInterface cad;
    protected CadClientInterface contactless_cad;
    public byte[] ATR;
    protected boolean printATR = true;
    static final int CONTACTED = 100;
    static final int CONTACTLESS = 101;
    int commMode;

    public ReaderWriter(InputStream inputStream, CadClientInterface cadClientInterface, PrintWriter printWriter) throws IOException {
        this.parser = new ScriptParser(inputStream);
        this.cad = cadClientInterface;
        this.log = printWriter;
        this.commMode = 100;
        this.contactless_cad = null;
    }

    public void setPrintATR(boolean bl) {
        this.printATR = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean bl = true;
        try {
            ScriptCommand scriptCommand;
            block45: while ((scriptCommand = this.parser.getScriptCommand()) != null) {
                switch (scriptCommand.getType()) {
                    case 1: {
                        if (this.log != null && bl && Main.verbose) {
                            this.log.println(Msg.getMessage("readerwriter.2"));
                        }
                        try {
                            this.ATR = this.commMode == 100 ? this.cad.powerUp() : this.contactless_cad.powerUp();
                        }
                        catch (EOFException eOFException) {
                            throw new ReaderWriterError(Msg.getMessage("readerwriter.4"));
                        }
                        if (this.log == null || !this.printATR || !bl) continue block45;
                        Object object = new StringBuffer(4 * this.ATR.length);
                        for (int i = 0; i < this.ATR.length; ++i) {
                            ((StringBuffer)object).append(Msg.toHexString(this.ATR[i]));
                            ((StringBuffer)object).append(" ");
                        }
                        Object object2 = ((StringBuffer)object).toString();
                        Object[] objectArray = new Object[]{object2};
                        Msg.info("readerwriter.1", objectArray);
                        continue block45;
                    }
                    case 2: {
                        if (this.log != null && bl && Main.verbose) {
                            this.log.println(Msg.getMessage("readerwriter.3"));
                        }
                        try {
                            if (this.commMode == 100) {
                                this.cad.powerDown(true);
                            } else {
                                this.contactless_cad.powerDown(false);
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                if (this.log == null || !bl || !Main.verbose) continue block45;
                                interruptedException.printStackTrace();
                            }
                        }
                        catch (IOException iOException) {
                            if (this.log == null || !bl || !Main.verbose) continue block45;
                            iOException.printStackTrace();
                        }
                        continue block45;
                    }
                    case 6: {
                        bl = true;
                        if (this.log == null || !bl) continue block45;
                        this.log.println("OUTPUT ON;");
                        continue block45;
                    }
                    case 7: {
                        if (this.log != null && bl) {
                            this.log.println("OUTPUT OFF;");
                        }
                        bl = false;
                        continue block45;
                    }
                    case 3: {
                        try {
                            Thread.sleep(((Integer)scriptCommand.getData()).intValue());
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.log == null || !bl || !Main.verbose) continue block45;
                            interruptedException.printStackTrace();
                        }
                        continue block45;
                    }
                    case 5: {
                        if (this.log == null || !bl) continue block45;
                        this.log.println(scriptCommand.getData());
                        continue block45;
                    }
                    case 4: {
                        Apdu apdu = (Apdu)scriptCommand.getData();
                        if (apdu.getCommand()[1] == 96) {
                            Msg.warn("special.1", null);
                        }
                        if (this.commMode == 100) {
                            this.cad.exchangeApdu(apdu);
                        } else {
                            this.contactless_cad.exchangeApdu(apdu);
                        }
                        if (this.log == null || !bl) continue block45;
                        this.log.println(apdu);
                        continue block45;
                    }
                    case 8: {
                        if (this.log == null || !bl) continue block45;
                        this.log.println(Msg.getMessage("ext.1"));
                        continue block45;
                    }
                    case 9: {
                        if (this.log == null || !bl) continue block45;
                        this.log.println(Msg.getMessage("ext.2"));
                        continue block45;
                    }
                    case 10: {
                        if (this.log != null && bl && Main.verbose) {
                            this.log.println(Msg.getMessage("cl.1"));
                        }
                        this.commMode = 100;
                        continue block45;
                    }
                    case 11: {
                        Object[] objectArray;
                        Object object2;
                        Object object;
                        if (this.log != null && bl && Main.verbose) {
                            this.log.println(Msg.getMessage("cl.2"));
                        }
                        if (this.contactless_cad == null) {
                            if (Main.serialPortName != null) {
                                throw new IOException(Msg.getMessage("cl.3"));
                            }
                            if (Main.protocolType == -85) {
                                throw new IOException(Msg.getMessage("cl.3"));
                            }
                            object = null;
                            try {
                                object = new Socket(Main.hostName, Main.port + 1);
                            }
                            catch (Exception exception) {
                                throw new IOException(Msg.getMessage("cl.4"));
                            }
                            ((Socket)object).setTcpNoDelay(true);
                            object2 = new BufferedInputStream(((Socket)object).getInputStream());
                            objectArray = new BufferedOutputStream(((Socket)object).getOutputStream());
                            this.contactless_cad = CadDevice.getCadClientInstance((byte)Main.protocolType, (InputStream)object2, (OutputStream)objectArray);
                        }
                        this.commMode = 101;
                        continue block45;
                    }
                }
            }
            return;
            throw new ParseException(Msg.getMessage("parser.4"));
        }
        catch (ParseException parseException) {
            try {
                this.cad.powerDown(true);
                throw new ReaderWriterError(Msg.getMessage("ParseException") + parseException.getMessage());
            }
            catch (CadTransportException cadTransportException) {
                if (this.log == null) throw new ReaderWriterError(Msg.getMessage("ParseException") + parseException.getMessage());
                if (!bl) throw new ReaderWriterError(Msg.getMessage("ParseException") + parseException.getMessage());
                if (!Main.verbose) throw new ReaderWriterError(Msg.getMessage("ParseException") + parseException.getMessage());
                cadTransportException.printStackTrace();
                throw new ReaderWriterError(Msg.getMessage("ParseException") + parseException.getMessage());
            }
            catch (IOException iOException) {
                if (this.log == null) throw new ReaderWriterError(Msg.getMessage("ParseException") + parseException.getMessage());
                if (!bl) throw new ReaderWriterError(Msg.getMessage("ParseException") + parseException.getMessage());
                if (!Main.verbose) throw new ReaderWriterError(Msg.getMessage("ParseException") + parseException.getMessage());
                iOException.printStackTrace();
            }
            throw new ReaderWriterError(Msg.getMessage("ParseException") + parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            try {
                this.cad.powerDown(true);
                throw new ReaderWriterError(tokenMgrError.getMessage());
            }
            catch (CadTransportException cadTransportException) {
                if (this.log == null) throw new ReaderWriterError(tokenMgrError.getMessage());
                if (!bl) throw new ReaderWriterError(tokenMgrError.getMessage());
                if (!Main.verbose) throw new ReaderWriterError(tokenMgrError.getMessage());
                cadTransportException.printStackTrace();
                throw new ReaderWriterError(tokenMgrError.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ReaderWriterError(tokenMgrError.getMessage());
        }
        catch (CadTransportException cadTransportException) {
            try {
                this.cad.powerDown(true);
                throw new ReaderWriterError(cadTransportException.getMessage());
            }
            catch (CadTransportException cadTransportException2) {
                if (this.log == null) throw new ReaderWriterError(cadTransportException.getMessage());
                if (!bl) throw new ReaderWriterError(cadTransportException.getMessage());
                if (!Main.verbose) throw new ReaderWriterError(cadTransportException.getMessage());
                cadTransportException2.printStackTrace();
                throw new ReaderWriterError(cadTransportException.getMessage());
            }
            catch (IOException iOException) {
                if (this.log == null) throw new ReaderWriterError(cadTransportException.getMessage());
                if (!bl) throw new ReaderWriterError(cadTransportException.getMessage());
                if (!Main.verbose) throw new ReaderWriterError(cadTransportException.getMessage());
                iOException.printStackTrace();
            }
            throw new ReaderWriterError(cadTransportException.getMessage());
        }
        catch (IOException iOException) {
            try {
                this.cad.powerDown(true);
                throw new ReaderWriterError(iOException.getMessage());
            }
            catch (CadTransportException cadTransportException) {
                if (this.log == null) throw new ReaderWriterError(iOException.getMessage());
                if (!bl) throw new ReaderWriterError(iOException.getMessage());
                if (!Main.verbose) throw new ReaderWriterError(iOException.getMessage());
                cadTransportException.printStackTrace();
                throw new ReaderWriterError(iOException.getMessage());
            }
            catch (EOFException eOFException) {
                if (this.log == null) throw new ReaderWriterError(iOException.getMessage());
                if (!bl) throw new ReaderWriterError(iOException.getMessage());
                if (!Main.verbose) throw new ReaderWriterError(iOException.getMessage());
                throw new ReaderWriterError(Msg.getMessage("readerwriter.4"));
            }
            catch (IOException iOException2) {
                if (this.log == null) throw new ReaderWriterError(iOException.getMessage());
                if (!bl) throw new ReaderWriterError(iOException.getMessage());
                if (!Main.verbose) throw new ReaderWriterError(iOException.getMessage());
                iOException2.printStackTrace();
            }
            throw new ReaderWriterError(iOException.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                this.cad.powerDown(true);
                throw new ReaderWriterError(Msg.getMessage("special.2"));
            }
            catch (CadTransportException cadTransportException) {
                if (this.log == null) throw new ReaderWriterError(Msg.getMessage("special.2"));
                if (!bl) throw new ReaderWriterError(Msg.getMessage("special.2"));
                if (!Main.verbose) throw new ReaderWriterError(Msg.getMessage("special.2"));
                cadTransportException.printStackTrace();
                throw new ReaderWriterError(Msg.getMessage("special.2"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ReaderWriterError(Msg.getMessage("special.2"));
        }
    }
}

