/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.attributes;

import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JConstantValueAttr;
import com.sun.javacard.classfile.attributes.JExceptionsAttr;
import com.sun.javacard.classfile.attributes.JLineNumberTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.attributes.JSourceFileAttr;
import com.sun.javacard.classfile.attributes.JUnknownAttribute;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class JAttribute {
    protected JConstantPool cp;

    JAttribute(JConstantPool cp) {
        this.cp = cp;
    }

    public static final JAttribute create(JConstantPool cp, int index) {
        String name = cp.getConstantUtf8(index).getString();
        if (name.equals("ConstantValue")) {
            return new JConstantValueAttr(cp);
        }
        if (name.equals("SourceFile")) {
            return new JSourceFileAttr(cp);
        }
        if (name.equals("Code")) {
            return new JCodeAttr(cp);
        }
        if (name.equals("LineNumberTable")) {
            return new JLineNumberTableAttr(cp);
        }
        if (name.equals("LocalVariableTable")) {
            return new JLocalVarTableAttr(cp);
        }
        if (name.equals("Exceptions")) {
            return new JExceptionsAttr(cp);
        }
        return new JUnknownAttribute(cp, index);
    }

    public void parse(DataInputStream dis) throws IOException {
    }

    public void resolve() {
    }
}

