/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.constants;

import com.sun.javacard.classfile.constants.JConstant;
import com.sun.javacard.classfile.constants.JConstantClass;
import com.sun.javacard.classfile.constants.JConstantNameAndType;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class JConstantMemberRef
extends JConstant {
    private int classIndex;
    private int nameAndTypeIndex;
    private String classname;
    private String membername;
    private String descriptor;

    public JConstantMemberRef(JConstantPool cp) {
        super(cp);
    }

    public String getClassName() {
        return this.classname;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getMemberName() {
        return this.membername;
    }

    public void parse(DataInputStream dis) throws IOException {
        this.classIndex = dis.readUnsignedShort();
        this.nameAndTypeIndex = dis.readUnsignedShort();
    }

    public void resolve() {
        if (this.resolved) {
            return;
        }
        JConstantClass classConstant = this.cp.getConstantClass(this.classIndex);
        if (!classConstant.resolved) {
            classConstant.resolve();
        }
        this.classname = classConstant.getClassName();
        JConstantNameAndType nameAndTypeConstant = this.cp.getConstantNameAndType(this.nameAndTypeIndex);
        if (!nameAndTypeConstant.resolved) {
            nameAndTypeConstant.resolve();
        }
        this.membername = nameAndTypeConstant.getName();
        this.descriptor = nameAndTypeConstant.getDescriptor();
        this.resolved = true;
    }
}

